/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.moe;

import bluej.Config;
import bluej.editor.moe.MoeEditor;
import bluej.editor.moe.MoeSyntaxDocument;
import bluej.prefmgr.PrefMgr;
import bluej.utility.javafx.FXPlatformRunnable;
import bluej.utility.javafx.JavaFXUtil;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform, ignoreParent=true)
public class ReparseRunner
implements FXPlatformRunnable {
    private MoeEditor editor;
    private int procTime;

    public ReparseRunner(MoeEditor editor) {
        this.editor = editor;
        this.procTime = Config.isRaspberryPi() ? 150 : 5;
    }

    public void run() {
        MoeSyntaxDocument document = this.editor.getSourceDocument();
        long begin = System.currentTimeMillis();
        if (PrefMgr.getScopeHighlightStrength().get() != 0 && document != null && document.pollReparseQueue()) {
            while (System.currentTimeMillis() - begin < (long)this.procTime && document.pollReparseQueue()) {
            }
            JavaFXUtil.runPlatformLater((FXPlatformRunnable)this);
        } else {
            this.editor.reparseRunnerFinished();
        }
    }
}

