/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.moe;

import bluej.Config;
import bluej.pkgmgr.Package;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Dialog;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Window;
import threadchecker.OnThread;
import threadchecker.Tag;

public class PrintDialog
extends Dialog<PrintChoices> {
    public PrintDialog(Window owner, Package pkg) {
        CheckBox checkDiagram;
        CheckBox checkReadme;
        CheckBox checkSource;
        this.setTitle(Config.getString((String)"editor.printDialog.title"));
        this.initOwner(owner);
        this.initModality(Modality.WINDOW_MODAL);
        this.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.CANCEL, ButtonType.OK});
        CheckBox checkLineNumbers = new CheckBox(Config.getString((String)"editor.printDialog.printLineNumbers"));
        checkLineNumbers.setSelected(true);
        CheckBox checkHighlighting = new CheckBox(Config.getString((String)"editor.printDialog.printHighlighting"));
        checkHighlighting.setSelected(false);
        VBox vBox = new VBox(new Node[]{checkLineNumbers, checkHighlighting});
        vBox.setSpacing(8.0);
        if (pkg != null) {
            checkSource = new CheckBox(Config.getString((String)"pkgmgr.printDialog.printSource"));
            checkLineNumbers.disableProperty().bind((ObservableValue)checkSource.selectedProperty().not());
            checkHighlighting.disableProperty().bind((ObservableValue)checkSource.selectedProperty().not());
            vBox.getChildren().add(0, (Object)checkSource);
            if (pkg.isUnnamedPackage()) {
                checkReadme = new CheckBox(Config.getString((String)"pkgmgr.printDialog.printReadme"));
                vBox.getChildren().add(0, (Object)checkReadme);
            } else {
                checkReadme = null;
            }
            checkDiagram = new CheckBox(Config.getString((String)"pkgmgr.printDialog.printDiagram"));
            vBox.getChildren().add(0, (Object)checkDiagram);
        } else {
            checkReadme = null;
            checkDiagram = null;
            checkSource = null;
        }
        this.getDialogPane().setContent((Node)vBox);
        this.setResultConverter(bt -> {
            if (bt == ButtonType.OK) {
                return new PrintChoices(checkDiagram == null ? false : checkDiagram.isSelected(), checkReadme == null ? false : checkReadme.isSelected(), checkSource == null ? false : checkSource.isSelected(), checkLineNumbers.isSelected(), checkHighlighting.isSelected());
            }
            return null;
        });
    }

    @OnThread(value=Tag.Any)
    public static class PrintChoices {
        public final boolean printDiagram;
        public final boolean printReadme;
        public final boolean printSource;
        public final boolean printLineNumbers;
        public final boolean printHighlighting;

        public PrintChoices(boolean printDiagram, boolean printReadme, boolean printSource, boolean printLineNumbers, boolean printHighlighting) {
            this.printDiagram = printDiagram;
            this.printReadme = printReadme;
            this.printSource = printSource;
            this.printLineNumbers = printLineNumbers;
            this.printHighlighting = printHighlighting;
        }
    }
}

