/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.moe;

import bluej.editor.moe.MoeEditor;
import bluej.utility.javafx.FXPlatformRunnable;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import org.fxmisc.undo.UndoManager;
import org.fxmisc.undo.UndoManagerFactory;
import org.reactfx.EventStream;
import threadchecker.OnThread;
import threadchecker.Tag;

public class MoeUndoManager
implements UndoManagerFactory {
    private final UndoManagerFactory delegate;
    private UndoManager undoManager;
    private final MoeEditor editor;
    private BooleanProperty canUndo;
    private BooleanProperty canRedo;

    public MoeUndoManager(MoeEditor editor) {
        this.editor = editor;
        this.delegate = UndoManagerFactory.fixedSizeHistoryFactory((int)100);
    }

    public void compoundEdit(FXPlatformRunnable edit) {
        this.breakEdit();
        edit.run();
        this.breakEdit();
    }

    public BooleanExpression canUndo() {
        if (this.canUndo == null) {
            this.canUndo = new SimpleBooleanProperty();
            this.canUndo.bind((ObservableValue)this.undoManager.undoAvailableProperty());
        }
        return this.canUndo;
    }

    public BooleanExpression canRedo() {
        if (this.canRedo == null) {
            this.canRedo = new SimpleBooleanProperty();
            this.canRedo.bind((ObservableValue)this.undoManager.redoAvailableProperty());
        }
        return this.canRedo;
    }

    public void undo() {
        this.undoManager.undo();
    }

    public void redo() {
        this.undoManager.redo();
    }

    @OnThread(value=Tag.FXPlatform, ignoreParent=true)
    public <C> @OnThread(value=Tag.FXPlatform, ignoreParent=true) UndoManager create(EventStream<C> eventStream, Function<? super C, ? extends C> function, Consumer<C> consumer) {
        this.undoManager = this.delegate.create(eventStream, function, consumer);
        return this.undoManager;
    }

    @OnThread(value=Tag.FXPlatform, ignoreParent=true)
    public <C> @OnThread(value=Tag.FXPlatform, ignoreParent=true) UndoManager create(EventStream<C> eventStream, Function<? super C, ? extends C> function, Consumer<C> consumer, BiFunction<C, C, Optional<C>> biFunction) {
        this.undoManager = this.delegate.create(eventStream, function, consumer, biFunction);
        return this.undoManager;
    }

    public void forgetHistory() {
        this.undoManager.forgetHistory();
    }

    public void breakEdit() {
        this.undoManager.preventMerge();
    }
}

