/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.moe;

import bluej.editor.moe.BlueJSyntaxView;
import bluej.editor.moe.MoeEditor;
import bluej.editor.moe.MoeEditorPane;
import bluej.parser.SourceLocation;
import bluej.utility.Utility;
import bluej.utility.javafx.FXPlatformConsumer;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.fxmisc.richtext.model.TwoDimensional;
import threadchecker.OnThread;
import threadchecker.Tag;

public class MoeErrorManager {
    private final ObservableList<ErrorDetails> errorInfos = FXCollections.observableArrayList();
    private MoeEditor editor;
    private Consumer<Boolean> setNextErrorEnabled;

    public MoeErrorManager(MoeEditor editor, Consumer<Boolean> setNextErrorEnabled) {
        this.editor = editor;
        this.setNextErrorEnabled = setNextErrorEnabled;
    }

    public void addErrorHighlight(int startPos, int endPos, String message, int identifier) {
        if (endPos < startPos) {
            throw new IllegalArgumentException("Error ends before it begins: " + startPos + " to " + endPos);
        }
        MoeEditorPane sourcePane = this.editor.getSourcePane();
        sourcePane.setStyleSpans(startPos, sourcePane.getStyleSpans(startPos, endPos).mapStyles(s -> Utility.setAdd((ImmutableSet)s, (Object)"moe-code-error")));
        this.editor.getSourceDocument().setParagraphAttributesForLineNumber(this.editor.getSourcePane().offsetToPosition(startPos, TwoDimensional.Bias.Forward).getMajor() + 1, Collections.singletonMap(BlueJSyntaxView.ParagraphAttribute.ERROR, true));
        this.errorInfos.add((Object)new ErrorDetails(startPos, endPos, message, identifier));
        this.setNextErrorEnabled.accept(true);
        this.editor.updateHeaderHasErrors(true);
    }

    public void removeAllErrorHighlights() {
        this.editor.getSourceDocument().removeStyleThroughout("moe-code-error");
        this.editor.getSourceDocument().setParagraphAttributes(Collections.singletonMap(BlueJSyntaxView.ParagraphAttribute.ERROR, false));
        this.errorInfos.clear();
        this.setNextErrorEnabled.accept(false);
        this.editor.updateHeaderHasErrors(false);
    }

    public void listenForErrorChange(FXPlatformConsumer<List<ErrorDetails>> listener) {
        this.errorInfos.addListener(c -> listener.accept(Collections.unmodifiableList(this.errorInfos)));
    }

    public ErrorDetails getNextErrorPos(int from) {
        int lowestDist = Integer.MIN_VALUE;
        ErrorDetails next = null;
        for (ErrorDetails err : this.errorInfos) {
            int dist = err.startPos - from;
            if (next != null && (lowestDist > 0 || dist <= 0 && dist > lowestDist) && (lowestDist <= 0 || dist <= 0 || dist > lowestDist)) continue;
            next = err;
            lowestDist = dist;
        }
        return next;
    }

    public void documentContentChanged() {
        this.setNextErrorEnabled.accept(false);
    }

    public ErrorDetails getErrorAtPosition(int pos) {
        return this.errorInfos.stream().filter(e -> e.containsPosition(pos)).findFirst().orElse(null);
    }

    @OnThread(value=Tag.FXPlatform)
    public ErrorDetails getErrorOnLine(int lineIndex) {
        int lineStart = this.editor.getOffsetFromLineColumn(new SourceLocation(lineIndex + 1, 1));
        if (lineIndex + 1 >= this.editor.numberOfLines()) {
            return this.errorInfos.stream().filter(e -> e.endPos >= lineStart).findFirst().orElse(null);
        }
        int lineEnd = this.editor.getOffsetFromLineColumn(new SourceLocation(lineIndex + 2, 1));
        return this.errorInfos.stream().filter(e -> e.startPos <= lineEnd && e.endPos >= lineStart).findFirst().orElse(null);
    }

    public boolean hasErrorHighlights() {
        return !this.errorInfos.isEmpty();
    }

    public static class ErrorDetails {
        public final int startPos;
        public final int endPos;
        public final String message;
        public final int identifier;

        private ErrorDetails(int startPos, int endPos, String message, int identifier) {
            this.startPos = startPos;
            this.endPos = endPos;
            this.message = message;
            this.identifier = identifier;
        }

        public boolean containsPosition(int pos) {
            return this.startPos <= pos && pos <= this.endPos;
        }
    }
}

