/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.moe;

import bluej.Config;
import bluej.editor.moe.BlueJSyntaxView;
import bluej.editor.moe.MoeEditor;
import bluej.prefmgr.PrefMgr;
import bluej.utility.javafx.JavaFXUtil;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.CharStreams;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.BitSet;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.Styleable;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundImage;
import javafx.scene.layout.BackgroundPosition;
import javafx.scene.layout.BackgroundRepeat;
import javafx.scene.layout.BackgroundSize;
import javafx.scene.paint.ImagePattern;
import javafx.scene.paint.Paint;
import org.fxmisc.flowless.Cell;
import org.fxmisc.flowless.VirtualFlow;
import org.fxmisc.richtext.StyledTextArea;
import org.fxmisc.richtext.ViewActions;
import org.fxmisc.richtext.model.EditableStyledDocument;
import org.fxmisc.richtext.model.StyledText;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public final class MoeEditorPane
extends StyledTextArea<BlueJSyntaxView.ScopeInfo, ImmutableSet<String>> {
    public static final String ERROR_CLASS = "moe-code-error";
    private static final Image UNDERLINE_IMAGE = Config.getFixedImageAsFXImage((String)"error-underline.png");
    private final MoeEditor editor;
    private final BooleanProperty showLineNumbers = new SimpleBooleanProperty(true);
    private final AtomicBoolean queuedRecalculation = new AtomicBoolean(false);
    final BitSet visibleLines = new BitSet();

    public boolean isShowLineNumbers() {
        return this.showLineNumbers.get();
    }

    public BooleanProperty showLineNumbersProperty() {
        return this.showLineNumbers;
    }

    public MoeEditorPane(MoeEditor editor, EditableStyledDocument<BlueJSyntaxView.ScopeInfo, StyledText<ImmutableSet<String>>, ImmutableSet<String>> doc, BlueJSyntaxView syntaxView, BooleanExpression compiledStatus) {
        super(null, (p, s) -> {
            if (s == null) {
                p.backgroundProperty().unbind();
                p.setBackground(null);
            } else {
                p.backgroundProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> new Background(new BackgroundImage[]{new BackgroundImage(syntaxView.getImageFor((BlueJSyntaxView.ScopeInfo)s, (int)p.getHeight()), BackgroundRepeat.NO_REPEAT, BackgroundRepeat.NO_REPEAT, new BackgroundPosition(Side.LEFT, 0.0, false, Side.TOP, 0.0, false), BackgroundSize.DEFAULT)}), (Observable[])new Observable[]{p.heightProperty()}));
            }
        }, (Object)ImmutableSet.of(), (t, s) -> {
            if (s.contains((Object)ERROR_CLASS)) {
                t.setUnderlineColor((Paint)new ImagePattern(UNDERLINE_IMAGE, 0.0, 0.0, 2.0, 2.0, false));
                t.setUnderlineWidth((Number)1.5);
            }
            t.getStyleClass().addAll((Collection)s);
        }, doc, false);
        this.editor = editor;
        this.styleProperty().bind((ObservableValue)PrefMgr.getEditorFontCSS((boolean)true));
        this.setParagraphGraphicFactory(syntaxView::getParagraphicGraphic);
        JavaFXUtil.addStyleClass((Styleable)this, (String[])new String[]{"moe-editor-pane"});
        this.showLineNumbers.bind((ObservableValue)PrefMgr.flagProperty((String)"bluej.editor.displayLineNumbers"));
        JavaFXUtil.bindPseudoclass((Node)this, (String)"bj-line-numbers", (BooleanExpression)this.showLineNumbers);
        if (compiledStatus != null) {
            JavaFXUtil.addChangeListenerPlatform((ObservableValue)compiledStatus, compiled -> JavaFXUtil.setPseudoclass((String)"bj-uncompiled", (compiled == false ? 1 : 0) != 0, (Node[])new Node[]{this}));
        }
        syntaxView.setEditorPane(this);
        this.setPrinting(false, true);
        JavaFXUtil.addChangeListenerPlatform((ObservableValue)PrefMgr.getEditorFontSize(), sz -> JavaFXUtil.runPlatformLater(() -> this.requestLayout()));
        VirtualFlow virtualFlow = (VirtualFlow)this.lookup(".virtual-flow");
        this.setupRedrawListener(virtualFlow);
    }

    private <T, C extends Cell<T, ?>> void setupRedrawListener(VirtualFlow<T, C> virtualFlow) {
        virtualFlow.visibleCells().addListener(c -> {
            if (this.editor == null || this.editor.getSourceDocument() == null) {
                return;
            }
            if (this.queuedRecalculation.compareAndSet(false, true)) {
                JavaFXUtil.runPlatformLater(() -> {
                    this.queuedRecalculation.set(false);
                    int earliestIncomplete = -1;
                    int latestIncomplete = -1;
                    this.visibleLines.clear();
                    for (int i = 0; i < this.getParagraphs().size(); ++i) {
                        BlueJSyntaxView.ScopeInfo paragraphStyle = (BlueJSyntaxView.ScopeInfo)this.getDocument().getParagraphStyle(i);
                        if (paragraphStyle != null && paragraphStyle.isIncomplete() && virtualFlow.getCellIfVisible(i).isPresent()) {
                            if (earliestIncomplete == -1) {
                                earliestIncomplete = i;
                            }
                            latestIncomplete = i;
                        }
                        this.visibleLines.set(i, virtualFlow.getCellIfVisible(i).isPresent());
                    }
                    if (earliestIncomplete != -1) {
                        this.editor.getSourceDocument().recalculateScopesForLinesInRange(earliestIncomplete, latestIncomplete);
                        this.editor.getSourceDocument().flushReparseQueue();
                    }
                });
            }
        });
    }

    public void setPrinting(boolean printing, boolean showLineNumbers) {
        JavaFXUtil.selectPseudoClass((Node)this, (int)(printing ? 1 : 0), (String[])new String[]{"bj-screen", "bj-printing"});
        if (printing) {
            this.showLineNumbers.unbind();
            this.showLineNumbers.set(showLineNumbers);
        }
    }

    public void setText(String s) {
        this.replaceText(s);
    }

    public void setCaretPosition(int i) {
        this.moveTo(i);
    }

    public int getCaretDot() {
        return this.getCaretPosition();
    }

    public int getCaretMark() {
        return this.getAnchor();
    }

    public void read(Reader reader) throws IOException {
        this.setText(CharStreams.toString((Readable)reader));
        this.setCaretPosition(0);
        if (this.editor != null) {
            this.editor.undoManager.forgetHistory();
        }
    }

    public void moveCaretPosition(int position) {
        int prev = this.getCaretMark();
        this.selectRange(prev, position);
    }

    public void select(int start, int end) {
        this.selectRange(start, end);
    }

    public void write(Writer writer) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(writer);
        bufferedWriter.write(this.getText());
        bufferedWriter.flush();
    }

    public MoeEditor getEditor() {
        return this.editor;
    }

    public void setFakeCaret(boolean on) {
        this.setShowCaret(on ? ViewActions.CaretVisibility.ON : ViewActions.CaretVisibility.AUTO);
    }
}

