/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.moe;

import bluej.Config;
import bluej.editor.EditorManager;
import bluej.editor.moe.ScopeHighlightingPrefDisplay;
import bluej.pkgmgr.Project;
import bluej.prefmgr.PrefMgr;
import bluej.prefmgr.PrefMgrDialog;
import bluej.prefmgr.PrefPanelListener;
import bluej.utility.javafx.JavaFXUtil;
import java.util.ArrayList;
import java.util.Arrays;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class EditorPrefPanel
extends VBox
implements PrefPanelListener {
    private TextField editorFontField;
    private CheckBox highlightingBox;
    private CheckBox autoIndentBox;
    private CheckBox lineNumbersBox;
    private CheckBox makeBackupBox;
    private CheckBox matchBracketsBox;
    private ScopeHighlightingPrefDisplay scopeHighlightingPrefDisplay;

    public EditorPrefPanel() {
        JavaFXUtil.addStyleClass((Styleable)this, (String[])new String[]{"prefmgr-pref-panel"});
        this.scopeHighlightingPrefDisplay = new ScopeHighlightingPrefDisplay();
        ArrayList<Object> editorPanel = new ArrayList<Object>();
        GridPane topPanel = new GridPane();
        JavaFXUtil.addStyleClass((Styleable)topPanel, (String[])new String[]{"prefmgr-java-editor-top"});
        this.editorFontField = new TextField();
        this.editorFontField.setPrefColumnCount(4);
        topPanel.add(PrefMgrDialog.labelledItem((String)"prefmgr.edit.editorfontsize", (Node)this.editorFontField), 0, 0);
        this.autoIndentBox = new CheckBox(Config.getString((String)"prefmgr.edit.autoindent"));
        topPanel.add((Node)this.autoIndentBox, 1, 0);
        this.highlightingBox = new CheckBox(Config.getString((String)"prefmgr.edit.usesyntaxhilighting"));
        topPanel.add((Node)this.highlightingBox, 0, 1);
        this.makeBackupBox = new CheckBox(Config.getString((String)"prefmgr.edit.makeBackup"));
        topPanel.add((Node)this.makeBackupBox, 1, 1);
        this.lineNumbersBox = new CheckBox(Config.getString((String)"prefmgr.edit.displaylinenumbers"));
        topPanel.add((Node)this.lineNumbersBox, 0, 2);
        this.matchBracketsBox = new CheckBox(Config.getString((String)"prefmgr.edit.matchBrackets"));
        topPanel.add((Node)this.matchBracketsBox, 1, 2);
        HBox bottomPanel = new HBox();
        JavaFXUtil.addStyleClass((Styleable)bottomPanel, (String[])new String[]{"prefmgr-java-scope-hbox"});
        bottomPanel.getChildren().add((Object)this.scopeHighlightingPrefDisplay.getHighlightStrengthSlider());
        bottomPanel.getChildren().add((Object)this.scopeHighlightingPrefDisplay.getColourPalette());
        editorPanel.add(topPanel);
        editorPanel.add(PrefMgrDialog.headedVBox((String)"prefmgr.edit.colortransparency", Arrays.asList(bottomPanel)));
        this.getChildren().add((Object)PrefMgrDialog.headedVBox((String)"prefmgr.edit.editor.title", editorPanel));
    }

    public void beginEditing(Project project) {
        this.editorFontField.setText(String.valueOf(PrefMgr.getEditorFontSize().get()));
        this.highlightingBox.setSelected(PrefMgr.getFlag((String)"bluej.editor.syntaxHilighting"));
        this.autoIndentBox.setSelected(PrefMgr.getFlag((String)"bluej.editor.autoIndent"));
        this.lineNumbersBox.setSelected(PrefMgr.getFlag((String)"bluej.editor.displayLineNumbers"));
        this.makeBackupBox.setSelected(PrefMgr.getFlag((String)"bluej.editor.makeBackup"));
        this.matchBracketsBox.setSelected(PrefMgr.getFlag((String)"bluej.editor.matchBrackets"));
    }

    public void revertEditing(Project project) {
    }

    public void commitEditing(Project project) {
        String fontText = this.editorFontField.getText();
        PrefMgr.setFlag((String)"bluej.editor.syntaxHilighting", (boolean)this.highlightingBox.isSelected());
        PrefMgr.setFlag((String)"bluej.editor.autoIndent", (boolean)this.autoIndentBox.isSelected());
        PrefMgr.setFlag((String)"bluej.editor.displayLineNumbers", (boolean)this.lineNumbersBox.isSelected());
        PrefMgr.setFlag((String)"bluej.editor.makeBackup", (boolean)this.makeBackupBox.isSelected());
        PrefMgr.setFlag((String)"bluej.editor.matchBrackets", (boolean)this.matchBracketsBox.isSelected());
        int strength = this.scopeHighlightingPrefDisplay.getStrengthValue();
        try {
            PrefMgr.setEditorFontSize((int)Integer.parseInt(fontText));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        PrefMgr.setScopeHighlightStrength((int)strength);
        EditorManager.getEditorManager().refreshAll();
    }
}

