/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.moe;

import bluej.Config;
import bluej.editor.moe.MoeEditor;
import bluej.editor.moe.MoeEditorPane;
import bluej.editor.moe.MoeSyntaxDocument;
import bluej.editor.moe.MoeSyntaxEvent;
import bluej.editor.moe.ScopeColors;
import bluej.editor.moe.Token;
import bluej.parser.nodes.NodeTree;
import bluej.parser.nodes.ParsedCUNode;
import bluej.parser.nodes.ParsedNode;
import bluej.parser.nodes.RBTreeNode;
import bluej.prefmgr.PrefMgr;
import bluej.utility.Debug;
import bluej.utility.javafx.FXCache;
import bluej.utility.javafx.FXPlatformConsumer;
import bluej.utility.javafx.JavaFXUtil;
import com.google.common.collect.ImmutableSet;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.Stack;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.binding.ObjectExpression;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.Styleable;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.OverrunStyle;
import javafx.scene.image.Image;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Polygon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Segment;
import org.fxmisc.richtext.model.StyleSpans;
import org.fxmisc.richtext.model.StyleSpansBuilder;
import org.fxmisc.richtext.model.TwoDimensional;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class BlueJSyntaxView {
    private static final boolean PAINT_METHOD_INNER = false;
    private static final int LEFT_INNER_SCOPE_MARGIN = 5;
    private static final int LEFT_OUTER_SCOPE_MARGIN = 2;
    private static final int RIGHT_SCOPE_MARGIN = 4;
    private static final int CURVED_CORNER_SIZE = 4;
    private static final @OnThread(value=Tag.FX) int[][] CORNER_TEMPLATE = new int[][]{{0, 0, 1, 1}, {0, 1, 2, 2}, {1, 2, 2, 2}, {1, 2, 2, 2}};
    private final MoeSyntaxDocument document;
    private final FXCache<ScopeInfo, Image> imageCache;
    private final ScopeColors scopeColors;
    private final BooleanExpression syntaxHighlighting;
    private int imageCacheLineHeight;
    private ReadOnlyDoubleProperty widthProperty;
    MoeEditorPane editorPane;
    private Color BK;
    private Color C1;
    private Color C2;
    private Color C3;
    private Color M1;
    private Color M2;
    private Color S1;
    private Color S2;
    private Color I1;
    private Color I2;
    private final List<Double> cachedSpaceSizes = new ArrayList<Double>();
    private final Map<Integer, EnumSet<ParagraphAttribute>> paragraphAttributes = new HashMap<Integer, EnumSet<ParagraphAttribute>>();
    private final Map<Integer, FXPlatformConsumer<EnumSet<ParagraphAttribute>>> paragraphAttributeListeners = new HashMap<Integer, FXPlatformConsumer<EnumSet<ParagraphAttribute>>>();
    private final Set<WeakReference<Label>> lineLabels = new HashSet<WeakReference<Label>>();
    private final Map<ParsedNode, Integer> nodeIndents = new HashMap<ParsedNode, Integer>();
    private boolean duringUpdate;

    public BlueJSyntaxView(MoeSyntaxDocument document, ScopeColors scopeColors) {
        this.document = document;
        this.syntaxHighlighting = PrefMgr.flagProperty((String)"bluej.editor.syntaxHilighting");
        this.imageCache = new FXCache(s -> this.drawImageFor((ScopeInfo)s, this.imageCacheLineHeight), 40);
        this.scopeColors = scopeColors;
        this.resetColors();
        JavaFXUtil.addChangeListenerPlatform((ObservableValue)PrefMgr.getScopeHighlightStrength(), str -> {
            this.resetColors();
            this.imageCache.clear();
            document.recalculateAllScopes();
        });
        JavaFXUtil.addChangeListenerPlatform((ObservableValue)this.syntaxHighlighting, syn -> document.recalculateAllScopes());
        JavaFXUtil.addChangeListenerPlatform((ObservableValue)PrefMgr.getEditorFontSize(), sz -> {
            this.imageCache.clear();
            this.nodeIndents.clear();
            this.cachedSpaceSizes.clear();
            document.recalculateAllScopes();
        });
        JavaFXUtil.addChangeListenerPlatform(scopeColors.scopeClassColorProperty(), str -> JavaFXUtil.runAfterCurrent(() -> {
            this.resetColors();
            this.imageCache.clear();
            document.recalculateAllScopes();
        }));
    }

    public void setDuringUpdate(boolean duringUpdate) {
        this.duringUpdate = duringUpdate;
    }

    protected final StyleSpans<ImmutableSet<String>> getTokenStylesFor(int lineIndex, MoeSyntaxDocument document) {
        Token.TokenType id;
        StyleSpansBuilder lineStyle = new StyleSpansBuilder();
        Token tokens = document.getTokensForLine(lineIndex);
        boolean addedAny = false;
        while ((id = tokens.id) != Token.TokenType.END) {
            lineStyle.add((Object)(this.syntaxHighlighting.get() ? ImmutableSet.of((Object)id.getCSSClass()) : ImmutableSet.of()), tokens.length);
            addedAny = true;
            tokens = tokens.next;
        }
        if (addedAny) {
            return lineStyle.create();
        }
        return null;
    }

    protected final void paintScopeMarkers(List<ScopeInfo> scopes, int fullWidth, int firstLine, int lastLine, boolean onlyMethods) {
        this.paintScopeMarkers(scopes, fullWidth, firstLine, lastLine, onlyMethods, false);
    }

    List<ScopeInfo> recalculateScopes(int firstLineIncl, int lastLineIncl) {
        ArrayList<ScopeInfo> scopes = new ArrayList<ScopeInfo>();
        this.paintScopeMarkers(scopes, this.widthProperty == null || this.widthProperty.get() == 0.0 ? 200 : (int)this.widthProperty.get(), firstLineIncl, lastLineIncl, false);
        return scopes;
    }

    public Image getImageFor(ScopeInfo s, int lineHeight) {
        if (lineHeight == 0) {
            return new WritableImage(1, 1);
        }
        if (lineHeight != this.imageCacheLineHeight) {
            this.imageCache.clear();
            this.imageCacheLineHeight = lineHeight;
        }
        return BlueJSyntaxView.copy((Image)this.imageCache.get((Object)s));
    }

    private static Image copy(Image original) {
        return new WritableImage(original.getPixelReader(), (int)original.getWidth(), (int)original.getHeight());
    }

    @OnThread(value=Tag.FX)
    private Image drawImageFor(ScopeInfo s, int lineHeight) {
        WritableImage image = new WritableImage(s.nestedScopes.stream().mapToInt(n -> ((ScopeInfo.SingleNestedScope)n).leftRight.rhs + 1).max().orElse(1) + 1, lineHeight);
        for (ScopeInfo.SingleNestedScope singleNestedScope : s.nestedScopes) {
            int y;
            int x;
            int y2;
            int x2;
            LeftRight leftRight = singleNestedScope.leftRight;
            int sideTopMargin = leftRight.starts ? 4 : 0;
            int sideBottomMargin = leftRight.ends ? 4 : 0;
            BlueJSyntaxView.fillRect(image.getPixelWriter(), leftRight.lhs, 0 + sideTopMargin, leftRight.padding, lineHeight - sideBottomMargin - sideTopMargin, leftRight.fillColor);
            for (int y3 = sideTopMargin; y3 < lineHeight - sideBottomMargin; ++y3) {
                image.getPixelWriter().setColor(leftRight.lhs, y3, leftRight.edgeColor);
            }
            if (leftRight.starts) {
                for (x2 = 0; x2 < 4; ++x2) {
                    for (y2 = 0; y2 < 4; ++y2) {
                        if (CORNER_TEMPLATE[y2][x2] == 1) {
                            image.getPixelWriter().setColor(leftRight.lhs + x2, y2, leftRight.edgeColor);
                            continue;
                        }
                        if (CORNER_TEMPLATE[y2][x2] != 2) continue;
                        image.getPixelWriter().setColor(leftRight.lhs + x2, y2, leftRight.fillColor);
                    }
                }
            }
            if (leftRight.ends) {
                for (x2 = 0; x2 < 4; ++x2) {
                    for (y2 = 0; y2 < 4; ++y2) {
                        if (CORNER_TEMPLATE[y2][x2] == 1) {
                            image.getPixelWriter().setColor(leftRight.lhs + x2, lineHeight - 1 - y2, leftRight.edgeColor);
                            continue;
                        }
                        if (CORNER_TEMPLATE[y2][x2] != 2) continue;
                        image.getPixelWriter().setColor(leftRight.lhs + x2, lineHeight - 1 - y2, leftRight.fillColor);
                    }
                }
            }
            Middle middle = singleNestedScope.middle;
            BlueJSyntaxView.fillRect(image.getPixelWriter(), middle.lhs, 0, middle.rhs - middle.lhs, lineHeight, middle.bodyColor);
            if (middle.topColor != null) {
                for (x = middle.lhs; x < middle.rhs; ++x) {
                    image.getPixelWriter().setColor(x, 0, middle.topColor);
                }
            }
            if (middle.bottomColor != null) {
                for (x = middle.lhs; x < middle.rhs; ++x) {
                    image.getPixelWriter().setColor(x, lineHeight - 1, middle.bottomColor);
                }
            }
            BlueJSyntaxView.fillRect(image.getPixelWriter(), leftRight.rhs - leftRight.padding, 0 + sideTopMargin, leftRight.padding, lineHeight - sideBottomMargin - sideTopMargin, leftRight.fillColor);
            for (y2 = sideTopMargin; y2 < lineHeight - sideBottomMargin; ++y2) {
                image.getPixelWriter().setColor(leftRight.rhs, y2, leftRight.edgeColor);
            }
            if (leftRight.starts && leftRight.rhs > 4) {
                for (x = 0; x < 4; ++x) {
                    for (y = 0; y < 4; ++y) {
                        if (CORNER_TEMPLATE[y][x] == 1) {
                            image.getPixelWriter().setColor(leftRight.rhs - x, y, leftRight.edgeColor);
                            continue;
                        }
                        if (CORNER_TEMPLATE[y][x] != 2) continue;
                        image.getPixelWriter().setColor(leftRight.rhs - x, y, leftRight.fillColor);
                    }
                }
            }
            if (!leftRight.ends || leftRight.rhs <= 4) continue;
            for (x = 0; x < 4; ++x) {
                for (y = 0; y < 4; ++y) {
                    if (CORNER_TEMPLATE[y][x] == 1) {
                        image.getPixelWriter().setColor(leftRight.rhs - x, lineHeight - 1 - y, leftRight.edgeColor);
                        continue;
                    }
                    if (CORNER_TEMPLATE[y][x] != 2) continue;
                    image.getPixelWriter().setColor(leftRight.rhs - x, lineHeight - 1 - y, leftRight.fillColor);
                }
            }
        }
        if (s.getAttributes().contains((Object)ParagraphAttribute.STEP_MARK)) {
            BlueJSyntaxView.blend(image, (Color)this.scopeColors.stepMarkOverlayColorProperty().get());
        } else if (s.getAttributes().contains((Object)ParagraphAttribute.BREAKPOINT)) {
            BlueJSyntaxView.blend(image, (Color)this.scopeColors.breakpointOverlayColorProperty().get());
        }
        return image;
    }

    @OnThread(value=Tag.FX)
    private static void blend(WritableImage image, Color rgba) {
        Color c = new Color(rgba.getRed(), rgba.getGreen(), rgba.getBlue(), 1.0);
        int x = 0;
        while ((double)x < image.getWidth()) {
            int y = 0;
            while ((double)y < image.getHeight()) {
                Color prev = image.getPixelReader().getColor(x, y);
                image.getPixelWriter().setColor(x, y, prev.interpolate(c, rgba.getOpacity()));
                ++y;
            }
            ++x;
        }
    }

    @OnThread(value=Tag.FX)
    private static void fillRect(PixelWriter pixelWriter, int x, int y, int w, int h, Color c) {
        if (x < 0) {
            w -= -x;
            x = 0;
        }
        if (y < 0) {
            h -= -y;
            y = 0;
        }
        for (int i = 0; i < w; ++i) {
            for (int j = 0; j < h; ++j) {
                pixelWriter.setColor(x + i, y + j, c);
            }
        }
    }

    public void setEditorPane(MoeEditorPane editorPane) {
        this.editorPane = editorPane;
        this.widthProperty = editorPane.widthProperty();
        JavaFXUtil.addChangeListenerPlatform((ObservableValue)this.widthProperty, w -> this.document.fireChangedUpdate(null));
        JavaFXUtil.addChangeListenerPlatform((ObservableValue)editorPane.showLineNumbersProperty(), showLineNumbers -> {
            Iterator<WeakReference<Label>> iterator = this.lineLabels.iterator();
            while (iterator.hasNext()) {
                WeakReference<Label> weakLabel = iterator.next();
                Label l = (Label)weakLabel.get();
                if (l != null) {
                    if (((StackPane)l.getGraphic()).getChildren().stream().anyMatch(Node::isVisible) || !showLineNumbers.booleanValue()) {
                        l.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
                        continue;
                    }
                    l.setContentDisplay(ContentDisplay.TEXT_ONLY);
                    continue;
                }
                iterator.remove();
            }
        });
    }

    protected void paintScopeMarkers(List<ScopeInfo> scopes, int fullWidth, int firstLine, int lastLine, boolean onlyMethods, boolean small) {
        MoeSyntaxDocument.Element map = this.document.getDefaultRootElement();
        ParsedCUNode rootNode = this.document.getParsedNode();
        if (rootNode == null) {
            return;
        }
        int aboveLine = firstLine - 1;
        LinkedList<NodeTree.NodeAndPosition<ParsedNode>> prevScopeStack = new LinkedList<NodeTree.NodeAndPosition<ParsedNode>>();
        int curLine = firstLine;
        try {
            ThreeLines lines = new ThreeLines();
            lines.aboveLineSeg = new Segment();
            lines.thisLineSeg = new Segment();
            lines.belowLineSeg = new Segment();
            lines.aboveLineEl = null;
            if (aboveLine >= 0) {
                lines.aboveLineEl = map.getElement(aboveLine);
                this.document.getText(lines.aboveLineEl.getStartOffset(), lines.aboveLineEl.getEndOffset() - lines.aboveLineEl.getStartOffset(), lines.aboveLineSeg);
            }
            lines.belowLineEl = null;
            if (firstLine + 1 < map.getElementCount()) {
                lines.belowLineEl = map.getElement(firstLine + 1);
                this.document.getText(lines.belowLineEl.getStartOffset(), lines.belowLineEl.getEndOffset() - lines.belowLineEl.getStartOffset(), lines.belowLineSeg);
            }
            lines.thisLineEl = map.getElement(firstLine);
            this.document.getText(lines.thisLineEl.getStartOffset(), lines.thisLineEl.getEndOffset() - lines.thisLineEl.getStartOffset(), lines.thisLineSeg);
            this.getScopeStackAfter((ParsedNode)rootNode, 0, lines.thisLineEl.getStartOffset(), prevScopeStack);
            while (curLine <= lastLine) {
                ScopeInfo scope = new ScopeInfo(this.getParagraphAttributes(curLine + 1));
                scopes.add(scope);
                if (!prevScopeStack.isEmpty()) {
                    this.drawScopes(fullWidth, scope, this.document, lines, prevScopeStack, small, onlyMethods, 0);
                    if (++curLine > lastLine) continue;
                    lines.aboveLineEl = lines.thisLineEl;
                    lines.thisLineEl = lines.belowLineEl;
                    lines.belowLineEl = curLine + 1 < map.getElementCount() ? map.getElement(curLine + 1) : null;
                    Segment oldAbove = lines.aboveLineSeg;
                    lines.aboveLineSeg = lines.thisLineSeg;
                    lines.thisLineSeg = lines.belowLineSeg;
                    lines.belowLineSeg = oldAbove;
                    if (lines.belowLineEl == null) continue;
                    this.document.getText(lines.belowLineEl.getStartOffset(), lines.belowLineEl.getEndOffset() - lines.belowLineEl.getStartOffset(), lines.belowLineSeg);
                    continue;
                }
                break;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void drawScopes(int fullWidth, ScopeInfo scopes, MoeSyntaxDocument document, ThreeLines lines, List<NodeTree.NodeAndPosition<ParsedNode>> prevScopeStack, boolean small, boolean onlyMethods, int nodeDepth) throws BadLocationException {
        Color[] colors;
        int rbound;
        int napEnd;
        int napPos;
        NodeTree.NodeAndPosition nap;
        int rightMargin = small ? 0 : 20;
        ListIterator<NodeTree.NodeAndPosition<ParsedNode>> li = prevScopeStack.listIterator();
        DrawInfo drawInfo = new DrawInfo(scopes);
        drawInfo.lines = lines;
        drawInfo.small = small;
        while (li.hasNext()) {
            nap = li.next();
            napPos = nap.getPosition();
            napEnd = nap.getEnd();
            if (napPos >= lines.thisLineEl.getEndOffset()) {
                return;
            }
            if (!this.drawNode(drawInfo, nap, onlyMethods)) continue;
            if (this.nodeSkipsEnd(napPos, napEnd, lines.thisLineEl, lines.thisLineSeg)) {
                ++nodeDepth;
                break;
            }
            int xpos = this.getNodeIndent(document, nap, lines.thisLineEl, lines.thisLineSeg);
            if (xpos != -1 && xpos <= fullWidth) {
                boolean starts = this.nodeSkipsStart(nap, lines.aboveLineEl, lines.aboveLineSeg);
                boolean ends = this.nodeSkipsEnd(napPos, napEnd, lines.belowLineEl, lines.belowLineSeg);
                rbound = this.getNodeRBound(nap, fullWidth - rightMargin, nodeDepth, lines.thisLineEl, lines.thisLineSeg);
                drawInfo.node = (ParsedNode)nap.getNode();
                drawInfo.starts = starts;
                drawInfo.ends = ends;
                colors = this.colorsForNode(drawInfo.node);
                drawInfo.color1 = colors[0];
                drawInfo.color2 = colors[1];
                drawInfo.scopes.nestedScopes.add(this.calculatedNestedScope(drawInfo, xpos, rbound));
            } else if (xpos == -1) {
                drawInfo.scopes.incomplete = true;
            }
            ++nodeDepth;
        }
        --nodeDepth;
        li = prevScopeStack.listIterator(prevScopeStack.size());
        nap = li.previous();
        napPos = nap.getPosition();
        napEnd = napPos + nap.getSize();
        while (napEnd <= lines.thisLineEl.getEndOffset()) {
            li.remove();
            if (this.drawNode(drawInfo, nap, onlyMethods)) {
                --nodeDepth;
            }
            if (!li.hasPrevious()) {
                return;
            }
            NodeTree.NodeAndPosition<ParsedNode> napParent = li.previous();
            li.next();
            NodeTree.NodeAndPosition nextNap = nap.nextSibling();
            napPos = napParent.getPosition();
            napEnd = napPos + napParent.getSize();
            nap = napParent;
            while (nextNap != null) {
                li.add((NodeTree.NodeAndPosition<ParsedNode>)nextNap);
                li.previous();
                li.next();
                napPos = nextNap.getPosition();
                napEnd = napPos + nextNap.getSize();
                if (napPos < lines.thisLineEl.getEndOffset() && !this.nodeSkipsStart((NodeTree.NodeAndPosition<ParsedNode>)nextNap, lines.thisLineEl, lines.thisLineSeg) && this.drawNode(drawInfo, (NodeTree.NodeAndPosition<ParsedNode>)nextNap, onlyMethods)) {
                    int xpos = this.getNodeIndent(document, (NodeTree.NodeAndPosition<ParsedNode>)nextNap, lines.thisLineEl, lines.thisLineSeg);
                    rbound = this.getNodeRBound((NodeTree.NodeAndPosition<ParsedNode>)nextNap, fullWidth - rightMargin, ++nodeDepth, lines.thisLineEl, lines.thisLineSeg);
                    drawInfo.node = (ParsedNode)nextNap.getNode();
                    colors = this.colorsForNode(drawInfo.node);
                    drawInfo.color1 = colors[0];
                    drawInfo.color2 = colors[1];
                    drawInfo.starts = this.nodeSkipsStart((NodeTree.NodeAndPosition<ParsedNode>)nextNap, lines.aboveLineEl, lines.aboveLineSeg);
                    drawInfo.ends = this.nodeSkipsEnd(napPos, napEnd, lines.belowLineEl, lines.belowLineSeg);
                    if (xpos != -1 && xpos <= fullWidth) {
                        drawInfo.scopes.nestedScopes.add(this.calculatedNestedScope(drawInfo, xpos, rbound));
                    }
                }
                nap = nextNap;
                nextNap = ((ParsedNode)nextNap.getNode()).findNodeAtOrAfter(napPos, napPos);
            }
        }
    }

    private OptionalInt getLeftEdge(int startOffset) {
        block11: {
            if (this.editorPane == null) {
                return OptionalInt.empty();
            }
            TwoDimensional.Position position = this.document.offsetToPosition(startOffset);
            boolean allSpaces = this.document.getDocument().getParagraph(position.getMajor()).getText().substring(0, position.getMinor()).chars().allMatch(c -> c == 32);
            if (!(this.editorPane.visibleLines.get(position.getMajor()) || allSpaces && this.cachedSpaceSizes.size() > 4)) {
                return OptionalInt.empty();
            }
            if (allSpaces) {
                int numberOfSpaces = position.getMinor();
                while (numberOfSpaces >= this.cachedSpaceSizes.size()) {
                    Optional screenBounds = Optional.empty();
                    if (!this.duringUpdate) {
                        screenBounds = this.editorPane.getCharacterBoundsOnScreen(startOffset - numberOfSpaces + this.cachedSpaceSizes.size(), startOffset - numberOfSpaces + this.cachedSpaceSizes.size() + 1);
                    }
                    if (!screenBounds.isPresent()) {
                        if (this.cachedSpaceSizes.size() >= 4) {
                            int highestSpaces = this.cachedSpaceSizes.size() - 1;
                            return OptionalInt.of((int)(this.cachedSpaceSizes.get(highestSpaces) / (double)highestSpaces * (double)numberOfSpaces));
                        }
                        return OptionalInt.empty();
                    }
                    double indent = this.editorPane.screenToLocal((Bounds)screenBounds.get()).getMinX() - 24.0;
                    this.cachedSpaceSizes.add(indent);
                }
                return OptionalInt.of(this.cachedSpaceSizes.get(numberOfSpaces).intValue());
            }
            try {
                Optional screenBounds = Optional.empty();
                if (!this.duringUpdate && startOffset + 1 < this.editorPane.getLength()) {
                    screenBounds = this.editorPane.getCharacterBoundsOnScreen(startOffset, startOffset + 1);
                }
                if (screenBounds.isPresent()) {
                    double indent = this.editorPane.screenToLocal((Bounds)screenBounds.get()).getMinX() - 24.0;
                    return OptionalInt.of((int)indent);
                }
            }
            catch (IllegalArgumentException | IndexOutOfBoundsException e) {
                if (startOffset >= this.editorPane.getLength() - 1) break block11;
                Debug.reportError((Throwable)e);
            }
        }
        return OptionalInt.empty();
    }

    private boolean drawNode(DrawInfo info, NodeTree.NodeAndPosition<ParsedNode> nap, boolean onlyMethods) {
        int napPos = nap.getPosition();
        int napEnd = napPos + nap.getSize();
        if (napPos >= info.lines.thisLineEl.getEndOffset()) {
            return false;
        }
        if (!((ParsedNode)nap.getNode()).isContainer() && !((ParsedNode)nap.getNode()).isInner()) {
            return false;
        }
        if (onlyMethods) {
            return ((ParsedNode)nap.getNode()).getNodeType() == 2;
        }
        if (this.nodeSkipsStart(nap, info.lines.thisLineEl, info.lines.thisLineSeg)) {
            return false;
        }
        return !this.nodeSkipsEnd(napPos, napEnd, info.lines.thisLineEl, info.lines.thisLineSeg);
    }

    private Color getBackgroundColor() {
        return this.BK;
    }

    private Color[] colorsForNode(ParsedNode node) {
        if (node.isInner()) {
            return new Color[]{this.C3, this.getBackgroundColor()};
        }
        if (node.getNodeType() == 2) {
            return new Color[]{this.M1, this.M2};
        }
        if (node.getNodeType() == 3) {
            return new Color[]{this.I1, this.I2};
        }
        if (node.getNodeType() == 4 || node.getNodeType() == 0) {
            return new Color[]{this.S1, this.S2};
        }
        return new Color[]{this.C1, this.C2};
    }

    private ScopeInfo.SingleNestedScope calculatedNestedScope(DrawInfo info, int xpos, int rbound) {
        if (!info.small) {
            xpos -= info.node.isInner() ? 5 : 2;
        }
        int hoffs = info.small ? 0 : 4;
        return new ScopeInfo.SingleNestedScope(new LeftRight(xpos, rbound, hoffs, info.starts, info.ends, info.color2, info.color1), this.getScopeMiddle(info, xpos + hoffs, rbound));
    }

    private Middle getScopeMiddle(DrawInfo info, int xpos, int rbounds) {
        Color color1 = info.color1;
        Color color2 = info.color2;
        boolean startsThisLine = info.starts;
        boolean endsThisLine = info.ends;
        Middle middle = new Middle(color2, xpos, rbounds - 1);
        if (startsThisLine) {
            middle.drawTop(color1);
        }
        if (endsThisLine) {
            middle.drawBottom(color1);
        }
        return middle;
    }

    private int getNodeRBound(NodeTree.NodeAndPosition<ParsedNode> nap, int fullWidth, int nodeDepth, MoeSyntaxDocument.Element lineEl, Segment lineSeg) throws BadLocationException {
        int napEnd = nap.getEnd();
        int rbound = fullWidth - nodeDepth * 4;
        if (lineEl == null || napEnd >= lineEl.getEndOffset()) {
            return rbound;
        }
        if (napEnd < lineEl.getStartOffset()) {
            return rbound;
        }
        int nwsb = this.findNonWhitespaceComment(nap, lineEl, lineSeg, napEnd - lineEl.getStartOffset());
        if (nwsb != -1) {
            OptionalInt eboundsX = this.getLeftEdge(napEnd);
            if (eboundsX.isPresent()) {
                return Math.min(rbound, eboundsX.getAsInt());
            }
            return rbound;
        }
        return rbound;
    }

    private boolean nodeSkipsStart(NodeTree.NodeAndPosition<ParsedNode> nap, MoeSyntaxDocument.Element lineEl, Segment segment) {
        if (lineEl == null) {
            return true;
        }
        int napPos = nap.getPosition();
        int napEnd = nap.getEnd();
        if (napPos > lineEl.getStartOffset() && napEnd > lineEl.getEndOffset()) {
            if (napPos >= lineEl.getEndOffset()) {
                return true;
            }
            int nws = this.findNonWhitespaceComment(nap, lineEl, segment, napPos - lineEl.getStartOffset());
            if (nws == -1) {
                return true;
            }
        }
        return false;
    }

    private boolean nodeSkipsEnd(int napPos, int napEnd, MoeSyntaxDocument.Element lineEl, Segment segment) {
        if (lineEl == null) {
            return true;
        }
        if (napEnd < lineEl.getEndOffset() && napPos < lineEl.getStartOffset()) {
            if (napEnd <= lineEl.getStartOffset()) {
                return true;
            }
            if (napEnd >= lineEl.getEndOffset()) {
                return false;
            }
            int nws = this.findNonWhitespace(segment, 0);
            if (nws == -1 || lineEl.getStartOffset() + nws >= napEnd) {
                return true;
            }
        }
        return false;
    }

    private int getNodeIndent(MoeSyntaxDocument doc, NodeTree.NodeAndPosition<ParsedNode> nap, MoeSyntaxDocument.Element lineEl, Segment segment) throws BadLocationException {
        OptionalInt lboundsX;
        int nws;
        if (lineEl == null) {
            return Integer.MAX_VALUE;
        }
        int napPos = nap.getPosition();
        int napEnd = nap.getEnd();
        if (napPos >= lineEl.getEndOffset()) {
            return Integer.MAX_VALUE;
        }
        if (napEnd <= lineEl.getStartOffset()) {
            return Integer.MAX_VALUE;
        }
        if (this.nodeSkipsStart(nap, lineEl, segment) || this.nodeSkipsEnd(napPos, napEnd, lineEl, segment)) {
            return Integer.MAX_VALUE;
        }
        Integer indent = this.nodeIndents.get(nap.getNode());
        if (indent == null || indent <= 0) {
            if (this.editorPane != null && this.editorPane.visibleLines.get(doc.offsetToPosition(lineEl.getStartOffset()).getMajor())) {
                indent = this.getNodeIndent(doc, nap);
                this.nodeIndents.put((ParsedNode)nap.getNode(), indent);
            } else {
                indent = -1;
            }
        }
        int xpos = indent;
        if (napPos > lineEl.getStartOffset() && (nws = this.findNonWhitespaceBwards(segment, napPos - lineEl.getStartOffset() - 1, 0)) != -1 && (lboundsX = this.getLeftEdge(lineEl.getStartOffset() + nws + 1)).isPresent()) {
            xpos = Math.max(xpos, lboundsX.getAsInt());
        }
        return xpos;
    }

    private int getNodeIndent(MoeSyntaxDocument doc, NodeTree.NodeAndPosition<ParsedNode> nap) {
        try {
            int indent = Integer.MAX_VALUE;
            int curpos = nap.getPosition();
            int napEnd = nap.getEnd();
            MoeSyntaxDocument.Element map = doc.getDefaultRootElement();
            Stack<Object> scopeStack = new Stack<Object>();
            scopeStack.add(nap);
            block2: while (curpos < napEnd) {
                NodeTree.NodeAndPosition top = (NodeTree.NodeAndPosition)scopeStack.get(scopeStack.size() - 1);
                while (top.getEnd() <= curpos) {
                    scopeStack.remove(scopeStack.size() - 1);
                    top = (NodeTree.NodeAndPosition)scopeStack.get(scopeStack.size() - 1);
                }
                NodeTree.NodeAndPosition nextChild = ((ParsedNode)top.getNode()).findNodeAt(curpos + 1, top.getPosition());
                while (nextChild != null && nextChild.getPosition() <= curpos) {
                    if (((ParsedNode)nextChild.getNode()).isInner()) {
                        curpos = nextChild.getEnd();
                        continue block2;
                    }
                    scopeStack.add(nextChild);
                    top = nextChild;
                    nextChild = ((ParsedNode)top.getNode()).findNodeAt(curpos + 1, top.getPosition());
                }
                int line = map.getElementIndex(curpos);
                MoeSyntaxDocument.Element lineEl = map.getElement(line);
                Segment segment = new Segment();
                doc.getText(lineEl.getStartOffset(), lineEl.getEndOffset() - lineEl.getStartOffset(), segment);
                int lineOffset = curpos - lineEl.getStartOffset();
                int nws = lineEl.getStartOffset() < nap.getPosition() && ((ParsedNode)nap.getNode()).isInner() ? this.findNonWhitespaceComment(nap, lineEl, segment, lineOffset) : this.findNonWhitespace(segment, lineOffset);
                if (nws == lineOffset) {
                    OptionalInt cboundsX = this.getLeftEdge(curpos);
                    if (cboundsX.isPresent()) {
                        indent = Math.min(indent, cboundsX.getAsInt());
                    }
                    curpos = lineEl.getEndOffset();
                    continue;
                }
                if (nws == -1) {
                    curpos = lineEl.getEndOffset();
                    continue;
                }
                curpos += nws - lineOffset;
            }
            return indent == Integer.MAX_VALUE ? -1 : indent;
        }
        catch (IndexOutOfBoundsException e) {
            return -1;
        }
    }

    private int[] reassessIndentsAdd(int dmgStart, int dmgEnd) {
        NodeTree.NodeAndPosition top;
        MoeSyntaxDocument doc = this.document;
        ParsedCUNode pcuNode = doc.getParsedNode();
        if (pcuNode == null) {
            return new int[]{dmgStart, dmgEnd};
        }
        MoeSyntaxDocument.Element map = doc.getDefaultRootElement();
        int ls = map.getElementIndex(dmgStart);
        int le = map.getElementIndex(dmgEnd);
        Segment segment = new Segment();
        int[] dmgRange = new int[]{dmgStart, dmgEnd};
        int i = ls;
        LinkedList<NodeTree.NodeAndPosition> scopeStack = new LinkedList<NodeTree.NodeAndPosition>();
        int lineEndPos = map.getElement(le).getEndOffset();
        MoeSyntaxDocument.Element lineEl = map.getElement(ls);
        for (top = pcuNode.findNodeAtOrAfter(lineEl.getStartOffset(), 0); top != null && top.getEnd() == lineEl.getStartOffset(); top = top.nextSibling()) {
        }
        if (top == null) {
            return dmgRange;
        }
        if (top.getPosition() >= lineEl.getEndOffset() && (i = map.getElementIndex(top.getPosition())) > le) {
            return dmgRange;
        }
        scopeStack.add(top);
        NodeTree.NodeAndPosition nap = ((ParsedNode)top.getNode()).findNodeAtOrAfter(lineEl.getStartOffset() + 1, top.getPosition());
        while (nap != null) {
            scopeStack.add(nap);
            nap = ((ParsedNode)nap.getNode()).findNodeAtOrAfter(lineEl.getStartOffset() + 1, nap.getPosition());
        }
        block2: while (true) {
            Integer oindent;
            doc.getText(lineEl.getStartOffset(), lineEl.getEndOffset() - lineEl.getStartOffset(), segment);
            int nws = this.findNonWhitespace(segment, 0);
            while (nws == -1) {
                if (++i > le) break block2;
                lineEl = map.getElement(i);
                doc.getText(lineEl.getStartOffset(), lineEl.getEndOffset() - lineEl.getStartOffset(), segment);
                nws = this.findNonWhitespace(segment, 0);
            }
            int curpos = lineEl.getStartOffset() + nws;
            ListIterator j = scopeStack.listIterator(scopeStack.size());
            NodeTree.NodeAndPosition topNap = null;
            while ((nap = (NodeTree.NodeAndPosition)j.previous()).getEnd() <= curpos) {
                topNap = nap;
                j.remove();
                if (j.hasPrevious()) continue;
            }
            if (topNap != null) {
                while ((topNap = topNap.nextSibling()) != null && topNap.getEnd() <= curpos) {
                }
                while (topNap != null && topNap.getPosition() < lineEndPos) {
                    scopeStack.add(topNap);
                    topNap = ((ParsedNode)topNap.getNode()).findNodeAtOrAfter(curpos + 1, topNap.getPosition());
                }
            }
            if (scopeStack.isEmpty()) break;
            OptionalInt cboundsX = this.getLeftEdge(lineEl.getStartOffset() + nws);
            int indent = cboundsX.orElse(0);
            j = scopeStack.listIterator(scopeStack.size());
            while (j.hasPrevious()) {
                NodeTree.NodeAndPosition next = (NodeTree.NodeAndPosition)j.previous();
                if (next.getPosition() <= curpos) {
                    this.updateNodeIndent((NodeTree.NodeAndPosition<ParsedNode>)next, indent, this.nodeIndents.get(next.getNode()), dmgRange);
                } else {
                    if (next.getPosition() >= lineEl.getEndOffset()) continue;
                    nws = this.findNonWhitespace(segment, next.getPosition() - lineEl.getStartOffset());
                    oindent = this.nodeIndents.get(next.getNode());
                    if (oindent != null && nws != -1) {
                        cboundsX = this.getLeftEdge(lineEl.getStartOffset() + nws);
                        indent = cboundsX.orElse(0);
                        this.updateNodeIndent((NodeTree.NodeAndPosition<ParsedNode>)next, indent, oindent, dmgRange);
                    }
                }
                if (!((ParsedNode)next.getNode()).isInner()) continue;
                break;
            }
            j = scopeStack.listIterator(scopeStack.size());
            while (j.hasPrevious() && (nap = (NodeTree.NodeAndPosition)j.previous()).getEnd() <= lineEl.getEndOffset()) {
                nap = nap.nextSibling();
                j.remove();
                if (nap == null) continue;
                do {
                    scopeStack.add(nap);
                    if (nap.getPosition() >= lineEl.getEndOffset()) continue;
                    int spos = nap.getPosition() - lineEl.getStartOffset();
                    nws = this.findNonWhitespace(segment, spos);
                    oindent = this.nodeIndents.get(nap.getNode());
                    if (oindent == null || nws == -1) continue;
                    cboundsX = this.getLeftEdge(lineEl.getStartOffset() + nws);
                    indent = cboundsX.orElse(0);
                    this.updateNodeIndent((NodeTree.NodeAndPosition<ParsedNode>)nap, indent, oindent, dmgRange);
                } while ((nap = ((ParsedNode)nap.getNode()).findNodeAtOrAfter(nap.getPosition(), nap.getPosition())) != null);
                j = scopeStack.listIterator(scopeStack.size());
            }
            if (++i > le) break;
            lineEl = map.getElement(i);
        }
        return dmgRange;
    }

    private int[] reassessIndentsRemove(int dmgPoint, boolean multiLine) {
        NodeTree.NodeAndPosition top;
        MoeSyntaxDocument doc = this.document;
        ParsedCUNode pcuNode = doc.getParsedNode();
        int[] dmgRange = new int[]{dmgPoint, dmgPoint};
        if (pcuNode == null) {
            return dmgRange;
        }
        MoeSyntaxDocument.Element map = doc.getDefaultRootElement();
        int ls = map.getElementIndex(dmgPoint);
        MoeSyntaxDocument.Element lineEl = map.getElement(ls);
        for (top = pcuNode.findNodeAtOrAfter(lineEl.getStartOffset(), 0); top != null && top.getEnd() == lineEl.getStartOffset(); top = top.nextSibling()) {
        }
        if (top == null) {
            return dmgRange;
        }
        if (top.getPosition() >= lineEl.getEndOffset()) {
            return dmgRange;
        }
        Segment segment = new Segment();
        doc.getText(lineEl.getStartOffset(), lineEl.getEndOffset() - lineEl.getStartOffset(), segment);
        LinkedList<NodeTree.NodeAndPosition<ParsedNode>> rscopeStack = new LinkedList<NodeTree.NodeAndPosition<ParsedNode>>();
        this.getScopeStackAfter((ParsedNode)doc.getParsedNode(), 0, dmgPoint, rscopeStack);
        rscopeStack.remove(0);
        boolean doContinue = true;
        OptionalInt cboundsX = this.getLeftEdge(dmgPoint);
        int dpI = cboundsX.orElse(0);
        block1: while (doContinue && !rscopeStack.isEmpty()) {
            NodeTree.NodeAndPosition rtop = (NodeTree.NodeAndPosition)rscopeStack.remove(rscopeStack.size() - 1);
            while (rtop != null && rtop.getPosition() < lineEl.getEndOffset()) {
                Integer cachedIndent;
                if (rtop.getPosition() <= dmgPoint && rtop.getEnd() >= lineEl.getEndOffset()) {
                    doContinue &= !((ParsedNode)rtop.getNode()).isInner();
                }
                if ((cachedIndent = this.nodeIndents.get(rtop.getNode())) == null) {
                    rtop = rtop.nextSibling();
                    continue;
                }
                if (!multiLine && cachedIndent < dpI) {
                    rtop = rtop.nextSibling();
                    continue;
                }
                if (this.nodeSkipsStart((NodeTree.NodeAndPosition<ParsedNode>)rtop, lineEl, segment)) {
                    if (rtop.getPosition() > dmgPoint) continue block1;
                    this.nodeIndents.remove(rtop.getNode());
                    dmgRange[0] = Math.min(dmgRange[0], rtop.getPosition());
                    dmgRange[1] = Math.max(dmgRange[1], rtop.getEnd());
                    continue block1;
                }
                int nwsP = Math.max(lineEl.getStartOffset(), rtop.getPosition());
                int nws = this.findNonWhitespace(segment, nwsP - lineEl.getStartOffset());
                if (nws == -1 || nws + lineEl.getStartOffset() >= rtop.getEnd()) {
                    if (rtop.getPosition() <= dmgPoint) {
                        this.nodeIndents.remove(rtop.getNode());
                        dmgRange[0] = Math.min(dmgRange[0], rtop.getPosition());
                        dmgRange[1] = Math.max(dmgRange[1], rtop.getEnd());
                    }
                    rtop = rtop.nextSibling();
                    continue;
                }
                cboundsX = this.getLeftEdge(nws + lineEl.getStartOffset());
                int newIndent = cboundsX.orElse(0);
                if (newIndent < cachedIndent) {
                    this.nodeIndents.put((ParsedNode)rtop.getNode(), newIndent);
                    dmgRange[0] = Math.min(dmgRange[0], rtop.getPosition());
                    dmgRange[1] = Math.max(dmgRange[1], rtop.getEnd());
                } else if (newIndent > cachedIndent && rtop.getPosition() <= dmgPoint) {
                    this.nodeIndents.remove(rtop.getNode());
                    dmgRange[0] = Math.min(dmgRange[0], rtop.getPosition());
                    dmgRange[1] = Math.max(dmgRange[1], rtop.getEnd());
                }
                rtop = rtop.nextSibling();
            }
        }
        return dmgRange;
    }

    private void updateNodeIndent(NodeTree.NodeAndPosition<ParsedNode> nap, int indent, Integer oindent, int[] dmgRange) {
        int dmgStart = dmgRange[0];
        int dmgEnd = dmgRange[1];
        if (oindent != null) {
            int noindent = oindent;
            if (indent < noindent) {
                this.nodeIndents.put((ParsedNode)nap.getNode(), indent);
            } else if (indent != noindent) {
                this.nodeIndents.remove(nap.getNode());
            }
            if (indent != noindent) {
                dmgStart = Math.min(dmgStart, nap.getPosition());
                dmgEnd = Math.max(dmgEnd, nap.getEnd());
                dmgRange[0] = dmgStart;
                dmgRange[1] = dmgEnd;
            }
        }
    }

    private void getScopeStackAfter(ParsedNode root, int rootPos, int position, List<NodeTree.NodeAndPosition<ParsedNode>> list) {
        list.add((NodeTree.NodeAndPosition<ParsedNode>)new NodeTree.NodeAndPosition((RBTreeNode)root, 0, root.getSize()));
        int curpos = rootPos;
        NodeTree.NodeAndPosition nap = root.findNodeAtOrAfter(position + 1, curpos);
        while (nap != null) {
            list.add((NodeTree.NodeAndPosition<ParsedNode>)nap);
            curpos = nap.getPosition();
            nap = ((ParsedNode)nap.getNode()).findNodeAtOrAfter(position + 1, curpos);
        }
    }

    private int findNonWhitespace(Segment segment, int startPos) {
        int endpos = segment.offset + segment.count;
        for (int i = segment.offset + startPos; i < endpos; ++i) {
            char c = segment.array[i];
            if (c == ' ' || c == '\t' || c == '\n' || c == '\r') continue;
            return i - segment.offset;
        }
        return -1;
    }

    private int findNonWhitespaceComment(NodeTree.NodeAndPosition<ParsedNode> nap, MoeSyntaxDocument.Element lineEl, Segment segment, int startPos) {
        int nws = this.findNonWhitespace(segment, startPos);
        if (nws != -1) {
            NodeTree.NodeAndPosition nnap;
            NodeTree.NodeAndPosition inNap;
            int pos = nws + lineEl.getStartOffset();
            if (nap.getEnd() > pos ? (inNap = ((ParsedNode)nap.getNode()).findNodeAt(pos, nap.getPosition())) != null && ((ParsedNode)inNap.getNode()).getNodeType() == 7 && inNap.getPosition() == pos && inNap.getEnd() == lineEl.getEndOffset() - 1 : (nnap = nap.nextSibling()) != null && ((ParsedNode)nnap.getNode()).getNodeType() == 7 && nnap.getPosition() == pos && nnap.getEnd() == lineEl.getEndOffset() - 1) {
                return -1;
            }
        }
        return nws;
    }

    private int findNonWhitespaceBwards(Segment segment, int startPos, int endPos) {
        int lastP = segment.offset + endPos;
        for (int i = segment.offset + startPos; i > lastP; --i) {
            char c = segment.array[i];
            if (c == ' ' || c == '\t' || c == '\n' || c == '\r') continue;
            return i - segment.offset;
        }
        return endPos - 1;
    }

    protected void updateDamage(MoeSyntaxEvent changes) {
        int[] r;
        int[] r2;
        NodeTree.NodeAndPosition<ParsedNode> nap;
        if (changes == null) {
            this.nodeIndents.clear();
            this.imageCache.clear();
            this.document.recalculateAllScopes();
            return;
        }
        int damageStart = this.document.getLength();
        int damageEnd = 0;
        MoeSyntaxEvent mse = changes;
        for (NodeTree.NodeAndPosition<ParsedNode> node : mse.getRemovedNodes()) {
            this.nodeRemoved((ParsedNode)node.getNode());
            damageStart = Math.min(damageStart, node.getPosition());
            damageEnd = Math.max(damageEnd, node.getEnd());
            nap = node;
            r2 = this.clearNap(nap, this.document, damageStart, damageEnd);
            damageStart = r2[0];
            damageEnd = r2[1];
        }
        for (MoeSyntaxEvent.NodeChangeRecord record : mse.getChangedNodes()) {
            nap = record.nap;
            this.nodeIndents.remove(nap.getNode());
            damageStart = Math.min(damageStart, nap.getPosition());
            damageStart = Math.min(damageStart, record.originalPos);
            damageEnd = Math.max(damageEnd, nap.getEnd());
            damageEnd = Math.max(damageEnd, record.originalPos + record.originalSize);
            r2 = this.clearNap(nap, this.document, damageStart, damageEnd);
            damageStart = r2[0];
            damageEnd = r2[1];
        }
        MoeSyntaxDocument.Element map = this.document.getDefaultRootElement();
        if (changes.isInsert()) {
            damageStart = Math.min(damageStart, changes.getOffset());
            damageEnd = Math.max(damageEnd, changes.getOffset() + changes.getLength());
            r = this.reassessIndentsAdd(damageStart, damageEnd);
            damageStart = r[0];
            damageEnd = r[1];
        } else if (changes.isRemove()) {
            damageStart = Math.min(damageStart, changes.getOffset());
            r = this.reassessIndentsRemove(damageStart, true);
            damageStart = r[0];
            damageEnd = r[1];
        }
        if (damageStart < damageEnd) {
            int line = map.getElementIndex(damageStart);
            int lastline = map.getElementIndex(damageEnd - 1);
            this.document.recalculateScopesForLinesInRange(line, lastline);
        }
    }

    private int[] clearNap(NodeTree.NodeAndPosition<ParsedNode> nap, MoeSyntaxDocument document, int damageStart, int damageEnd) {
        if (((ParsedNode)nap.getNode()).isInner()) {
            LinkedList<NodeTree.NodeAndPosition> list = new LinkedList<NodeTree.NodeAndPosition>();
            NodeTree.NodeAndPosition top = new NodeTree.NodeAndPosition((RBTreeNode)document.getParsedNode(), 0, document.getLength());
            while (top != null && top.getNode() != nap.getNode()) {
                if (((ParsedNode)top.getNode()).isInner()) {
                    list.clear();
                }
                list.add(top);
                top = ((ParsedNode)top.getNode()).findNodeAt(nap.getEnd(), top.getPosition());
            }
            for (NodeTree.NodeAndPosition cnap : list) {
                damageStart = Math.min(damageStart, cnap.getPosition());
                damageEnd = Math.max(damageEnd, cnap.getEnd());
                this.nodeIndents.remove(cnap.getNode());
            }
        }
        return new int[]{damageStart, damageEnd};
    }

    private void nodeRemoved(ParsedNode node) {
        this.nodeIndents.remove(node);
    }

    @OnThread(value=Tag.FXPlatform)
    public Node getParagraphicGraphic(int lineNumber) {
        Label label = new Label("" + ++lineNumber);
        label.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        label.setEllipsisString("\u2026");
        label.setTextOverrun(OverrunStyle.LEADING_ELLIPSIS);
        JavaFXUtil.setPseudoclass((String)"bj-odd", ((lineNumber & 1) == 1 ? 1 : 0) != 0, (Node[])new Node[]{label});
        JavaFXUtil.addStyleClass((Styleable)label, (String[])new String[]{"moe-line-label"});
        Node stepMarkIcon = this.makeStepMarkIcon();
        Node breakpointIcon = BlueJSyntaxView.makeBreakpointIcon();
        label.setGraphic((Node)new StackPane(new Node[]{breakpointIcon, stepMarkIcon}));
        label.setOnContextMenuRequested(e -> {
            CheckMenuItem checkMenuItem = new CheckMenuItem(Config.getString((String)"prefmgr.edit.displaylinenumbers"));
            checkMenuItem.setSelected(PrefMgr.getFlag((String)"bluej.editor.displayLineNumbers"));
            checkMenuItem.setOnAction(ev -> PrefMgr.setFlag((String)"bluej.editor.displayLineNumbers", (boolean)checkMenuItem.isSelected()));
            ContextMenu menu = new ContextMenu(new MenuItem[]{checkMenuItem});
            menu.show((Node)label, e.getScreenX(), e.getScreenY());
        });
        int lineNumberFinal = lineNumber;
        label.setOnMouseClicked(e -> {
            MoeEditor editor;
            if (e.getClickCount() == 1 && e.getButton() == MouseButton.PRIMARY && (editor = this.editorPane.getEditor()) != null) {
                editor.toggleBreakpoint(this.editorPane.getDocument().getAbsolutePosition(lineNumberFinal - 1, 0));
            }
            e.consume();
        });
        WeakReference<Label> weakLabel = new WeakReference<Label>(label);
        FXPlatformConsumer listener = attr -> {
            Label l = (Label)weakLabel.get();
            if (l != null) {
                for (ParagraphAttribute possibleAttribute : ParagraphAttribute.values()) {
                    JavaFXUtil.setPseudoclass((String)possibleAttribute.getPseudoclass(), (boolean)attr.contains((Object)possibleAttribute), (Node[])new Node[]{l});
                }
                stepMarkIcon.setVisible(attr.contains((Object)ParagraphAttribute.STEP_MARK));
                breakpointIcon.setVisible(attr.contains((Object)ParagraphAttribute.BREAKPOINT));
                if (stepMarkIcon.isVisible() || breakpointIcon.isVisible() || !this.editorPane.isShowLineNumbers()) {
                    l.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
                } else {
                    l.setContentDisplay(ContentDisplay.TEXT_ONLY);
                }
            } else {
                this.paragraphAttributeListeners.remove(lineNumberFinal);
            }
        };
        this.lineLabels.removeIf(w -> w.get() == null);
        this.lineLabels.add(weakLabel);
        listener.accept(this.paragraphAttributes.getOrDefault(lineNumber, EnumSet.noneOf(ParagraphAttribute.class)));
        this.paragraphAttributeListeners.put(lineNumber, (FXPlatformConsumer<EnumSet<ParagraphAttribute>>)listener);
        AnchorPane.setLeftAnchor((Node)label, (Double)0.0);
        AnchorPane.setRightAnchor((Node)label, (Double)3.0);
        AnchorPane.setTopAnchor((Node)label, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)label, (Double)0.0);
        return new AnchorPane(new Node[]{label});
    }

    private static Node makeBreakpointIcon() {
        Node icon = Config.makeStopIcon((boolean)false);
        JavaFXUtil.addStyleClass((Styleable)icon, (String[])new String[]{"moe-breakpoint-icon"});
        return icon;
    }

    private Node makeStepMarkIcon() {
        Polygon arrow = Config.makeArrowShape((boolean)false);
        JavaFXUtil.addStyleClass((Styleable)arrow, (String[])new String[]{"moe-step-mark-icon"});
        return arrow;
    }

    public Map<Integer, EnumSet<ParagraphAttribute>> setParagraphAttributes(Map<ParagraphAttribute, Boolean> alterAttr) {
        HashMap<Integer, EnumSet<ParagraphAttribute>> changed = new HashMap<Integer, EnumSet<ParagraphAttribute>>();
        for (int line = 1; line <= this.document.getDocument().getParagraphs().size(); ++line) {
            changed.putAll(this.setParagraphAttributes(line, alterAttr));
        }
        return changed;
    }

    public Map<Integer, EnumSet<ParagraphAttribute>> setParagraphAttributes(int lineNumber, Map<ParagraphAttribute, Boolean> alterAttr) {
        EnumSet<ParagraphAttribute> attr = this.getParagraphAttributes(lineNumber);
        boolean changed = false;
        for (Map.Entry<ParagraphAttribute, Boolean> alter : alterAttr.entrySet()) {
            if (alter.getValue().booleanValue()) {
                changed = attr.add(alter.getKey()) || changed;
                continue;
            }
            changed = attr.remove((Object)alter.getKey()) || changed;
        }
        FXPlatformConsumer<EnumSet<ParagraphAttribute>> listener = this.paragraphAttributeListeners.get(lineNumber);
        if (listener != null) {
            listener.accept(attr);
        }
        if (changed) {
            return Collections.singletonMap(lineNumber, EnumSet.copyOf(attr.clone()));
        }
        return Collections.emptyMap();
    }

    EnumSet<ParagraphAttribute> getParagraphAttributes(int lineNumber) {
        return this.paragraphAttributes.computeIfAbsent(lineNumber, k -> EnumSet.noneOf(ParagraphAttribute.class));
    }

    private void resetColors() {
        this.BK = (Color)this.scopeColors.scopeBackgroundColorProperty().get();
        this.C1 = this.getReducedColor(this.scopeColors.scopeClassOuterColorProperty());
        this.C2 = this.getReducedColor(this.scopeColors.scopeClassColorProperty());
        this.C3 = this.getReducedColor(this.scopeColors.scopeClassInnerColorProperty());
        this.M1 = this.getReducedColor(this.scopeColors.scopeMethodOuterColorProperty());
        this.M2 = this.getReducedColor(this.scopeColors.scopeMethodColorProperty());
        this.S1 = this.getReducedColor(this.scopeColors.scopeSelectionOuterColorProperty());
        this.S2 = this.getReducedColor(this.scopeColors.scopeSelectionColorProperty());
        this.I1 = this.getReducedColor(this.scopeColors.scopeIterationOuterColorProperty());
        this.I2 = this.getReducedColor(this.scopeColors.scopeIterationColorProperty());
    }

    private Color getReducedColor(ObjectExpression<Color> c) {
        return (Color)this.scopeColors.getReducedColor(c, PrefMgr.getScopeHighlightStrength()).getValue();
    }

    private class LeftRight {
        private final int lhs;
        private final int rhs;
        private final int padding;
        private final boolean starts;
        private final boolean ends;
        private final Color fillColor;
        private final Color edgeColor;

        public LeftRight(int lhs, int rhs, int padding, boolean starts, boolean ends, Color fillColor, Color edgeColor) {
            this.lhs = Math.max(0, lhs);
            this.rhs = rhs;
            this.padding = padding;
            this.starts = starts;
            this.ends = ends;
            this.fillColor = fillColor;
            this.edgeColor = edgeColor;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LeftRight leftRight = (LeftRight)o;
            if (this.lhs != leftRight.lhs) {
                return false;
            }
            if (this.rhs != leftRight.rhs) {
                return false;
            }
            if (this.padding != leftRight.padding) {
                return false;
            }
            if (this.starts != leftRight.starts) {
                return false;
            }
            if (this.ends != leftRight.ends) {
                return false;
            }
            if (!this.fillColor.equals((Object)leftRight.fillColor)) {
                return false;
            }
            return this.edgeColor.equals((Object)leftRight.edgeColor);
        }

        public int hashCode() {
            int result = this.lhs;
            result = 31 * result + this.rhs;
            result = 31 * result + this.padding;
            result = 31 * result + (this.starts ? 1 : 0);
            result = 31 * result + (this.ends ? 1 : 0);
            result = 31 * result + this.fillColor.hashCode();
            result = 31 * result + this.edgeColor.hashCode();
            return result;
        }
    }

    @OnThread(value=Tag.FX)
    public static class ScopeInfo {
        private final List<SingleNestedScope> nestedScopes = new ArrayList<SingleNestedScope>();
        private final EnumSet<ParagraphAttribute> attributes;
        private boolean incomplete = false;

        public ScopeInfo(EnumSet<ParagraphAttribute> attributes) {
            this.attributes = EnumSet.copyOf(attributes);
        }

        public EnumSet<ParagraphAttribute> getAttributes() {
            return this.attributes;
        }

        public ScopeInfo withAttributes(EnumSet<ParagraphAttribute> attributes) {
            ScopeInfo scopeInfo = new ScopeInfo(attributes);
            scopeInfo.nestedScopes.addAll(this.nestedScopes);
            return scopeInfo;
        }

        public boolean isIncomplete() {
            return this.incomplete;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ScopeInfo scopeInfo = (ScopeInfo)o;
            if (this.incomplete != scopeInfo.incomplete) {
                return false;
            }
            if (!this.attributes.equals(scopeInfo.attributes)) {
                return false;
            }
            return this.nestedScopes.equals(scopeInfo.nestedScopes);
        }

        public int hashCode() {
            int result = this.nestedScopes.hashCode();
            result = 31 * result + this.attributes.hashCode();
            return result += this.isIncomplete() ? 1 : 0;
        }

        public String toString() {
            return "ScopeInfo{nestedScopes=" + this.nestedScopes + ", attributes=" + this.attributes + ", incomplete=" + this.incomplete + '}';
        }

        private static class SingleNestedScope {
            private final LeftRight leftRight;
            private final Middle middle;
            private final int hashCode;

            public SingleNestedScope(LeftRight leftRight, Middle middle) {
                this.leftRight = leftRight;
                this.middle = middle;
                this.hashCode = leftRight.hashCode() * 31 + middle.hashCode();
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                SingleNestedScope that = (SingleNestedScope)o;
                if (this.hashCode != that.hashCode) {
                    return false;
                }
                if (!this.leftRight.equals(that.leftRight)) {
                    return false;
                }
                return this.middle.equals(that.middle);
            }

            public int hashCode() {
                return this.hashCode;
            }
        }

        public static enum Special {
            NONE,
            BREAKPOINT,
            STEP;

        }
    }

    private static class Middle {
        private final Color bodyColor;
        private final int lhs;
        private final int rhs;
        private Color topColor;
        private Color bottomColor;

        public Middle(Color bodyColor, int lhs, int rhs) {
            this.bodyColor = bodyColor;
            this.lhs = Math.max(0, lhs);
            this.rhs = rhs;
        }

        public void drawTop(Color topColor) {
            this.topColor = topColor;
        }

        public void drawBottom(Color bottomColor) {
            this.bottomColor = bottomColor;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Middle middle = (Middle)o;
            if (this.lhs != middle.lhs) {
                return false;
            }
            if (this.rhs != middle.rhs) {
                return false;
            }
            if (!this.bodyColor.equals((Object)middle.bodyColor)) {
                return false;
            }
            if (this.topColor != null ? !this.topColor.equals((Object)middle.topColor) : middle.topColor != null) {
                return false;
            }
            return this.bottomColor != null ? this.bottomColor.equals((Object)middle.bottomColor) : middle.bottomColor == null;
        }

        public int hashCode() {
            int result = this.bodyColor.hashCode();
            result = 31 * result + this.lhs;
            result = 31 * result + this.rhs;
            result = 31 * result + (this.topColor != null ? this.topColor.hashCode() : 0);
            result = 31 * result + (this.bottomColor != null ? this.bottomColor.hashCode() : 0);
            return result;
        }
    }

    private class DrawInfo {
        final ScopeInfo scopes;
        ThreeLines lines;
        boolean small;
        ParsedNode node;
        boolean starts;
        boolean ends;
        Color color1;
        Color color2;

        private DrawInfo(ScopeInfo scopes) {
            this.scopes = scopes;
        }
    }

    private class ThreeLines {
        Segment aboveLineSeg;
        Segment thisLineSeg;
        Segment belowLineSeg;
        MoeSyntaxDocument.Element aboveLineEl;
        MoeSyntaxDocument.Element thisLineEl;
        MoeSyntaxDocument.Element belowLineEl;

        private ThreeLines() {
        }
    }

    public static enum ParagraphAttribute {
        STEP_MARK("bj-step-mark"),
        BREAKPOINT("bj-breakpoint"),
        ERROR("bj-error");

        private final String pseudoClass;

        private ParagraphAttribute(String pseudoClass) {
            this.pseudoClass = pseudoClass;
        }

        public String getPseudoclass() {
            return this.pseudoClass;
        }
    }
}

