/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor;

import bluej.compiler.CompileType;
import bluej.compiler.Diagnostic;
import bluej.debugger.DebuggerThread;
import bluej.editor.TextEditor;
import bluej.editor.stride.FrameEditor;
import bluej.parser.symtab.ClassInfo;
import bluej.stride.framedjava.elements.CallElement;
import bluej.stride.framedjava.elements.NormalMethodElement;
import bluej.utility.javafx.FXRunnable;
import java.io.IOException;
import java.util.List;
import java.util.function.Consumer;
import javafx.print.PrinterJob;
import threadchecker.OnThread;
import threadchecker.Tag;

public interface Editor {
    public void reloadFile();

    @OnThread(value=Tag.FXPlatform)
    public void setEditorVisible(boolean var1);

    public boolean isOpen();

    public void save() throws IOException;

    default public void saveJavaWithoutWarning() throws IOException {
        this.save();
    }

    @OnThread(value=Tag.FXPlatform)
    public void close();

    public void refresh();

    public void displayMessage(String var1, int var2, int var3);

    public boolean displayDiagnostic(Diagnostic var1, int var2, CompileType var3);

    public void setStepMark(int var1, String var2, boolean var3, DebuggerThread var4);

    @OnThread(value=Tag.FXPlatform)
    public void writeMessage(String var1);

    public void removeStepMark();

    public void changeName(String var1, String var2, String var3, String var4);

    public void setCompiled(boolean var1);

    public boolean compileStarted(int var1);

    public void compileFinished(boolean var1, boolean var2);

    public void removeBreakpoints();

    public void reInitBreakpoints();

    public boolean isModified();

    @OnThread(value=Tag.FXPlatform)
    public FXRunnable printTo(PrinterJob var1, boolean var2, boolean var3);

    public void setReadOnly(boolean var1);

    public boolean isReadOnly();

    public void showInterface(boolean var1);

    public Object getProperty(String var1);

    public void setProperty(String var1, Object var2);

    public TextEditor assumeText();

    public FrameEditor assumeFrame();

    public void insertAppendMethod(bluej.extensions.editor.Editor var1, NormalMethodElement var2, Consumer<Boolean> var3);

    public void insertMethodCallInConstructor(bluej.extensions.editor.Editor var1, String var2, CallElement var3, Consumer<Boolean> var4);

    public void cancelFreshState();

    public void focusMethod(String var1, List<String> var2);

    public void setExtendsClass(String var1, ClassInfo var2);

    public void removeExtendsClass(ClassInfo var1);

    public void addImplements(String var1, ClassInfo var2);

    public void addExtendsInterface(String var1, ClassInfo var2);

    public void removeExtendsOrImplementsInterface(String var1, ClassInfo var2);

    public void removeImports(List<String> var1);
}

