/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.i2c;

import com.pi4j.io.i2c.I2CBus;
import com.pi4j.io.i2c.I2CFactoryProvider;
import com.pi4j.io.i2c.impl.I2CFactoryProviderRaspberryPi;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class I2CFactory {
    public static final long DEFAULT_LOCKAQUIRE_TIMEOUT = 1000L;
    public static final TimeUnit DEFAULT_LOCKAQUIRE_TIMEOUT_UNITS = TimeUnit.MILLISECONDS;
    static volatile I2CFactoryProvider provider = new I2CFactoryProviderRaspberryPi();

    private I2CFactory() {
    }

    public static I2CBus getInstance(int busNumber) throws UnsupportedBusNumberException, IOException {
        return provider.getBus(busNumber, 1000L, DEFAULT_LOCKAQUIRE_TIMEOUT_UNITS);
    }

    public static I2CBus getInstance(int busNumber, long lockAquireTimeout, TimeUnit lockAquireTimeoutUnit) throws UnsupportedBusNumberException, IOException {
        return provider.getBus(busNumber, lockAquireTimeout, lockAquireTimeoutUnit);
    }

    public static void setFactory(I2CFactoryProvider factoryProvider) {
        provider = factoryProvider;
    }

    public static class UnsupportedBusNumberException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }
}

