/*
 * Decompiled with CFR 0.152.
 */
package org.bluej.extensions.exporter.steps;

import bluej.extensions.BClass;
import bluej.extensions.BPackage;
import bluej.extensions.PackageNotFoundException;
import bluej.extensions.ProjectNotOpenException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.io.File;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.bluej.extensions.exporter.Stat;
import org.bluej.extensions.exporter.steps.UserLibInfo;

public class SummaryStep
extends JPanel {
    private static final String classname = "SummaryStep.";
    private final Stat stat;
    private final Vector fileList = new Vector();
    private final Vector libraryList = new Vector();
    private final JTextArea summaryArea;

    public SummaryStep(Stat stat) {
        this.stat = stat;
        this.setLayout(new BorderLayout());
        this.add((Component)new JLabel(" Files that will be exported "), "North");
        this.summaryArea = new JTextArea("", 6, 40);
        Font font = this.summaryArea.getFont();
        float f = font.getSize();
        this.summaryArea.setFont(font.deriveFont(f - 2.0f));
        this.add((Component)new JScrollPane(this.summaryArea), "Center");
    }

    public Vector getFileList() {
        return this.fileList;
    }

    public Vector getLibraryList() {
        return this.libraryList;
    }

    void fillSummary() {
        this.fillFileList();
        this.fillLibraryList();
        try {
            int n;
            File file = this.stat.bluej.getCurrentPackage().getProject().getDir();
            this.summaryArea.append(new File(file, "build.xml").toString() + "\n");
            int n2 = this.fileList.size();
            for (n = 0; n < n2; ++n) {
                this.summaryArea.append(this.fileList.get(n) + "\n");
            }
            n2 = this.libraryList.size();
            for (n = 0; n < n2; ++n) {
                this.summaryArea.append(this.libraryList.get(n) + "\n");
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "SummaryStep.fillSummary() Exception=" + exception);
            exception.printStackTrace();
        }
    }

    private void fillFileList() {
        this.fileList.clear();
        try {
            BPackage[] bPackageArray = this.stat.curProject.getPackages();
            for (int i = 0; i < bPackageArray.length; ++i) {
                this.addPackageFiles(this.fileList, bPackageArray[i]);
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "SummaryStep.taskEnter() Exception=" + exception);
        }
    }

    private void addPackageFiles(Vector vector, BPackage bPackage) throws ProjectNotOpenException, PackageNotFoundException {
        BClass[] bClassArray = bPackage.getClasses();
        for (int i = 0; i < bClassArray.length; ++i) {
            vector.add(bClassArray[i].getJavaFile());
        }
    }

    private void fillLibraryList() {
        this.libraryList.clear();
        try {
            File file = this.stat.bluej.getCurrentPackage().getProject().getDir();
            this.addProjectLibrary(this.libraryList, new File(file, "+libs"));
            UserLibInfo[] userLibInfoArray = this.stat.antStep.getUserLibInfo();
            for (int i = 0; i < userLibInfoArray.length; ++i) {
                UserLibInfo userLibInfo = userLibInfoArray[i];
                if (!userLibInfo.isSelected()) continue;
                this.libraryList.add(userLibInfo.getFile());
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "SummaryStep.taskEnter() Exception=" + exception);
        }
    }

    private void addProjectLibrary(Vector vector, File file) {
        if (!file.canRead()) {
            return;
        }
        if (!file.isDirectory()) {
            return;
        }
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (!file2.canRead() || !file2.isFile() || !file2.getName().endsWith(".jar")) continue;
            vector.add(file2);
        }
    }
}

