/*
 * Decompiled with CFR 0.152.
 */
package org.bluej.extensions.exporter.steps;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.bluej.extensions.exporter.Stat;

public class DirectoryStep
extends JPanel {
    private final Stat stat;
    private ActionListener acceptListener;
    private File selectedDir;
    private JTextField selectedField;
    private JButton openDirectoryBrowser;
    private JFileChooser directoryChooser;

    public DirectoryStep(Stat stat) {
        this.stat = stat;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 10;
        JLabel jLabel = new JLabel("Select a folder to extract files to:");
        this.add((Component)jLabel, gridBagConstraints);
        this.directoryChooser = new JFileChooser();
        this.directoryChooser.setFileSelectionMode(1);
        this.selectedField = new JTextField(20);
        Document document = this.selectedField.getDocument();
        document.addDocumentListener(new ChangeListener());
        this.openDirectoryBrowser = new JButton("Browse ...");
        this.openDirectoryBrowser.addActionListener(new ButtonHandler());
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 12;
        this.add((Component)this.selectedField, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.add((Component)this.openDirectoryBrowser, gridBagConstraints);
    }

    public File getSelectedFile() {
        return this.selectedDir;
    }

    void setFilterAcceptListener(ActionListener actionListener) {
        this.acceptListener = actionListener;
    }

    private void parseInputField() {
        try {
            this.selectedDir = new File(this.selectedField.getText());
            if (!this.selectedDir.exists()) {
                this.selectedDir = null;
            }
            if (!this.selectedDir.isDirectory()) {
                this.selectedDir = null;
            }
            if (!this.selectedDir.canWrite()) {
                this.selectedDir = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.acceptListener != null) {
            this.acceptListener.actionPerformed(new ActionEvent(this, 1, "update"));
        }
    }

    private final class ChangeListener
    implements DocumentListener {
        private ChangeListener() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            DirectoryStep.this.parseInputField();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            DirectoryStep.this.parseInputField();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            DirectoryStep.this.parseInputField();
        }
    }

    private final class ButtonHandler
    implements ActionListener {
        private ButtonHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = DirectoryStep.this.directoryChooser.showOpenDialog(((DirectoryStep)DirectoryStep.this).stat.bluej.getCurrentFrame());
            if (n == 0) {
                DirectoryStep.this.selectedField.setText(DirectoryStep.this.directoryChooser.getSelectedFile().toString());
            }
        }
    }
}

