/*
 * Decompiled with CFR 0.152.
 */
package org.bluej.extensions.exporter.steps;

import bluej.extensions.BClass;
import bluej.extensions.BMethod;
import bluej.extensions.BPackage;
import bluej.extensions.BProject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.io.File;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.bluej.extensions.exporter.Stat;
import org.bluej.extensions.exporter.steps.UserLibInfo;

public class AntStep
extends JPanel {
    private static final String userlibPrefix = "bluej.userlibrary";
    private final Stat stat;
    private final JComboBox runCombo;
    private UserLibInfo[] userLibs;

    public AntStep(Stat stat) {
        this.stat = stat;
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.runCombo = new JComboBox();
        this.runCombo.setEditable(true);
        this.addAlignedLeftComponent(jPanel, new JLabel("Main Class: "), this.runCombo);
        this.addAlignedLeftComponent(jPanel, this.createUserLibPanel());
        this.add((Component)jPanel, "North");
    }

    private void addAlignedLeftComponent(JPanel jPanel, JComponent jComponent, JComponent jComponent2) {
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(jComponent);
        jPanel2.add(jComponent2);
        jPanel.add(jPanel2);
    }

    private void addAlignedLeftComponent(JPanel jPanel, JComponent jComponent) {
        if (jComponent == null) {
            return;
        }
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(jComponent);
        jPanel.add(jPanel2);
    }

    public String getRunTarget() {
        return (String)this.runCombo.getSelectedItem();
    }

    public UserLibInfo[] getUserLibInfo() {
        return this.userLibs;
    }

    void findMainClass() {
        Vector vector = new Vector();
        try {
            BProject bProject = this.stat.bluej.getCurrentPackage().getProject();
            BPackage[] bPackageArray = bProject.getPackages();
            for (int i = 0; i < bPackageArray.length; ++i) {
                this.scanPackage(vector, bPackageArray[i]);
            }
        }
        catch (Exception exception) {
            System.err.println("findMainClass() Exception=" + exception);
        }
        this.runCombo.setModel(new DefaultComboBoxModel(vector));
    }

    private void scanPackage(Vector vector, BPackage bPackage) {
        String[] stringArray = new String[]{};
        Class[] classArray = new Class[]{stringArray.getClass()};
        try {
            BClass[] bClassArray = bPackage.getClasses();
            for (int i = 0; i < bClassArray.length; ++i) {
                BClass bClass = bClassArray[i];
                BMethod bMethod = bClass.getDeclaredMethod("main", classArray);
                if (bMethod == null) continue;
                vector.add(bClass.getJavaClass().getName());
            }
        }
        catch (Exception exception) {
            System.err.println("scanPackage() Exception=" + exception);
        }
    }

    private ArrayList getUserLibrary() {
        String string;
        ArrayList<File> arrayList = new ArrayList<File>();
        int n = 1;
        while ((string = this.stat.bluej.getBlueJPropertyString(userlibPrefix + n + ".location", null)) != null) {
            ++n;
            arrayList.add(new File(string));
        }
        return arrayList;
    }

    private ArrayList getUseribLibrary() {
        ArrayList<File> arrayList = new ArrayList<File>();
        File file = this.stat.bluej.getSystemLibDir();
        File file2 = new File(file, "userlib");
        if (!file2.isDirectory() || !file2.canRead()) {
            return arrayList;
        }
        File[] fileArray = file2.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file3 = fileArray[i];
            if (!file3.isFile() || !file3.canRead() || !file3.getName().endsWith(".jar")) continue;
            arrayList.add(file3);
        }
        return arrayList;
    }

    private JPanel createUserLibPanel() {
        ArrayList arrayList = this.getUserLibrary();
        arrayList.addAll(this.getUseribLibrary());
        this.userLibs = new UserLibInfo[arrayList.size()];
        if (arrayList.size() == 0) {
            return null;
        }
        boolean bl = false;
        for (int i = 0; i < arrayList.size(); ++i) {
            File file = (File)arrayList.get(i);
            this.userLibs[i] = new UserLibInfo(file);
        }
        JPanel jPanel = new JPanel(new GridLayout(0, 2));
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Include user libraries"), BorderFactory.createEmptyBorder(5, 10, 5, 10)));
        for (int i = 0; i < this.userLibs.length; ++i) {
            jPanel.add(this.userLibs[i].getCheckBox());
        }
        return jPanel;
    }
}

