/*
 * Decompiled with CFR 0.152.
 */
package org.bluej.extensions.exporter;

import bluej.extensions.BProject;
import bluej.extensions.ProjectNotOpenException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.bluej.extensions.exporter.DeployException;
import org.bluej.extensions.exporter.Stat;
import org.bluej.extensions.exporter.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlServices {
    private static final String classname = "XmlServices.";
    public static final String ANT_BUILD_FILENAME = "build.xml";
    private final Stat stat;
    private DocumentBuilderFactory factory;
    private TransformerFactory tFactory;
    private Document document;
    private File destinationDir;
    private File sourceDir;
    private String srcSubdir;
    private String classesSubdir;
    private String docSubdir;
    private String libSubdir;

    public XmlServices(Stat stat) {
        this.stat = stat;
        try {
            this.factory = DocumentBuilderFactory.newInstance();
            this.tFactory = TransformerFactory.newInstance();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "XmlServices.ERROR: Cannot create a DocumentBuilderFactory");
        }
    }

    public void deployProject(BProject bProject) {
        try {
            this.sourceDir = bProject.getDir();
            this.destinationDir = this.stat.directoryStep.getSelectedFile();
            if (this.sourceDir.equals(this.destinationDir)) {
                this.deployBuildOnly(bProject);
            } else {
                this.deployEntireProject(bProject);
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "Deploy build only: Exception " + exception);
            exception.printStackTrace();
        }
    }

    private void deployBuildOnly(BProject bProject) throws Exception {
        this.srcSubdir = ".";
        this.classesSubdir = ".";
        this.docSubdir = "doc";
        this.libSubdir = "+libs";
        DocumentBuilder documentBuilder = this.factory.newDocumentBuilder();
        this.document = documentBuilder.newDocument();
        Element element = this.addProject(bProject, this.stat.summaryStep.getFileList());
        this.addClasspathId(element);
        this.stat.finishStep.setProgressValue(10);
        this.addPrepareTarget(element);
        this.addCleanTarget(element);
        this.addCompileTarget(element);
        String string = this.stat.antStep.getRunTarget();
        if (string != null && string.length() > 1) {
            this.addRunTarget(element, string);
        }
        this.stat.finishStep.setProgressValue(70);
        this.saveAntBuild();
        Thread.currentThread();
        Thread.sleep(300L);
        this.stat.finishStep.setProgressValue(100);
    }

    private void deployEntireProject(BProject bProject) throws Exception {
        this.srcSubdir = "src";
        this.classesSubdir = "classes";
        this.docSubdir = "doc";
        this.libSubdir = "libs";
        DocumentBuilder documentBuilder = this.factory.newDocumentBuilder();
        this.document = documentBuilder.newDocument();
        Element element = this.addProject(bProject, this.stat.summaryStep.getFileList());
        this.addClasspathId(element);
        this.stat.finishStep.setProgressValue(10);
        this.addPrepareTarget(element);
        this.addCleanTarget(element);
        Thread.currentThread();
        Thread.sleep(300L);
        this.stat.finishStep.setProgressValue(20);
        this.addCompileTarget(element);
        Thread.currentThread();
        Thread.sleep(300L);
        String string = this.stat.antStep.getRunTarget();
        if (string != null && string.length() > 1) {
            this.addRunTarget(element, string);
        }
        this.stat.finishStep.setProgressValue(50);
        this.copyFileList();
        this.copyLibraryList();
        Thread.currentThread();
        Thread.sleep(300L);
        this.stat.finishStep.setProgressValue(70);
        this.saveAntBuild();
        Thread.currentThread();
        Thread.sleep(300L);
        this.stat.finishStep.setProgressValue(100);
    }

    private void copyFileList() {
        File file = this.stat.directoryStep.getSelectedFile();
        Iterator iterator = this.stat.summaryStep.getFileList().iterator();
        while (iterator.hasNext()) {
            File file2 = (File)iterator.next();
            File file3 = new File(file, this.srcSubdir);
            file3 = new File(file3, this.getLastPart(this.sourceDir, file2));
            Utils.copyFile(file3, file2);
        }
    }

    private void copyLibraryList() {
        File file = this.stat.directoryStep.getSelectedFile();
        file = new File(file, this.libSubdir);
        Iterator iterator = this.stat.summaryStep.getLibraryList().iterator();
        while (iterator.hasNext()) {
            File file2 = (File)iterator.next();
            File file3 = new File(file, file2.getName());
            Utils.copyFile(file3, file2);
        }
    }

    private Element addProject(BProject bProject, Vector vector) throws DeployException, ProjectNotOpenException {
        Element element = this.document.createElement("project");
        this.document.appendChild(element);
        element.setAttribute("name", bProject.getName());
        element.setAttribute("basedir", ".");
        element.setAttribute("default", "compile");
        this.addProperty(element, "src.dir", this.srcSubdir);
        this.addProperty(element, "compile.outdir", this.classesSubdir);
        this.addProperty(element, "javadoc.outdir", this.docSubdir);
        return element;
    }

    private Element addTarget(Element element, String string) {
        Element element2 = this.document.createElement("target");
        element2.setAttribute("name", string);
        element.appendChild(element2);
        return element2;
    }

    private Element addPrepareTarget(Element element) {
        Element element2 = this.document.createElement("target");
        element.appendChild(element2);
        element2.setAttribute("name", "prepare");
        Element element3 = this.document.createElement("tstamp");
        element2.appendChild(element3);
        element3 = this.document.createElement("mkdir");
        element3.setAttribute("dir", "${compile.outdir}");
        element2.appendChild(element3);
        element3 = this.document.createElement("mkdir");
        element3.setAttribute("dir", "${javadoc.outdir}");
        element2.appendChild(element3);
        return element2;
    }

    private void addCompileTarget(Element element) {
        Element element2 = this.addTarget(element, "compile");
        element.appendChild(element2);
        element2.setAttribute("depends", "prepare");
        Element element3 = this.document.createElement("javac");
        element2.appendChild(element3);
        element3.setAttribute("destdir", "${compile.outdir}");
        element3.setAttribute("srcdir", "${src.dir}");
        element3.setAttribute("debug", "on");
        element3.setAttribute("encoding", "Cp1252");
        this.addClasspathRefid(element3);
    }

    private void addCleanTarget(Element element) {
        Element element2 = this.addTarget(element, "clean");
        element2.appendChild(this.document.createComment("Delete ouput directories"));
        Element element3 = this.document.createElement("delete");
        Element element4 = this.document.createElement("fileset");
        element4.setAttribute("dir", "${compile.outdir}");
        element4.setAttribute("casesensitive", "yes");
        Element element5 = this.document.createElement("include");
        element5.setAttribute("name", "**/*.class");
        element4.appendChild(element5);
        element3.appendChild(element4);
        element2.appendChild(element3);
        element3 = this.document.createElement("delete");
        element3.setAttribute("dir", "${javadoc.outdir}");
        element2.appendChild(element3);
    }

    private void addRunTarget(Element element, String string) {
        Element element2 = this.addTarget(element, "run");
        element2.setAttribute("depends", "compile");
        element2.appendChild(this.document.createComment("Use this target if you want to run the project"));
        Element element3 = this.document.createElement("java");
        element2.appendChild(element3);
        element3.setAttribute("classname", string);
        element3.setAttribute("fork", "yes");
        this.addClasspathRefid(element3);
    }

    private void addClasspathRefid(Element element) {
        Element element2 = this.document.createElement("classpath");
        element2.setAttribute("refid", "classpath");
        element.appendChild(element2);
    }

    private void addClasspathId(Element element) {
        Element element2 = this.document.createElement("path");
        element2.setAttribute("id", "classpath");
        element.appendChild(element2);
        this.addPathelement(element2, "location", "${compile.outdir}");
        Vector vector = this.stat.summaryStep.getLibraryList();
        if (vector.size() < 1) {
            return;
        }
        boolean bl = this.destinationDir.equals(this.sourceDir);
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            if (bl) {
                this.addPathelement(element2, "location", file.toString());
                continue;
            }
            this.addPathelement(element2, "location", this.libSubdir + "/" + file.getName());
        }
    }

    private void saveAntBuild() throws TransformerConfigurationException, TransformerException, IOException {
        StreamSource streamSource = new StreamSource(this.getClass().getResourceAsStream("indenter.xml"));
        Transformer transformer = this.tFactory.newTransformer(streamSource);
        DOMSource dOMSource = new DOMSource(this.document);
        FileOutputStream fileOutputStream = new FileOutputStream(new File(this.destinationDir, ANT_BUILD_FILENAME));
        StreamResult streamResult = new StreamResult(fileOutputStream);
        transformer.transform(dOMSource, streamResult);
        fileOutputStream.flush();
        fileOutputStream.close();
    }

    private Element getFileset(String string, Vector vector) {
        Element element = this.document.createElement("fileset");
        element.setAttribute("dir", string);
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next().toString();
            Element element2 = this.document.createElement("include");
            element2.setAttribute("name", string2);
            element.appendChild(element2);
        }
        return element;
    }

    private void addProperty(Element element, String string, String string2) {
        Element element2 = this.document.createElement("property");
        element2.setAttribute("name", string);
        element2.setAttribute("value", string2);
        element.appendChild(element2);
    }

    private void addPathelement(Element element, String string, String string2) {
        Element element2 = this.document.createElement("pathelement");
        element2.setAttribute(string, string2);
        element.appendChild(element2);
    }

    private String getLastPart(File file, File file2) {
        String string = file.toString();
        String string2 = file2.toString();
        if (!string2.startsWith(string)) {
            JOptionPane.showMessageDialog(null, "XmlServices.getLastPart: cannot match " + file2 + " with" + file);
            return file2.getName();
        }
        return string2.substring(string.length());
    }
}

