/*
 * Decompiled with CFR 0.152.
 */
package org.bluej.extensions.exporter;

import bluej.extensions.BlueJ;
import bluej.extensions.Extension;
import bluej.extensions.MenuGenerator;
import com.nexes.wizard.Wizard;
import java.net.URL;
import org.bluej.extensions.exporter.MenuBuilder;
import org.bluej.extensions.exporter.Stat;
import org.bluej.extensions.exporter.XmlServices;
import org.bluej.extensions.exporter.steps.AntDescriptor;
import org.bluej.extensions.exporter.steps.DirectoryDescriptor;
import org.bluej.extensions.exporter.steps.FinishDescriptor;
import org.bluej.extensions.exporter.steps.SummaryDescriptor;

public class Exporter
extends Extension {
    private Stat stat;

    public void startup(BlueJ blueJ) {
        this.stat = new Stat(blueJ, this);
        this.stat.menu = new MenuBuilder(this.stat);
        this.stat.xml = new XmlServices(this.stat);
        this.stat.bluej.setMenuGenerator((MenuGenerator)this.stat.menu);
    }

    void showWizard() {
        this.stat.wizard = new Wizard(this.stat.bluej.getCurrentFrame());
        this.stat.wizard.setTitle("Export BlueJ Project");
        DirectoryDescriptor directoryDescriptor = new DirectoryDescriptor(this.stat);
        this.stat.wizard.registerWizardPanel("DirectoryDescriptor", directoryDescriptor);
        this.stat.wizard.setCurrentPanel("DirectoryDescriptor");
        AntDescriptor antDescriptor = new AntDescriptor(this.stat);
        this.stat.wizard.registerWizardPanel("AntDescriptor", antDescriptor);
        SummaryDescriptor summaryDescriptor = new SummaryDescriptor(this.stat);
        this.stat.wizard.registerWizardPanel("SummaryDescriptor", summaryDescriptor);
        FinishDescriptor finishDescriptor = new FinishDescriptor(this.stat);
        this.stat.wizard.registerWizardPanel("FinishDescriptor", finishDescriptor);
        this.stat.wizard.getDialog().setLocationRelativeTo(null);
        this.stat.wizard.showModalDialog();
    }

    public boolean isCompatible() {
        return true;
    }

    public String getVersion() {
        return "28 July 2005";
    }

    public String getName() {
        return "Project Exporter";
    }

    public String getDescription() {
        return "Provides a mean to export current BlueJ projects to other systems. Eg: NetBeans";
    }

    public URL getURL() {
        try {
            return new URL("https://bluej-project-exporter.dev.java.net/usage.html");
        }
        catch (Exception exception) {
            return null;
        }
    }
}

