/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.LegendItem;
import org.jfree.chart.Marker;
import org.jfree.chart.MarkerLabelPosition;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.chart.renderer.CategoryItemRenderer;
import org.jfree.chart.renderer.CategoryItemRendererState;
import org.jfree.chart.renderer.ItemLabelAnchor;
import org.jfree.chart.renderer.ItemLabelPosition;
import org.jfree.chart.renderer.RangeType;
import org.jfree.chart.urls.CategoryURLGenerator;
import org.jfree.data.CategoryDataset;
import org.jfree.data.Range;
import org.jfree.ui.RefineryUtilities;
import org.jfree.util.NumberUtils;
import org.jfree.util.ObjectList;
import org.jfree.util.ObjectUtils;

public abstract class AbstractCategoryItemRenderer
extends AbstractRenderer
implements CategoryItemRenderer,
Cloneable,
Serializable {
    private CategoryPlot plot;
    private CategoryItemLabelGenerator itemLabelGenerator = null;
    private ObjectList itemLabelGeneratorList = new ObjectList();
    private CategoryItemLabelGenerator baseItemLabelGenerator;
    private CategoryURLGenerator itemURLGenerator = null;
    private ObjectList itemURLGeneratorList = new ObjectList();
    private CategoryURLGenerator baseItemURLGenerator;
    private transient int rowCount;
    private transient int columnCount;
    private double itemLabelAnchorOffset = 2.0;

    protected AbstractCategoryItemRenderer() {
    }

    public CategoryPlot getPlot() {
        return this.plot;
    }

    public void setPlot(CategoryPlot categoryPlot) {
        this.plot = categoryPlot;
    }

    public CategoryItemLabelGenerator getItemLabelGenerator(int n, int n2) {
        return this.getSeriesItemLabelGenerator(n);
    }

    public CategoryItemLabelGenerator getSeriesItemLabelGenerator(int n) {
        if (this.itemLabelGenerator != null) {
            return this.itemLabelGenerator;
        }
        CategoryItemLabelGenerator categoryItemLabelGenerator = (CategoryItemLabelGenerator)this.itemLabelGeneratorList.get(n);
        if (categoryItemLabelGenerator == null) {
            categoryItemLabelGenerator = this.baseItemLabelGenerator;
        }
        return categoryItemLabelGenerator;
    }

    public void setItemLabelGenerator(CategoryItemLabelGenerator categoryItemLabelGenerator) {
        this.itemLabelGenerator = categoryItemLabelGenerator;
    }

    public void setSeriesItemLabelGenerator(int n, CategoryItemLabelGenerator categoryItemLabelGenerator) {
        this.itemLabelGeneratorList.set(n, categoryItemLabelGenerator);
    }

    public CategoryItemLabelGenerator getBaseItemLabelGenerator() {
        return this.baseItemLabelGenerator;
    }

    public void setBaseItemLabelGenerator(CategoryItemLabelGenerator categoryItemLabelGenerator) {
        this.baseItemLabelGenerator = categoryItemLabelGenerator;
    }

    public CategoryURLGenerator getItemURLGenerator(int n, int n2) {
        return this.getSeriesItemURLGenerator(n);
    }

    public CategoryURLGenerator getSeriesItemURLGenerator(int n) {
        if (this.itemURLGenerator != null) {
            return this.itemURLGenerator;
        }
        CategoryURLGenerator categoryURLGenerator = (CategoryURLGenerator)this.itemURLGeneratorList.get(n);
        if (categoryURLGenerator == null) {
            categoryURLGenerator = this.baseItemURLGenerator;
        }
        return categoryURLGenerator;
    }

    public void setItemURLGenerator(CategoryURLGenerator categoryURLGenerator) {
        this.itemURLGenerator = categoryURLGenerator;
    }

    public void setSeriesItemURLGenerator(int n, CategoryURLGenerator categoryURLGenerator) {
        this.itemURLGeneratorList.set(n, categoryURLGenerator);
    }

    public CategoryURLGenerator getBaseItemURLGenerator() {
        return this.baseItemURLGenerator;
    }

    public void setBaseItemURLGenerator(CategoryURLGenerator categoryURLGenerator) {
        this.baseItemURLGenerator = categoryURLGenerator;
    }

    public double getItemLabelAnchorOffset() {
        return this.itemLabelAnchorOffset;
    }

    public void setItemLabelAnchorOffset(double d) {
        this.itemLabelAnchorOffset = d;
        this.firePropertyChanged("ItemLabelAnchorOffset", null, null);
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public CategoryItemRendererState initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, Integer n, PlotRenderingInfo plotRenderingInfo) {
        this.setPlot(categoryPlot);
        CategoryDataset categoryDataset = this.getDataset(categoryPlot, n);
        if (categoryDataset != null) {
            this.rowCount = categoryDataset.getRowCount();
            this.columnCount = categoryDataset.getColumnCount();
        } else {
            this.rowCount = 0;
            this.columnCount = 0;
        }
        return new CategoryItemRendererState(plotRenderingInfo);
    }

    public RangeType getRangeType() {
        return RangeType.STANDARD;
    }

    public void drawBackground(Graphics2D graphics2D, CategoryPlot categoryPlot, Rectangle2D rectangle2D) {
        categoryPlot.drawBackground(graphics2D, rectangle2D);
    }

    public void drawOutline(Graphics2D graphics2D, CategoryPlot categoryPlot, Rectangle2D rectangle2D) {
        categoryPlot.drawOutline(graphics2D, rectangle2D);
    }

    public void drawDomainGridline(Graphics2D graphics2D, CategoryPlot categoryPlot, Rectangle2D rectangle2D, double d) {
        Line2D.Double double_ = null;
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            double_ = new Line2D.Double(rectangle2D.getMinX(), d, rectangle2D.getMaxX(), d);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            double_ = new Line2D.Double(d, rectangle2D.getMinY(), d, rectangle2D.getMaxY());
        }
        Paint paint = categoryPlot.getDomainGridlinePaint();
        if (paint == null) {
            paint = CategoryPlot.DEFAULT_GRIDLINE_PAINT;
        }
        graphics2D.setPaint(paint);
        Stroke stroke = categoryPlot.getDomainGridlineStroke();
        if (stroke == null) {
            stroke = CategoryPlot.DEFAULT_GRIDLINE_STROKE;
        }
        graphics2D.setStroke(stroke);
        graphics2D.draw(double_);
    }

    public void drawRangeGridline(Graphics2D graphics2D, CategoryPlot categoryPlot, ValueAxis valueAxis, Rectangle2D rectangle2D, double d) {
        Range range = valueAxis.getRange();
        if (!range.contains(d)) {
            return;
        }
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        double d2 = valueAxis.translateValueToJava2D(d, rectangle2D, categoryPlot.getRangeAxisEdge());
        Line2D.Double double_ = null;
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            double_ = new Line2D.Double(d2, rectangle2D.getMinY(), d2, rectangle2D.getMaxY());
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            double_ = new Line2D.Double(rectangle2D.getMinX(), d2, rectangle2D.getMaxX(), d2);
        }
        Paint paint = categoryPlot.getRangeGridlinePaint();
        if (paint == null) {
            paint = CategoryPlot.DEFAULT_GRIDLINE_PAINT;
        }
        graphics2D.setPaint(paint);
        Stroke stroke = categoryPlot.getRangeGridlineStroke();
        if (stroke == null) {
            stroke = CategoryPlot.DEFAULT_GRIDLINE_STROKE;
        }
        graphics2D.setStroke(stroke);
        graphics2D.draw(double_);
    }

    public void drawRangeMarker(Graphics2D graphics2D, CategoryPlot categoryPlot, ValueAxis valueAxis, Marker marker, Rectangle2D rectangle2D) {
        double d = marker.getValue();
        Range range = valueAxis.getRange();
        if (!range.contains(d)) {
            return;
        }
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        double d2 = valueAxis.translateValueToJava2D(d, rectangle2D, categoryPlot.getRangeAxisEdge());
        Line2D.Double double_ = null;
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            double_ = new Line2D.Double(d2, rectangle2D.getMinY(), d2, rectangle2D.getMaxY());
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            double_ = new Line2D.Double(rectangle2D.getMinX(), d2, rectangle2D.getMaxX(), d2);
        }
        graphics2D.setPaint(marker.getOutlinePaint());
        graphics2D.setStroke(marker.getOutlineStroke());
        graphics2D.draw(double_);
        String string = marker.getLabel();
        MarkerLabelPosition markerLabelPosition = marker.getLabelPosition();
        if (string != null) {
            Font font = marker.getLabelFont();
            graphics2D.setFont(font);
            graphics2D.setPaint(marker.getLabelPaint());
            double[] dArray = this.calculateRangeMarkerTextPosition(graphics2D, plotOrientation, rectangle2D, d2, string, font, markerLabelPosition);
            graphics2D.drawString(string, (int)dArray[0], (int)dArray[1]);
        }
    }

    private double[] calculateRangeMarkerTextPosition(Graphics2D graphics2D, PlotOrientation plotOrientation, Rectangle2D rectangle2D, double d, String string, Font font, MarkerLabelPosition markerLabelPosition) {
        double[] dArray = new double[2];
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        LineMetrics lineMetrics = font.getLineMetrics(string, fontRenderContext);
        Rectangle2D rectangle2D2 = fontMetrics.getStringBounds(string, graphics2D);
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            if (markerLabelPosition == MarkerLabelPosition.TOP_LEFT) {
                dArray[0] = d - rectangle2D2.getWidth() - 2.0;
                dArray[1] = rectangle2D.getMinY() + rectangle2D2.getHeight();
            } else if (markerLabelPosition == MarkerLabelPosition.TOP_RIGHT) {
                dArray[0] = d + 2.0;
                dArray[1] = rectangle2D.getMinY() + rectangle2D2.getHeight();
            } else if (markerLabelPosition == MarkerLabelPosition.BOTTOM_LEFT) {
                dArray[0] = d - rectangle2D2.getWidth() - 2.0;
                dArray[1] = rectangle2D.getMaxY() - (double)lineMetrics.getDescent() - (double)lineMetrics.getLeading();
            } else if (markerLabelPosition == MarkerLabelPosition.BOTTOM_RIGHT) {
                dArray[0] = d + 2.0;
                dArray[1] = rectangle2D.getMaxY() - (double)lineMetrics.getDescent() - (double)lineMetrics.getLeading();
            }
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            if (markerLabelPosition == MarkerLabelPosition.TOP_LEFT) {
                dArray[0] = rectangle2D.getMinX() + 2.0;
                dArray[1] = d - (double)lineMetrics.getDescent() - (double)lineMetrics.getLeading();
            } else if (markerLabelPosition == MarkerLabelPosition.TOP_RIGHT) {
                dArray[0] = rectangle2D.getMaxX() - rectangle2D2.getWidth() - 2.0;
                dArray[1] = d - (double)lineMetrics.getDescent() - (double)lineMetrics.getLeading();
            } else if (markerLabelPosition == MarkerLabelPosition.BOTTOM_LEFT) {
                dArray[0] = rectangle2D.getMinX() + 2.0;
                dArray[1] = d + rectangle2D2.getHeight();
            } else if (markerLabelPosition == MarkerLabelPosition.BOTTOM_RIGHT) {
                dArray[0] = rectangle2D.getMaxX() - rectangle2D2.getWidth() - 2.0;
                dArray[1] = d + rectangle2D2.getHeight();
            }
        }
        return dArray;
    }

    public LegendItem getLegendItem(int n, int n2) {
        String string;
        CategoryPlot categoryPlot = this.getPlot();
        if (categoryPlot == null) {
            return null;
        }
        CategoryDataset categoryDataset = n == 0 ? categoryPlot.getDataset() : categoryPlot.getSecondaryDataset(n - 1);
        String string2 = string = categoryDataset.getRowKey(n2).toString();
        Shape shape = this.getSeriesShape(n2);
        Paint paint = this.getSeriesPaint(n2);
        Paint paint2 = this.getSeriesOutlinePaint(n2);
        Stroke stroke = this.getSeriesStroke(n2);
        return new LegendItem(string, string2, shape, paint, paint2, stroke);
    }

    public boolean equals(Object object) {
        boolean bl = super.equals(object);
        if (object instanceof AbstractCategoryItemRenderer) {
            AbstractCategoryItemRenderer abstractCategoryItemRenderer = (AbstractCategoryItemRenderer)object;
            boolean bl2 = ObjectUtils.equal(this.itemLabelGenerator, abstractCategoryItemRenderer.itemLabelGenerator);
            boolean bl3 = ObjectUtils.equal(this.itemLabelGeneratorList, abstractCategoryItemRenderer.itemLabelGeneratorList);
            boolean bl4 = ObjectUtils.equal(this.baseItemLabelGenerator, abstractCategoryItemRenderer.baseItemLabelGenerator);
            boolean bl5 = ObjectUtils.equal(this.itemURLGenerator, abstractCategoryItemRenderer.itemURLGenerator);
            boolean bl6 = ObjectUtils.equal(this.itemURLGeneratorList, abstractCategoryItemRenderer.itemURLGeneratorList);
            boolean bl7 = ObjectUtils.equal(this.baseItemURLGenerator, abstractCategoryItemRenderer.baseItemURLGenerator);
            boolean bl8 = NumberUtils.equal(this.itemLabelAnchorOffset, abstractCategoryItemRenderer.itemLabelAnchorOffset);
            bl = bl2 && bl3 && bl4 && bl5 && bl6 && bl7 && bl8;
        }
        return bl;
    }

    public int hashCode() {
        int n = super.hashCode();
        return n;
    }

    public DrawingSupplier getDrawingSupplier() {
        DrawingSupplier drawingSupplier = null;
        CategoryPlot categoryPlot = this.getPlot();
        if (categoryPlot != null) {
            drawingSupplier = categoryPlot.getDrawingSupplier();
        }
        return drawingSupplier;
    }

    protected void drawItemLabel(Graphics2D graphics2D, PlotOrientation plotOrientation, CategoryDataset categoryDataset, int n, int n2, double d, double d2, boolean bl) {
        CategoryItemLabelGenerator categoryItemLabelGenerator = this.getItemLabelGenerator(n, n2);
        if (categoryItemLabelGenerator != null) {
            Font font = this.getItemLabelFont(n, n2);
            graphics2D.setFont(font);
            Paint paint = this.getItemLabelPaint(n, n2);
            graphics2D.setPaint(paint);
            String string = categoryItemLabelGenerator.generateItemLabel(categoryDataset, n, n2);
            ItemLabelPosition itemLabelPosition = null;
            itemLabelPosition = !bl ? this.getPositiveItemLabelPosition(n, n2) : this.getNegativeItemLabelPosition(n, n2);
            Point2D point2D = this.calculateLabelAnchorPoint(itemLabelPosition.getItemLabelAnchor(), d, d2, plotOrientation);
            RefineryUtilities.drawRotatedString(string, graphics2D, (float)point2D.getX(), (float)point2D.getY(), itemLabelPosition.getTextAnchor(), itemLabelPosition.getRotationAnchor(), itemLabelPosition.getAngle());
        }
    }

    private Point2D calculateLabelAnchorPoint(ItemLabelAnchor itemLabelAnchor, double d, double d2, PlotOrientation plotOrientation) {
        Point2D.Double double_ = null;
        if (itemLabelAnchor == ItemLabelAnchor.CENTER) {
            double_ = new Point2D.Double(d, d2);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE1) {
            double_ = new Point2D.Double(d, d2);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE2) {
            double_ = new Point2D.Double(d, d2);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE3) {
            double_ = new Point2D.Double(d + this.itemLabelAnchorOffset, d2);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE4) {
            double_ = new Point2D.Double(d, d2);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE5) {
            double_ = new Point2D.Double(d, d2);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE6) {
            double_ = new Point2D.Double(d, d2 + this.itemLabelAnchorOffset);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE7) {
            double_ = new Point2D.Double(d, d2);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE8) {
            double_ = new Point2D.Double(d, d2);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE9) {
            double_ = new Point2D.Double(d - this.itemLabelAnchorOffset, d2);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE10) {
            double_ = new Point2D.Double(d, d2);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE11) {
            double_ = new Point2D.Double(d, d2);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE12) {
            double_ = new Point2D.Double(d, d2 - this.itemLabelAnchorOffset);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE1) {
            double_ = new Point2D.Double(d, d2);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE2) {
            double_ = new Point2D.Double(d, d2);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE3) {
            double_ = new Point2D.Double(d + 2.0 * this.itemLabelAnchorOffset, d2);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE4) {
            double_ = new Point2D.Double(d, d2);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE5) {
            double_ = new Point2D.Double(d, d2);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE6) {
            double_ = new Point2D.Double(d, d2 + 2.0 * this.itemLabelAnchorOffset);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE7) {
            double_ = new Point2D.Double(d, d2);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE8) {
            double_ = new Point2D.Double(d, d2);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE9) {
            double_ = new Point2D.Double(d - 2.0 * this.itemLabelAnchorOffset, d2);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE10) {
            double_ = new Point2D.Double(d, d2);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE11) {
            double_ = new Point2D.Double(d, d2);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE12) {
            double_ = new Point2D.Double(d, d2 - 2.0 * this.itemLabelAnchorOffset);
        }
        return double_;
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractCategoryItemRenderer abstractCategoryItemRenderer = (AbstractCategoryItemRenderer)super.clone();
        if (this.itemLabelGenerator != null) {
            abstractCategoryItemRenderer.itemLabelGenerator = (CategoryItemLabelGenerator)this.itemLabelGenerator.clone();
        }
        if (this.itemLabelGeneratorList != null) {
            abstractCategoryItemRenderer.itemLabelGeneratorList = (ObjectList)this.itemLabelGeneratorList.clone();
        }
        if (this.baseItemLabelGenerator != null) {
            abstractCategoryItemRenderer.baseItemLabelGenerator = (CategoryItemLabelGenerator)this.baseItemLabelGenerator.clone();
        }
        if (this.itemURLGenerator != null) {
            abstractCategoryItemRenderer.itemURLGenerator = (CategoryURLGenerator)this.itemURLGenerator.clone();
        }
        if (this.itemURLGeneratorList != null) {
            abstractCategoryItemRenderer.itemURLGeneratorList = (ObjectList)this.itemURLGeneratorList.clone();
        }
        if (this.baseItemURLGenerator != null) {
            abstractCategoryItemRenderer.baseItemURLGenerator = (CategoryURLGenerator)this.baseItemURLGenerator.clone();
        }
        return abstractCategoryItemRenderer;
    }

    protected CategoryAxis getDomainAxis(CategoryPlot categoryPlot, Integer n) {
        CategoryAxis categoryAxis = null;
        if (n == null) {
            categoryAxis = categoryPlot.getDomainAxis();
        } else {
            categoryAxis = categoryPlot.getSecondaryDomainAxis(n);
            if (categoryAxis == null) {
                categoryAxis = categoryPlot.getDomainAxis();
            }
        }
        return categoryAxis;
    }

    protected ValueAxis getRangeAxis(CategoryPlot categoryPlot, Integer n) {
        ValueAxis valueAxis = null;
        if (n == null) {
            valueAxis = categoryPlot.getRangeAxis();
        } else {
            valueAxis = categoryPlot.getSecondaryRangeAxis(n);
            if (valueAxis == null) {
                valueAxis = categoryPlot.getRangeAxis();
            }
        }
        return valueAxis;
    }

    protected CategoryDataset getDataset(CategoryPlot categoryPlot, Integer n) {
        CategoryDataset categoryDataset = null;
        categoryDataset = n == null ? categoryPlot.getDataset() : categoryPlot.getSecondaryDataset(n);
        return categoryDataset;
    }
}

