/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.axis.AxisSpace;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTick;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.Tick;
import org.jfree.chart.axis.ValueTick;
import org.jfree.chart.plot.Plot;
import org.jfree.data.Range;
import org.jfree.io.SerialUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.TextAnchor;
import org.jfree.util.ObjectUtils;

public class CyclicNumberAxis
extends NumberAxis {
    protected double offset;
    protected double period;
    protected boolean boundMappedToLastCycle;
    protected boolean advanceLineVisible;
    public static Stroke DEFAULT_ADVANCE_LINE_STROKE = new BasicStroke(1.0f);
    public static final Paint DEFAULT_ADVANCE_LINE_PAINT = Color.gray;
    protected transient Stroke advanceLineStroke = DEFAULT_ADVANCE_LINE_STROKE;
    protected transient Paint advanceLinePaint = DEFAULT_ADVANCE_LINE_PAINT;
    private transient boolean internalMarkerWhenTicksOverlap;
    private transient Tick internalMarkerCycleBoundTick;

    public Paint getAdvanceLinePaint() {
        return this.advanceLinePaint;
    }

    public void setAdvanceLinePaint(Paint paint) {
        this.advanceLinePaint = paint;
    }

    public Stroke getAdvanceLineStroke() {
        return this.advanceLineStroke;
    }

    public void setAdvanceLineStroke(Stroke stroke) {
        this.advanceLineStroke = stroke;
    }

    public boolean isAdvanceLineVisible() {
        return this.advanceLineVisible;
    }

    public void setAdvanceLineVisible(boolean bl) {
        this.advanceLineVisible = bl;
    }

    public boolean isBoundMappedToLastCycle() {
        return this.boundMappedToLastCycle;
    }

    public void setBoundMappedToLastCycle(boolean bl) {
        this.boundMappedToLastCycle = bl;
    }

    public CyclicNumberAxis(double d) {
        this(0.0, d);
    }

    public CyclicNumberAxis(double d, double d2) {
        this(d, d2, null);
    }

    public CyclicNumberAxis(double d, String string) {
        this(0.0, d, string);
    }

    public CyclicNumberAxis(double d, double d2, String string) {
        super(string);
        this.period = d;
        this.offset = d2;
        this.setFixedAutoRange(d);
        this.advanceLineVisible = true;
    }

    protected void selectHorizontalAutoTickUnit(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge) {
        double d = this.estimateMaximumTickLabelWidth(graphics2D, this.getTickUnit());
        double d2 = this.getRange().getLength() * d / rectangle2D2.getWidth();
        this.setTickUnit((NumberTickUnit)this.getStandardTickUnits().getCeilingTickUnit(d2), false, false);
    }

    protected void selectVerticalAutoTickUnit(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge) {
        double d = this.estimateMaximumTickLabelWidth(graphics2D, this.getTickUnit());
        double d2 = this.getRange().getLength() * d / rectangle2D2.getHeight();
        this.setTickUnit((NumberTickUnit)this.getStandardTickUnits().getCeilingTickUnit(d2), false, false);
    }

    protected float[] calculateAnchorPoint(ValueTick valueTick, double d, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        if (valueTick instanceof CycleBoundTick) {
            boolean bl = this.boundMappedToLastCycle;
            this.boundMappedToLastCycle = ((CycleBoundTick)valueTick).mapToLastCycle;
            float[] fArray = super.calculateAnchorPoint(valueTick, d, rectangle2D, rectangleEdge);
            this.boundMappedToLastCycle = bl;
            return fArray;
        }
        return super.calculateAnchorPoint(valueTick, d, rectangle2D, rectangleEdge);
    }

    public List refreshHorizontalTicks(Graphics2D graphics2D, double d, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge) {
        ArrayList<CycleBoundTick> arrayList = new ArrayList<CycleBoundTick>();
        Font font = this.getTickLabelFont();
        graphics2D.setFont(font);
        if (this.isAutoTickUnitSelection()) {
            this.selectAutoTickUnit(graphics2D, rectangle2D, rectangle2D2, rectangleEdge);
        }
        double d2 = this.getTickUnit().getSize();
        double d3 = this.getCycleBound();
        double d4 = Math.ceil(d3 / d2) * d2;
        double d5 = this.getRange().getUpperBound();
        boolean bl = false;
        boolean bl2 = this.boundMappedToLastCycle;
        this.boundMappedToLastCycle = false;
        NumberTick numberTick = null;
        float f = 0.0f;
        if (d5 == d3) {
            d4 = this.calculateLowestVisibleTickValue();
            bl = true;
            this.boundMappedToLastCycle = true;
        }
        while (d4 <= d5) {
            boolean bl3 = false;
            if (d4 + d2 > d5 && !bl) {
                bl3 = true;
            }
            double d6 = this.translateValueToJava2D(d4, rectangle2D2, rectangleEdge);
            NumberFormat numberFormat = this.getNumberFormatOverride();
            String string = numberFormat != null ? numberFormat.format(d4) : this.getTickUnit().valueToString(d4);
            float f2 = (float)d6;
            float f3 = 0.0f;
            TextAnchor textAnchor = null;
            TextAnchor textAnchor2 = null;
            double d7 = 0.0;
            Insets insets = this.getTickLabelInsets();
            if (this.isVerticalTickLabels()) {
                if (rectangleEdge == RectangleEdge.TOP) {
                    f3 = (float)(d - (double)insets.right);
                    d7 = 1.5707963267948966;
                } else {
                    f3 = (float)(d + (double)insets.right);
                    d7 = -1.5707963267948966;
                }
                textAnchor = TextAnchor.CENTER_RIGHT;
                if (numberTick != null && f == f2 && d4 != d3) {
                    textAnchor = this.isInverted() ? TextAnchor.TOP_RIGHT : TextAnchor.BOTTOM_RIGHT;
                    arrayList.remove(arrayList.size() - 1);
                    arrayList.add(new CycleBoundTick(this.boundMappedToLastCycle, numberTick.getNumber(), numberTick.getText(), f2, f3, textAnchor, textAnchor, numberTick.getAngle()));
                    this.internalMarkerWhenTicksOverlap = true;
                    textAnchor = this.isInverted() ? TextAnchor.BOTTOM_RIGHT : TextAnchor.TOP_RIGHT;
                }
                textAnchor2 = textAnchor;
            } else if (rectangleEdge == RectangleEdge.TOP) {
                f3 = (float)(d - (double)insets.bottom);
                textAnchor = TextAnchor.BOTTOM_CENTER;
                if (numberTick != null && f == f2 && d4 != d3) {
                    textAnchor = this.isInverted() ? TextAnchor.BOTTOM_LEFT : TextAnchor.BOTTOM_RIGHT;
                    arrayList.remove(arrayList.size() - 1);
                    arrayList.add(new CycleBoundTick(this.boundMappedToLastCycle, numberTick.getNumber(), numberTick.getText(), f2, f3, textAnchor, textAnchor, numberTick.getAngle()));
                    this.internalMarkerWhenTicksOverlap = true;
                    textAnchor = this.isInverted() ? TextAnchor.BOTTOM_RIGHT : TextAnchor.BOTTOM_LEFT;
                }
                textAnchor2 = textAnchor;
            } else {
                f3 = (float)(d + (double)insets.top);
                textAnchor = TextAnchor.TOP_CENTER;
                if (numberTick != null && f == f2 && d4 != d3) {
                    textAnchor = this.isInverted() ? TextAnchor.TOP_LEFT : TextAnchor.TOP_RIGHT;
                    arrayList.remove(arrayList.size() - 1);
                    arrayList.add(new CycleBoundTick(this.boundMappedToLastCycle, numberTick.getNumber(), numberTick.getText(), f2, f3, textAnchor, textAnchor, numberTick.getAngle()));
                    this.internalMarkerWhenTicksOverlap = true;
                    textAnchor = this.isInverted() ? TextAnchor.TOP_RIGHT : TextAnchor.TOP_LEFT;
                }
                textAnchor2 = textAnchor;
            }
            CycleBoundTick cycleBoundTick = new CycleBoundTick(this.boundMappedToLastCycle, new Double(d4), string, f2, f3, textAnchor, textAnchor2, d7);
            if (d4 == d3) {
                this.internalMarkerCycleBoundTick = cycleBoundTick;
            }
            arrayList.add(cycleBoundTick);
            numberTick = cycleBoundTick;
            f = f2;
            d4 += d2;
            if (!bl3) continue;
            d4 = this.calculateLowestVisibleTickValue();
            d5 = d3;
            bl = true;
            this.boundMappedToLastCycle = true;
        }
        this.boundMappedToLastCycle = bl2;
        return arrayList;
    }

    public List refreshVerticalTicks(Graphics2D graphics2D, double d, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge) {
        ArrayList<CycleBoundTick> arrayList = new ArrayList<CycleBoundTick>();
        arrayList.clear();
        Font font = this.getTickLabelFont();
        graphics2D.setFont(font);
        if (this.isAutoTickUnitSelection()) {
            this.selectAutoTickUnit(graphics2D, rectangle2D, rectangle2D2, rectangleEdge);
        }
        double d2 = this.getTickUnit().getSize();
        double d3 = this.getCycleBound();
        double d4 = Math.ceil(d3 / d2) * d2;
        double d5 = this.getRange().getUpperBound();
        boolean bl = false;
        boolean bl2 = this.boundMappedToLastCycle;
        this.boundMappedToLastCycle = true;
        NumberTick numberTick = null;
        float f = 0.0f;
        if (d5 == d3) {
            d4 = this.calculateLowestVisibleTickValue();
            bl = true;
            this.boundMappedToLastCycle = true;
        }
        while (d4 <= d5) {
            boolean bl3 = false;
            if (d4 + d2 > d5 && !bl) {
                bl3 = true;
            }
            double d6 = this.translateValueToJava2D(d4, rectangle2D2, rectangleEdge);
            NumberFormat numberFormat = this.getNumberFormatOverride();
            String string = numberFormat != null ? numberFormat.format(d4) : this.getTickUnit().valueToString(d4);
            float f2 = 0.0f;
            float f3 = (float)d6;
            TextAnchor textAnchor = null;
            TextAnchor textAnchor2 = null;
            double d7 = 0.0;
            if (this.isVerticalTickLabels()) {
                if (rectangleEdge == RectangleEdge.LEFT) {
                    f2 = (float)(d - (double)this.getTickLabelInsets().right);
                    textAnchor = TextAnchor.BOTTOM_CENTER;
                    if (numberTick != null && f == f3 && d4 != d3) {
                        textAnchor = this.isInverted() ? TextAnchor.BOTTOM_LEFT : TextAnchor.BOTTOM_RIGHT;
                        arrayList.remove(arrayList.size() - 1);
                        arrayList.add(new CycleBoundTick(this.boundMappedToLastCycle, numberTick.getNumber(), numberTick.getText(), f2, f3, textAnchor, textAnchor, numberTick.getAngle()));
                        this.internalMarkerWhenTicksOverlap = true;
                        textAnchor = this.isInverted() ? TextAnchor.BOTTOM_RIGHT : TextAnchor.BOTTOM_LEFT;
                    }
                    textAnchor2 = textAnchor;
                    d7 = -1.5707963267948966;
                } else {
                    f2 = (float)(d + (double)this.getTickLabelInsets().left);
                    textAnchor = TextAnchor.BOTTOM_CENTER;
                    if (numberTick != null && f == f3 && d4 != d3) {
                        textAnchor = this.isInverted() ? TextAnchor.BOTTOM_RIGHT : TextAnchor.BOTTOM_LEFT;
                        arrayList.remove(arrayList.size() - 1);
                        arrayList.add(new CycleBoundTick(this.boundMappedToLastCycle, numberTick.getNumber(), numberTick.getText(), f2, f3, textAnchor, textAnchor, numberTick.getAngle()));
                        this.internalMarkerWhenTicksOverlap = true;
                        textAnchor = this.isInverted() ? TextAnchor.BOTTOM_LEFT : TextAnchor.BOTTOM_RIGHT;
                    }
                    textAnchor2 = textAnchor;
                    d7 = 1.5707963267948966;
                }
            } else if (rectangleEdge == RectangleEdge.LEFT) {
                f2 = (float)(d - (double)this.getTickLabelInsets().right);
                textAnchor = TextAnchor.CENTER_RIGHT;
                if (numberTick != null && f == f3 && d4 != d3) {
                    textAnchor = this.isInverted() ? TextAnchor.BOTTOM_RIGHT : TextAnchor.TOP_RIGHT;
                    arrayList.remove(arrayList.size() - 1);
                    arrayList.add(new CycleBoundTick(this.boundMappedToLastCycle, numberTick.getNumber(), numberTick.getText(), f2, f3, textAnchor, textAnchor, numberTick.getAngle()));
                    this.internalMarkerWhenTicksOverlap = true;
                    textAnchor = this.isInverted() ? TextAnchor.TOP_RIGHT : TextAnchor.BOTTOM_RIGHT;
                }
                textAnchor2 = textAnchor;
            } else {
                f2 = (float)(d + (double)this.getTickLabelInsets().left);
                textAnchor = TextAnchor.CENTER_LEFT;
                if (numberTick != null && f == f3 && d4 != d3) {
                    textAnchor = this.isInverted() ? TextAnchor.BOTTOM_LEFT : TextAnchor.TOP_LEFT;
                    arrayList.remove(arrayList.size() - 1);
                    arrayList.add(new CycleBoundTick(this.boundMappedToLastCycle, numberTick.getNumber(), numberTick.getText(), f2, f3, textAnchor, textAnchor, numberTick.getAngle()));
                    this.internalMarkerWhenTicksOverlap = true;
                    textAnchor = this.isInverted() ? TextAnchor.TOP_LEFT : TextAnchor.BOTTOM_LEFT;
                }
                textAnchor2 = textAnchor;
            }
            CycleBoundTick cycleBoundTick = new CycleBoundTick(this.boundMappedToLastCycle, new Double(d4), string, f2, f3, textAnchor, textAnchor2, d7);
            if (d4 == d3) {
                this.internalMarkerCycleBoundTick = cycleBoundTick;
            }
            arrayList.add(cycleBoundTick);
            numberTick = cycleBoundTick;
            f = f3;
            if (d4 == d3) {
                this.internalMarkerCycleBoundTick = cycleBoundTick;
            }
            d4 += d2;
            if (!bl3) continue;
            d4 = this.calculateLowestVisibleTickValue();
            d5 = d3;
            bl = true;
            this.boundMappedToLastCycle = false;
        }
        this.boundMappedToLastCycle = bl2;
        return arrayList;
    }

    public double translateJava2DToValue(double d, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        Range range = this.getRange();
        double d2 = range.getUpperBound();
        double d3 = this.getCycleBound();
        double d4 = 0.0;
        double d5 = 0.0;
        if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
            d4 = rectangle2D.getMinX();
            d5 = rectangle2D.getMaxX();
        } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
            d4 = rectangle2D.getMaxY();
            d5 = rectangle2D.getMinY();
        }
        if (this.isInverted()) {
            double d6 = d5 - (d2 - d3) * (d5 - d4) / this.period;
            if (d >= d6) {
                return d3 + (d5 - d) * this.period / (d5 - d4);
            }
            return d3 - (d - d4) * this.period / (d5 - d4);
        }
        double d7 = (d2 - d3) * (d5 - d4) / this.period + d4;
        if (d <= d7) {
            return d3 + (d - d4) * this.period / (d5 - d4);
        }
        return d3 - (d5 - d) * this.period / (d5 - d4);
    }

    public double translateValueToJava2D(double d, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        Range range = this.getRange();
        double d2 = range.getLowerBound();
        double d3 = range.getUpperBound();
        double d4 = this.getCycleBound();
        if (d < d2 || d > d3) {
            return Double.NaN;
        }
        double d5 = 0.0;
        double d6 = 0.0;
        if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
            d5 = rectangle2D.getMinX();
            d6 = rectangle2D.getMaxX();
        } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
            d6 = rectangle2D.getMinY();
            d5 = rectangle2D.getMaxY();
        }
        if (this.isInverted()) {
            if (d == d4) {
                return this.boundMappedToLastCycle ? d5 : d6;
            }
            if (d > d4) {
                return d6 - (d - d4) * (d6 - d5) / this.period;
            }
            return d5 + (d4 - d) * (d6 - d5) / this.period;
        }
        if (d == d4) {
            return this.boundMappedToLastCycle ? d6 : d5;
        }
        if (d >= d4) {
            return d5 + (d - d4) * (d6 - d5) / this.period;
        }
        return d6 - (d4 - d) * (d6 - d5) / this.period;
    }

    public void centerRange(double d) {
        this.setRange(d - this.period / 2.0, d + this.period / 2.0);
    }

    public void setAutoRangeMinimumSize(double d, boolean bl) {
        if (d > this.period) {
            this.period = d;
        }
        super.setAutoRangeMinimumSize(d, bl);
    }

    public void setFixedAutoRange(double d) {
        this.period = d;
        super.setFixedAutoRange(d);
    }

    public void setRange(Range range, boolean bl, boolean bl2) {
        double d = range.getUpperBound() - range.getLowerBound();
        if (d > this.period) {
            this.period = d;
        }
        super.setRange(range, bl, bl2);
    }

    public double getCycleBound() {
        return Math.floor((this.getRange().getUpperBound() - this.offset) / this.period) * this.period + this.offset;
    }

    public double getOffset() {
        return this.offset;
    }

    public void setOffset(double d) {
        this.offset = d;
    }

    public double getPeriod() {
        return this.period;
    }

    public void setPeriod(double d) {
        this.period = d;
    }

    protected AxisState drawTickMarksAndLabels(Graphics2D graphics2D, double d, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge) {
        this.internalMarkerWhenTicksOverlap = false;
        AxisState axisState = super.drawTickMarksAndLabels(graphics2D, d, rectangle2D, rectangle2D2, rectangleEdge);
        if (!this.internalMarkerWhenTicksOverlap) {
            return axisState;
        }
        double d2 = this.getTickMarkOutsideLength();
        FontMetrics fontMetrics = graphics2D.getFontMetrics(this.getTickLabelFont());
        d2 = this.isVerticalTickLabels() ? (double)fontMetrics.getMaxAdvance() : (double)fontMetrics.getHeight();
        double d3 = 0.0;
        if (this.isTickMarksVisible()) {
            float f = (float)this.translateValueToJava2D(this.getRange().getUpperBound(), rectangle2D2, rectangleEdge);
            Line2D.Double double_ = null;
            graphics2D.setStroke(this.getTickMarkStroke());
            graphics2D.setPaint(this.getTickMarkPaint());
            if (rectangleEdge == RectangleEdge.LEFT) {
                double_ = new Line2D.Double(d - d2, f, d + d3, f);
            } else if (rectangleEdge == RectangleEdge.RIGHT) {
                double_ = new Line2D.Double(d + d2, f, d - d3, f);
            } else if (rectangleEdge == RectangleEdge.TOP) {
                double_ = new Line2D.Double(f, d - d2, f, d + d3);
            } else if (rectangleEdge == RectangleEdge.BOTTOM) {
                double_ = new Line2D.Double(f, d + d2, f, d - d3);
            }
            graphics2D.draw(double_);
        }
        return axisState;
    }

    public AxisState draw(Graphics2D graphics2D, double d, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge) {
        AxisState axisState = super.draw(graphics2D, d, rectangle2D, rectangle2D2, rectangleEdge);
        if (this.isAdvanceLineVisible()) {
            double d2 = this.translateValueToJava2D(this.getRange().getUpperBound(), rectangle2D2, rectangleEdge);
            Line2D.Double double_ = null;
            graphics2D.setStroke(this.getAdvanceLineStroke());
            graphics2D.setPaint(this.getAdvanceLinePaint());
            if (rectangleEdge == RectangleEdge.LEFT) {
                double_ = new Line2D.Double(d, d2, d + rectangle2D2.getWidth(), d2);
            } else if (rectangleEdge == RectangleEdge.RIGHT) {
                double_ = new Line2D.Double(d - rectangle2D2.getWidth(), d2, d, d2);
            } else if (rectangleEdge == RectangleEdge.TOP) {
                double_ = new Line2D.Double(d2, d + rectangle2D2.getHeight(), d2, d);
            } else if (rectangleEdge == RectangleEdge.BOTTOM) {
                double_ = new Line2D.Double(d2, d, d2, d - rectangle2D2.getHeight());
            }
            graphics2D.draw(double_);
        }
        return axisState;
    }

    public AxisSpace reserveSpace(Graphics2D graphics2D, Plot plot, Rectangle2D rectangle2D, RectangleEdge rectangleEdge, AxisSpace axisSpace) {
        this.internalMarkerCycleBoundTick = null;
        AxisSpace axisSpace2 = super.reserveSpace(graphics2D, plot, rectangle2D, rectangleEdge, axisSpace);
        if (this.internalMarkerCycleBoundTick == null) {
            return axisSpace2;
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics(this.getTickLabelFont());
        Rectangle2D rectangle2D2 = fontMetrics.getStringBounds(this.internalMarkerCycleBoundTick.getText(), graphics2D);
        if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
            if (this.isVerticalTickLabels()) {
                axisSpace.add(rectangle2D2.getHeight() / 2.0, RectangleEdge.RIGHT);
            } else {
                axisSpace.add(rectangle2D2.getWidth() / 2.0, RectangleEdge.RIGHT);
            }
        } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
            if (this.isVerticalTickLabels()) {
                axisSpace.add(rectangle2D2.getWidth() / 2.0, RectangleEdge.TOP);
            } else {
                axisSpace.add(rectangle2D2.getHeight() / 2.0, RectangleEdge.TOP);
            }
        }
        return axisSpace2;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.advanceLinePaint, objectOutputStream);
        SerialUtilities.writeStroke(this.advanceLineStroke, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.advanceLinePaint = SerialUtilities.readPaint(objectInputStream);
        this.advanceLineStroke = SerialUtilities.readStroke(objectInputStream);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof CyclicNumberAxis && super.equals(object)) {
            CyclicNumberAxis cyclicNumberAxis = (CyclicNumberAxis)object;
            boolean bl = this.period == cyclicNumberAxis.period;
            boolean bl2 = this.offset == cyclicNumberAxis.offset;
            boolean bl3 = ObjectUtils.equal(this.advanceLinePaint, cyclicNumberAxis.advanceLinePaint);
            boolean bl4 = ObjectUtils.equal(this.advanceLineStroke, cyclicNumberAxis.advanceLineStroke);
            boolean bl5 = this.advanceLineVisible == cyclicNumberAxis.advanceLineVisible;
            boolean bl6 = this.boundMappedToLastCycle == cyclicNumberAxis.boundMappedToLastCycle;
            return bl && bl2 && bl3 && bl4 && bl5 && bl6;
        }
        return false;
    }

    protected static class CycleBoundTick
    extends NumberTick {
        public boolean mapToLastCycle;

        public CycleBoundTick(boolean bl, Number number, String string, float f, float f2, TextAnchor textAnchor, TextAnchor textAnchor2, double d) {
            super(number, string, f, f2, textAnchor, textAnchor2, d);
            this.mapToLastCycle = bl;
        }
    }
}

