/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.EventListenerList;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChartConstants;
import org.jfree.chart.JFreeChartInfo;
import org.jfree.chart.Legend;
import org.jfree.chart.event.ChartChangeEvent;
import org.jfree.chart.event.ChartChangeListener;
import org.jfree.chart.event.ChartProgressEvent;
import org.jfree.chart.event.ChartProgressListener;
import org.jfree.chart.event.LegendChangeEvent;
import org.jfree.chart.event.LegendChangeListener;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.event.PlotChangeListener;
import org.jfree.chart.event.TitleChangeEvent;
import org.jfree.chart.event.TitleChangeListener;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.io.SerialUtilities;
import org.jfree.ui.Align;
import org.jfree.ui.Drawable;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.about.ProjectInfo;
import org.jfree.util.ObjectUtils;

public class JFreeChart
implements JFreeChartConstants,
Drawable,
TitleChangeListener,
LegendChangeListener,
PlotChangeListener,
Serializable,
Cloneable {
    public static final ProjectInfo INFO = new JFreeChartInfo();
    public transient RenderingHints renderingHints;
    private boolean borderVisible;
    private transient Stroke borderStroke;
    private transient Paint borderPaint;
    private TextTitle title;
    private List subtitles;
    private Legend legend;
    private Plot plot;
    private transient Paint backgroundPaint;
    private transient Image backgroundImage;
    private int backgroundImageAlignment = 15;
    private float backgroundImageAlpha = 0.5f;
    private transient EventListenerList changeListeners;
    private transient EventListenerList progressListeners;
    private boolean notify;
    static /* synthetic */ Class class$org$jfree$chart$event$ChartChangeListener;
    static /* synthetic */ Class class$org$jfree$chart$event$ChartProgressListener;

    public JFreeChart(Plot plot) {
        this(null, null, plot, false);
    }

    public JFreeChart(String string, Plot plot) {
        this(string, JFreeChartConstants.DEFAULT_TITLE_FONT, plot, true);
    }

    public JFreeChart(String string, Font font, Plot plot, boolean bl) {
        if (plot == null) {
            throw new NullPointerException("JFreeChart(..): Plot is null");
        }
        this.progressListeners = new EventListenerList();
        this.changeListeners = new EventListenerList();
        this.notify = true;
        this.renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.borderVisible = false;
        this.borderStroke = new BasicStroke(1.0f);
        this.borderPaint = Color.black;
        this.plot = plot;
        plot.addChangeListener(this);
        this.subtitles = new ArrayList();
        if (bl) {
            this.setLegend(Legend.createInstance(this));
        }
        if (string != null) {
            if (font == null) {
                font = JFreeChartConstants.DEFAULT_TITLE_FONT;
            }
            this.title = new TextTitle(string, font);
            this.title.addChangeListener(this);
        }
        this.backgroundPaint = JFreeChartConstants.DEFAULT_BACKGROUND_PAINT;
        this.backgroundImage = JFreeChartConstants.DEFAULT_BACKGROUND_IMAGE;
        this.backgroundImageAlignment = 15;
        this.backgroundImageAlpha = 0.5f;
    }

    public RenderingHints getRenderingHints() {
        return this.renderingHints;
    }

    public void setRenderingHints(RenderingHints renderingHints) {
        if (renderingHints == null) {
            throw new NullPointerException("RenderingHints given are null");
        }
        this.renderingHints = renderingHints;
        this.fireChartChanged();
    }

    public boolean isBorderVisible() {
        return this.borderVisible;
    }

    public void setBorderVisible(boolean bl) {
        this.borderVisible = bl;
        this.fireChartChanged();
    }

    public Stroke getBorderStroke() {
        return this.borderStroke;
    }

    public void setBorderStroke(Stroke stroke) {
        this.borderStroke = stroke;
        this.fireChartChanged();
    }

    public Paint getBorderPaint() {
        return this.borderPaint;
    }

    public void setBorderPaint(Paint paint) {
        this.borderPaint = paint;
        this.fireChartChanged();
    }

    public TextTitle getTitle() {
        return this.title;
    }

    public void setTitle(TextTitle textTitle) {
        this.title = textTitle;
        this.fireChartChanged();
    }

    public void setTitle(String string) {
        if (string != null) {
            if (this.title == null) {
                this.setTitle(new TextTitle(string, JFreeChartConstants.DEFAULT_TITLE_FONT));
            } else {
                this.title.setText(string);
            }
        } else {
            this.setTitle((TextTitle)null);
        }
    }

    public List getSubtitles() {
        return this.subtitles;
    }

    public void setSubtitles(List list) {
        if (list == null) {
            throw new NullPointerException("JFreeChart.setSubtitles(..): argument is null.");
        }
        this.subtitles = list;
        this.fireChartChanged();
    }

    public int getSubtitleCount() {
        return this.subtitles.size();
    }

    public Title getSubtitle(int n) {
        if (n < 0 || n == this.getSubtitleCount()) {
            throw new IllegalArgumentException("JFreeChart.getSubtitle(...): index out of range.");
        }
        return (Title)this.subtitles.get(n);
    }

    public void addSubtitle(Title title) {
        if (title != null) {
            this.subtitles.add(title);
            title.addChangeListener(this);
            this.fireChartChanged();
        }
    }

    public Legend getLegend() {
        return this.legend;
    }

    public void setLegend(Legend legend) {
        Legend legend2 = this.legend;
        if (legend2 != null) {
            legend2.removeChangeListener(this);
            legend2.registerChart(null);
        }
        this.legend = legend;
        if (legend != null) {
            legend.registerChart(this);
            legend.addChangeListener(this);
        }
        this.fireChartChanged();
    }

    public Plot getPlot() {
        return this.plot;
    }

    public CategoryPlot getCategoryPlot() {
        return (CategoryPlot)this.plot;
    }

    public XYPlot getXYPlot() {
        return (XYPlot)this.plot;
    }

    public boolean getAntiAlias() {
        Object object = this.renderingHints.get(RenderingHints.KEY_ANTIALIASING);
        if (object == null) {
            return false;
        }
        return object.equals(RenderingHints.VALUE_ANTIALIAS_ON);
    }

    public void setAntiAlias(boolean bl) {
        Object object = this.renderingHints.get(RenderingHints.KEY_ANTIALIASING);
        if (object == null) {
            object = RenderingHints.VALUE_ANTIALIAS_DEFAULT;
        }
        if (!bl && RenderingHints.VALUE_ANTIALIAS_OFF.equals(object) || bl && RenderingHints.VALUE_ANTIALIAS_ON.equals(object)) {
            return;
        }
        if (bl) {
            this.renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            this.renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        this.fireChartChanged();
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint;
    }

    public void setBackgroundPaint(Paint paint) {
        if (this.backgroundPaint != null) {
            if (!this.backgroundPaint.equals(paint)) {
                this.backgroundPaint = paint;
                this.fireChartChanged();
            }
        } else if (paint != null) {
            this.backgroundPaint = paint;
            this.fireChartChanged();
        }
    }

    public Image getBackgroundImage() {
        return this.backgroundImage;
    }

    public void setBackgroundImage(Image image) {
        if (this.backgroundImage != null) {
            if (!this.backgroundImage.equals(image)) {
                this.backgroundImage = image;
                this.fireChartChanged();
            }
        } else if (image != null) {
            this.backgroundImage = image;
            this.fireChartChanged();
        }
    }

    public int getBackgroundImageAlignment() {
        return this.backgroundImageAlignment;
    }

    public void setBackgroundImageAlignment(int n) {
        if (this.backgroundImageAlignment != n) {
            this.backgroundImageAlignment = n;
            this.fireChartChanged();
        }
    }

    public float getBackgroundImageAlpha() {
        return this.backgroundImageAlpha;
    }

    public void setBackgroundImageAlpha(float f) {
        if (this.backgroundImageAlpha != f) {
            this.backgroundImageAlpha = f;
            this.fireChartChanged();
        }
    }

    public boolean isNotify() {
        return this.notify;
    }

    public void setNotify(boolean bl) {
        this.notify = bl;
        if (bl) {
            this.notifyListeners(new ChartChangeEvent(this));
        }
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        this.draw(graphics2D, rectangle2D, null, null);
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo) {
        this.draw(graphics2D, rectangle2D, null, chartRenderingInfo);
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Point2D point2D, ChartRenderingInfo chartRenderingInfo) {
        Object object;
        Object object2;
        Object object3;
        this.notifyListeners(new ChartProgressEvent(this, this, 1, 0));
        if (chartRenderingInfo != null) {
            chartRenderingInfo.clear();
            chartRenderingInfo.setChartArea(rectangle2D);
        }
        Shape shape = graphics2D.getClip();
        graphics2D.clip(rectangle2D);
        graphics2D.addRenderingHints(this.renderingHints);
        if (this.backgroundPaint != null) {
            graphics2D.setPaint(this.backgroundPaint);
            graphics2D.fill(rectangle2D);
        }
        if (this.backgroundImage != null) {
            object3 = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, this.backgroundImageAlpha));
            object2 = new Rectangle2D.Double(0.0, 0.0, this.backgroundImage.getWidth(null), this.backgroundImage.getHeight(null));
            Align.align((Rectangle2D)object2, rectangle2D, this.backgroundImageAlignment);
            graphics2D.drawImage(this.backgroundImage, (int)((RectangularShape)object2).getX(), (int)((RectangularShape)object2).getY(), (int)((RectangularShape)object2).getWidth(), (int)((RectangularShape)object2).getHeight(), null);
            graphics2D.setComposite((Composite)object3);
        }
        if (this.isBorderVisible()) {
            object3 = this.getBorderPaint();
            object2 = this.getBorderStroke();
            if (object3 != null && object2 != null) {
                object = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth() - 1.0, rectangle2D.getHeight() - 1.0);
                graphics2D.setPaint((Paint)object3);
                graphics2D.setStroke((Stroke)object2);
                graphics2D.draw((Shape)object);
            }
        }
        object3 = new Rectangle2D.Double();
        ((Rectangle2D)object3).setRect(rectangle2D);
        if (this.title != null) {
            this.drawTitle(this.title, graphics2D, (Rectangle2D)object3);
        }
        object2 = this.subtitles.iterator();
        while (object2.hasNext()) {
            object = (Title)object2.next();
            this.drawTitle((Title)object, graphics2D, (Rectangle2D)object3);
        }
        object = object3;
        if (this.legend != null) {
            ((Rectangle2D)object).setRect(this.legend.draw(graphics2D, (Rectangle2D)object3, chartRenderingInfo));
        }
        PlotRenderingInfo plotRenderingInfo = null;
        if (chartRenderingInfo != null) {
            plotRenderingInfo = chartRenderingInfo.getPlotInfo();
        }
        this.plot.draw(graphics2D, (Rectangle2D)object, point2D, null, plotRenderingInfo);
        graphics2D.setClip(shape);
        this.notifyListeners(new ChartProgressEvent(this, this, 2, 100));
    }

    public void drawTitle(Title title, Graphics2D graphics2D, Rectangle2D rectangle2D) {
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        double d = 0.0;
        double d2 = 0.0;
        RectangleEdge rectangleEdge = title.getPosition();
        if (rectangleEdge == RectangleEdge.TOP) {
            d2 = rectangle2D.getWidth();
            d = Math.min((double)title.getPreferredHeight(graphics2D, (float)d2), rectangle2D.getHeight());
            ((Rectangle2D)double_).setRect(rectangle2D.getX(), rectangle2D.getY(), d2, d);
            title.draw(graphics2D, double_);
            rectangle2D.setRect(rectangle2D.getX(), Math.min(rectangle2D.getY() + d, rectangle2D.getMaxY()), d2, Math.max(rectangle2D.getHeight() - d, 0.0));
        } else if (rectangleEdge == RectangleEdge.BOTTOM) {
            d2 = rectangle2D.getWidth();
            d = Math.min((double)title.getPreferredHeight(graphics2D, (float)d2), rectangle2D.getHeight());
            ((Rectangle2D)double_).setRect(rectangle2D.getX(), rectangle2D.getMaxY() - d, d2, d);
            title.draw(graphics2D, double_);
            rectangle2D.setRect(rectangle2D.getX(), rectangle2D.getY(), d2, rectangle2D.getHeight() - d);
        } else if (rectangleEdge == RectangleEdge.RIGHT) {
            d = rectangle2D.getHeight();
            d2 = Math.min((double)title.getPreferredWidth(graphics2D, (float)d), rectangle2D.getWidth());
            ((Rectangle2D)double_).setRect(rectangle2D.getMaxX() - d2, rectangle2D.getY(), d2, d);
            title.draw(graphics2D, double_);
            rectangle2D.setRect(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth() - d2, d);
        } else if (rectangleEdge == RectangleEdge.LEFT) {
            d = rectangle2D.getHeight();
            d2 = Math.min((double)title.getPreferredWidth(graphics2D, (float)d), rectangle2D.getWidth());
            ((Rectangle2D)double_).setRect(rectangle2D.getX(), rectangle2D.getY(), d2, d);
            title.draw(graphics2D, double_);
            rectangle2D.setRect(rectangle2D.getX() + d2, rectangle2D.getY(), rectangle2D.getWidth() - d2, d);
        } else {
            throw new RuntimeException("JFreeChart.drawTitle(...): unknown title position.");
        }
    }

    public BufferedImage createBufferedImage(int n, int n2) {
        return this.createBufferedImage(n, n2, null);
    }

    public BufferedImage createBufferedImage(int n, int n2, ChartRenderingInfo chartRenderingInfo) {
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        this.draw(graphics2D, new Rectangle2D.Double(0.0, 0.0, n, n2), null, chartRenderingInfo);
        graphics2D.dispose();
        return bufferedImage;
    }

    public void handleClick(int n, int n2, ChartRenderingInfo chartRenderingInfo) {
        this.plot.handleClick(n, n2, chartRenderingInfo.getPlotInfo());
    }

    public void addChangeListener(ChartChangeListener chartChangeListener) {
        this.changeListeners.add(class$org$jfree$chart$event$ChartChangeListener == null ? (class$org$jfree$chart$event$ChartChangeListener = JFreeChart.class$("org.jfree.chart.event.ChartChangeListener")) : class$org$jfree$chart$event$ChartChangeListener, chartChangeListener);
    }

    public void removeChangeListener(ChartChangeListener chartChangeListener) {
        this.changeListeners.remove(class$org$jfree$chart$event$ChartChangeListener == null ? (class$org$jfree$chart$event$ChartChangeListener = JFreeChart.class$("org.jfree.chart.event.ChartChangeListener")) : class$org$jfree$chart$event$ChartChangeListener, chartChangeListener);
    }

    public void fireChartChanged() {
        ChartChangeEvent chartChangeEvent = new ChartChangeEvent(this);
        this.notifyListeners(chartChangeEvent);
    }

    protected void notifyListeners(ChartChangeEvent chartChangeEvent) {
        if (this.notify) {
            Object[] objectArray = this.changeListeners.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != (class$org$jfree$chart$event$ChartChangeListener == null ? JFreeChart.class$("org.jfree.chart.event.ChartChangeListener") : class$org$jfree$chart$event$ChartChangeListener)) continue;
                ((ChartChangeListener)objectArray[i + 1]).chartChanged(chartChangeEvent);
            }
        }
    }

    public void addProgressListener(ChartProgressListener chartProgressListener) {
        this.progressListeners.add(class$org$jfree$chart$event$ChartProgressListener == null ? (class$org$jfree$chart$event$ChartProgressListener = JFreeChart.class$("org.jfree.chart.event.ChartProgressListener")) : class$org$jfree$chart$event$ChartProgressListener, chartProgressListener);
    }

    public void removeProgressListener(ChartProgressListener chartProgressListener) {
        this.progressListeners.remove(class$org$jfree$chart$event$ChartProgressListener == null ? (class$org$jfree$chart$event$ChartProgressListener = JFreeChart.class$("org.jfree.chart.event.ChartProgressListener")) : class$org$jfree$chart$event$ChartProgressListener, chartProgressListener);
    }

    protected void notifyListeners(ChartProgressEvent chartProgressEvent) {
        Object[] objectArray = this.progressListeners.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$org$jfree$chart$event$ChartProgressListener == null ? JFreeChart.class$("org.jfree.chart.event.ChartProgressListener") : class$org$jfree$chart$event$ChartProgressListener)) continue;
            ((ChartProgressListener)objectArray[i + 1]).chartProgress(chartProgressEvent);
        }
    }

    public void titleChanged(TitleChangeEvent titleChangeEvent) {
        titleChangeEvent.setChart(this);
        this.notifyListeners(titleChangeEvent);
    }

    public void legendChanged(LegendChangeEvent legendChangeEvent) {
        legendChangeEvent.setChart(this);
        this.notifyListeners(legendChangeEvent);
    }

    public void plotChanged(PlotChangeEvent plotChangeEvent) {
        plotChangeEvent.setChart(this);
        this.notifyListeners(plotChangeEvent);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof JFreeChart) {
            JFreeChart jFreeChart = (JFreeChart)object;
            boolean bl = ObjectUtils.equal(this.title, jFreeChart.title);
            boolean bl2 = ObjectUtils.equal(this.subtitles, jFreeChart.subtitles);
            boolean bl3 = ObjectUtils.equal(this.legend, jFreeChart.legend);
            boolean bl4 = ObjectUtils.equal(this.plot, jFreeChart.plot);
            boolean bl5 = ObjectUtils.equal(this.backgroundPaint, jFreeChart.backgroundPaint);
            boolean bl6 = ObjectUtils.equal(this.backgroundImage, jFreeChart.backgroundImage);
            boolean bl7 = this.backgroundImageAlignment == jFreeChart.backgroundImageAlignment;
            boolean bl8 = this.backgroundImageAlpha == jFreeChart.backgroundImageAlpha;
            boolean bl9 = this.notify == jFreeChart.notify;
            return bl && bl2 && bl3 && bl4 && bl5 && bl6 && bl7 && bl8 && bl9;
        }
        return false;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writeStroke(this.borderStroke, objectOutputStream);
        SerialUtilities.writePaint(this.borderPaint, objectOutputStream);
        SerialUtilities.writePaint(this.backgroundPaint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.borderStroke = SerialUtilities.readStroke(objectInputStream);
        this.borderPaint = SerialUtilities.readPaint(objectInputStream);
        this.backgroundPaint = SerialUtilities.readPaint(objectInputStream);
        this.progressListeners = new EventListenerList();
        this.changeListeners = new EventListenerList();
        this.renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.title != null) {
            this.title.addChangeListener(this);
        }
        for (int i = 0; i < this.getSubtitleCount(); ++i) {
            this.getSubtitle(i).addChangeListener(this);
        }
        if (this.legend != null) {
            this.legend.addChangeListener(this);
        }
        this.plot.addChangeListener(this);
    }

    public static void main(String[] stringArray) {
        System.out.println(INFO.toString());
    }

    public boolean getSuppressChartChangeEvents() {
        return this.isNotify();
    }

    public void setSuppressChartChangeEvents(boolean bl) {
        this.setNotify(!bl);
    }

    public Object clone() throws CloneNotSupportedException {
        JFreeChart jFreeChart = (JFreeChart)super.clone();
        jFreeChart.renderingHints = (RenderingHints)this.renderingHints.clone();
        if (this.title != null) {
            jFreeChart.title = (TextTitle)this.title.clone();
            jFreeChart.title.addChangeListener(jFreeChart);
        }
        jFreeChart.subtitles = new ArrayList();
        for (int i = 0; i < this.getSubtitleCount(); ++i) {
            Title title = (Title)this.getSubtitle(i).clone();
            jFreeChart.subtitles.add(title);
            title.addChangeListener(jFreeChart);
        }
        if (this.legend != null) {
            jFreeChart.legend = (Legend)this.legend.clone();
            jFreeChart.legend.registerChart(jFreeChart);
            jFreeChart.legend.addChangeListener(jFreeChart);
        }
        if (this.plot != null) {
            jFreeChart.plot = (Plot)this.plot.clone();
            jFreeChart.plot.addChangeListener(jFreeChart);
        }
        jFreeChart.progressListeners = new EventListenerList();
        jFreeChart.changeListeners = new EventListenerList();
        return jFreeChart;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

