/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jrefactory.query;

import java.util.Enumeration;
import net.sourceforge.jrefactory.ast.ASTAdditiveExpression;
import net.sourceforge.jrefactory.ast.ASTEqualityExpression;
import net.sourceforge.jrefactory.ast.ASTMultiplicativeExpression;
import net.sourceforge.jrefactory.ast.ASTRelationalExpression;
import net.sourceforge.jrefactory.ast.ASTShiftExpression;
import net.sourceforge.jrefactory.ast.Node;
import net.sourceforge.jrefactory.query.EqualTree;
import net.sourceforge.jrefactory.query.Found;

public class Search {
    private EqualTree equalTree = new EqualTree();

    public Found search(Node root, Node lookingFor) {
        Found result;
        int lookingForLast;
        int last = root.jjtGetNumChildren();
        if (last >= (lookingForLast = lookingFor.jjtGetNumChildren()) && (result = this.searchAtLevel(root, lookingFor, last - lookingForLast)) != null) {
            return result;
        }
        for (int ndx = 0; ndx < last; ++ndx) {
            Found found = this.search(root.jjtGetChild(ndx), lookingFor);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    private Found searchAtLevel(Node root, Node lookingFor, int stop) {
        for (int ndx = 0; ndx <= stop; ++ndx) {
            Node lookingForNode;
            Node attempt = root.jjtGetChild(ndx);
            Boolean same = (Boolean)attempt.jjtAccept(this.equalTree, lookingForNode = lookingFor.jjtGetFirstChild());
            if (!same.equals(Boolean.TRUE) || !this.findAll(root, lookingFor, ndx)) continue;
            return new Found(root, ndx);
        }
        return null;
    }

    private boolean findAll(Node root, Node lookingFor, int offset) {
        for (int ndx = 1; ndx < lookingFor.jjtGetNumChildren(); ++ndx) {
            Node attempt = root.jjtGetChild(ndx + offset);
            Boolean same = (Boolean)attempt.jjtAccept(this.equalTree, lookingFor.jjtGetChild(ndx));
            if (!same.equals(Boolean.FALSE)) continue;
            return false;
        }
        return this.specialCase(root, lookingFor, offset);
    }

    private boolean specialCase(Node root, Node lookingFor, int offset) {
        Enumeration enum1 = null;
        Enumeration enum2 = null;
        if (root instanceof ASTAdditiveExpression) {
            enum1 = ((ASTAdditiveExpression)root).getNames();
            enum2 = ((ASTAdditiveExpression)lookingFor).getNames();
        } else if (root instanceof ASTEqualityExpression) {
            enum1 = ((ASTEqualityExpression)root).getNames();
            enum2 = ((ASTEqualityExpression)lookingFor).getNames();
        } else if (root instanceof ASTMultiplicativeExpression) {
            enum1 = ((ASTMultiplicativeExpression)root).getNames();
            enum2 = ((ASTMultiplicativeExpression)lookingFor).getNames();
        } else if (root instanceof ASTRelationalExpression) {
            enum1 = ((ASTRelationalExpression)root).getNames();
            enum2 = ((ASTRelationalExpression)lookingFor).getNames();
        } else if (root instanceof ASTShiftExpression) {
            enum1 = ((ASTShiftExpression)root).getNames();
            enum2 = ((ASTShiftExpression)lookingFor).getNames();
        }
        if (enum1 == null) {
            return true;
        }
        for (int ndx = 0; ndx < offset; ++ndx) {
            enum1.nextElement();
        }
        while (enum2.hasMoreElements()) {
            Object value2;
            Object value1 = enum1.nextElement();
            if (value1.equals(value2 = enum2.nextElement())) continue;
            return false;
        }
        return true;
    }
}

