/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jrefactory.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import net.sourceforge.jrefactory.io.ASCII_CharStream;
import net.sourceforge.jrefactory.io.JavaCharStream;
import net.sourceforge.jrefactory.io.SimpleCharStream;

public abstract class CharStream {
    protected int available;
    protected int[] bufcolumn;
    protected char[] buffer;
    protected int[] bufline;
    public int bufpos = -1;
    protected int bufsize;
    protected int column = 0;
    protected int inBuf = 0;
    protected Reader inputStream;
    protected int line = 1;
    protected int maxNextCharInd = 0;
    protected boolean prevCharIsCR = false;
    protected boolean prevCharIsLF = false;
    protected int tokenBegin;
    public static final int ASCII = 1;
    public static final int FULL_CHAR = 3;
    public static final int JAVA_LIKE = 4;
    public static final int UNICODE = 2;
    private static int charStreamType = -1;
    public static final boolean staticFlag = false;

    public abstract String GetImage();

    public abstract char[] GetSuffix(int var1);

    public int getBeginColumn() {
        return this.bufcolumn[this.tokenBegin];
    }

    public int getBeginLine() {
        return this.bufline[this.tokenBegin];
    }

    public int getColumn() {
        return this.bufcolumn[this.bufpos];
    }

    public int getEndColumn() {
        return this.bufcolumn[this.bufpos];
    }

    public int getEndLine() {
        return this.bufline[this.bufpos];
    }

    public int getLine() {
        return this.bufline[this.bufpos];
    }

    public char BeginToken() throws IOException {
        this.tokenBegin = -1;
        char c = this.readChar();
        this.tokenBegin = this.bufpos;
        return c;
    }

    public abstract void ReInit(Reader var1, int var2, int var3, int var4);

    public void ReInit(Reader dstream, int startline, int startcolumn) {
        this.ReInit(dstream, startline, startcolumn, 4096);
    }

    public void ReInit(InputStream dstream, int startline, int startcolumn, int buffersize) {
        this.ReInit(dstream, startline, startcolumn, buffersize);
    }

    public void ReInit(InputStream dstream, int startline, int startcolumn) {
        this.ReInit(new InputStreamReader(dstream), startline, startcolumn, 4096);
    }

    public abstract void adjustBeginLineColumn(int var1, int var2);

    public abstract void backup(int var1);

    public abstract char readChar() throws IOException;

    public static void setCharStreamType(int type) {
        charStreamType = type;
    }

    public static CharStream make(Reader dstream, int startline, int startcolumn, int buffersize) {
        if (charStreamType == 4) {
            return new JavaCharStream(dstream, startline, startcolumn, buffersize);
        }
        if (charStreamType != 2) {
            return new ASCII_CharStream(dstream, startline, startcolumn, buffersize, charStreamType == 3);
        }
        return new SimpleCharStream(dstream, startline, startcolumn, buffersize);
    }

    public static CharStream make(Reader dstream, int startline, int startcolumn) {
        return CharStream.make(dstream, startline, startcolumn, 4096);
    }

    public static CharStream make(InputStream dstream, int startline, int startcolumn, int buffersize) {
        return CharStream.make(new InputStreamReader(dstream), startline, startcolumn, buffersize);
    }

    public static CharStream make(InputStream dstream, int startline, int startcolumn) {
        return CharStream.make(new InputStreamReader(dstream), startline, startcolumn, 4096);
    }
}

