/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jrefactory.ast;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import net.sourceforge.jrefactory.ast.ASTClassBodyDeclaration;
import net.sourceforge.jrefactory.ast.Node;
import net.sourceforge.jrefactory.ast.Scope;
import net.sourceforge.jrefactory.parser.JavaParser;
import net.sourceforge.jrefactory.parser.JavaParserTreeConstants;
import net.sourceforge.jrefactory.parser.JavaParserVisitor;
import net.sourceforge.jrefactory.parser.NamedToken;
import net.sourceforge.jrefactory.parser.Token;

public class SimpleNode
implements Node {
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected JavaParser parser;
    public Vector specials;
    private int beginLine = -1;
    private int endLine;
    private int beginColumn = -1;
    private int endColumn;
    private Scope scope;
    static /* synthetic */ Class class$net$sourceforge$jrefactory$ast$ASTNestedClassDeclaration;
    static /* synthetic */ Class class$net$sourceforge$jrefactory$ast$ASTClassBodyDeclaration;

    public SimpleNode(int i) {
        this.id = i;
        this.specials = null;
    }

    public SimpleNode(JavaParser parser, int i) {
        this(i);
        this.parser = parser;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public int getBeginLine() {
        if (this.beginLine != -1) {
            return this.beginLine;
        }
        if (this.children != null && this.children.length > 0) {
            return ((SimpleNode)this.children[0]).getBeginLine();
        }
        throw new RuntimeException("Unable to determine begining line of Node.");
    }

    public int getBeginColumn() {
        if (this.beginColumn != -1) {
            return this.beginColumn;
        }
        if (this.children != null && this.children.length > 0) {
            return ((SimpleNode)this.children[0]).getBeginColumn();
        }
        throw new RuntimeException("Unable to determine begining line of Node.");
    }

    public int getEndLine() {
        return this.endLine;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    public Token getSpecial(String key) {
        if (this.specials == null || key == null) {
            return null;
        }
        int last = this.specials.size();
        for (int ndx = 0; ndx < last; ++ndx) {
            NamedToken named = (NamedToken)this.specials.elementAt(ndx);
            if (!named.check(key)) continue;
            return named.getToken();
        }
        return null;
    }

    public boolean isRequired() {
        return false;
    }

    public Scope getScope() {
        if (this.scope == null) {
            return ((SimpleNode)this.parent).getScope();
        }
        return this.scope;
    }

    public String getName() {
        return "";
    }

    public String getImage() {
        return this.getName();
    }

    public void jjtOpen() {
        if (this.parser.token.next != null) {
            this.beginLine = this.parser.token.next.beginLine;
            this.beginColumn = this.parser.token.next.beginColumn;
        }
    }

    public void jjtClose() {
        if (this.beginLine == -1 && (this.children == null || this.children.length == 0)) {
            this.beginColumn = this.parser.token.beginColumn;
        }
        if (this.beginLine == -1) {
            this.beginLine = this.parser.token.beginLine;
        }
        this.endLine = this.parser.token.endLine;
        this.endColumn = this.parser.token.endColumn;
    }

    public void setLineAndColumnInfo(int beginLine, int beginColumn, int endLine, int endColumn) {
        this.beginLine = beginLine;
        this.beginColumn = beginColumn;
        this.endLine = endLine;
        this.endColumn = endColumn;
    }

    public void testingOnly__setBeginLine(int i) {
        this.beginLine = i;
    }

    public void testingOnly__setBeginColumn(int i) {
        this.beginColumn = i;
    }

    public int jjtGetID() {
        return this.id;
    }

    public void jjtSetParent(Node n) {
        this.parent = n;
    }

    public Node jjtGetParent() {
        return this.parent;
    }

    public void jjtAddChild(Node n, int i) {
        if (this.children == null) {
            this.children = new Node[i + 1];
        } else if (i >= this.children.length) {
            Node[] c = new Node[i + 1];
            System.arraycopy(this.children, 0, c, 0, this.children.length);
            this.children = c;
        }
        this.children[i] = n;
        n.jjtSetParent(this);
    }

    public void jjtAddFirstChild(Node n) {
        if (this.children == null) {
            this.children = new Node[1];
        }
        this.children[0] = n;
        n.jjtSetParent(this);
    }

    public void jjtInsertChild(Node n, int i) {
        if (this.children == null) {
            this.children = new Node[i + 1];
        } else {
            Node[] c = new Node[Math.max(this.children.length + 1, i + 1)];
            System.arraycopy(this.children, 0, c, 0, i);
            System.arraycopy(this.children, i, c, i + 1, this.children.length - i);
            this.children = c;
        }
        this.children[i] = n;
        n.jjtSetParent(this);
    }

    public Node jjtGetChild(int i) {
        return this.children[i];
    }

    public Node jjtGetFirstChild() {
        return this.children[0];
    }

    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public boolean hasAnyChildren() {
        return this.children != null && this.children.length > 0;
    }

    public void jjtDeleteChild(int i) {
        if (this.children == null || this.children.length < i || i < 0) {
            System.out.println("Skipping this delete operation");
        } else {
            Node[] c = new Node[this.children.length - 1];
            System.arraycopy(this.children, 0, c, 0, i);
            System.arraycopy(this.children, i + 1, c, i, this.children.length - i - 1);
            this.children = c;
        }
    }

    public void addSpecial(String key, Token value) {
        if (value == null) {
            return;
        }
        if (this.specials == null) {
            this.init();
        }
        this.specials.addElement(new NamedToken(key, value));
    }

    public void removeSpecial(String key) {
        if (this.specials == null || key == null) {
            return;
        }
        int last = this.specials.size();
        for (int ndx = 0; ndx < last; ++ndx) {
            NamedToken named = (NamedToken)this.specials.elementAt(ndx);
            if (!named.check(key)) continue;
            this.specials.removeElementAt(ndx);
            return;
        }
    }

    public Object jjtAccept(JavaParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public Object childrenAccept(JavaParserVisitor visitor, Object data) {
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                if (this.children[i] == null) continue;
                this.children[i].jjtAccept(visitor, data);
            }
        }
        return data;
    }

    public String toString() {
        return JavaParserTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String prefix) {
        return prefix + this.toString();
    }

    public void dump(String prefix) {
        System.err.println(this.dumpString(prefix));
    }

    public String dumpString(String prefix) {
        StringBuffer sb = new StringBuffer(this.toString(prefix));
        SimpleNode.dumper(this, sb, prefix + " ");
        return sb.toString();
    }

    public List findChildrenOfType(Class targetType) {
        ArrayList list = new ArrayList();
        this.findChildrenOfType(targetType, list);
        return list;
    }

    public void findChildrenOfType(Class targetType, List results) {
        this.findChildrenOfType(this, targetType, results, true);
    }

    public void findChildrenOfType(Class targetType, List results, boolean descendIntoNestedClasses) {
        this.findChildrenOfType(this, targetType, results, descendIntoNestedClasses);
    }

    protected String printModifiers() {
        return "";
    }

    protected void init() {
        if (this.specials == null) {
            this.specials = new Vector();
        }
    }

    private void findChildrenOfType(Node node, Class targetType, List results, boolean descendIntoNestedClasses) {
        if (node.getClass().equals(targetType)) {
            results.add(node);
        }
        if (node.getClass().equals(class$net$sourceforge$jrefactory$ast$ASTNestedClassDeclaration == null ? (class$net$sourceforge$jrefactory$ast$ASTNestedClassDeclaration = SimpleNode.class$("net.sourceforge.jrefactory.ast.ASTNestedClassDeclaration")) : class$net$sourceforge$jrefactory$ast$ASTNestedClassDeclaration) && !descendIntoNestedClasses) {
            return;
        }
        if (node.getClass().equals(class$net$sourceforge$jrefactory$ast$ASTClassBodyDeclaration == null ? (class$net$sourceforge$jrefactory$ast$ASTClassBodyDeclaration = SimpleNode.class$("net.sourceforge.jrefactory.ast.ASTClassBodyDeclaration")) : class$net$sourceforge$jrefactory$ast$ASTClassBodyDeclaration) && ((ASTClassBodyDeclaration)node).isAnonymousInnerClass() && !descendIntoNestedClasses) {
            return;
        }
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            Node child = node.jjtGetChild(i);
            if (child.jjtGetNumChildren() > 0) {
                this.findChildrenOfType(child, targetType, results, descendIntoNestedClasses);
                continue;
            }
            if (!child.getClass().equals(targetType)) continue;
            results.add(child);
        }
    }

    private static void dumper(SimpleNode node, StringBuffer sb, String prefix) {
        if (node.children != null) {
            for (int i = 0; i < node.children.length; ++i) {
                SimpleNode n = (SimpleNode)node.children[i];
                if (n == null) continue;
                sb.append(n.toString(prefix)).append(" ").append(n.getImage());
                sb.append(n.printModifiers());
                SimpleNode.dumper(n, sb, prefix + " ");
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

