/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jrefactory.ast;

import net.sourceforge.jrefactory.ast.ModifierHolder;

public class ModifierAdapter
implements ModifierHolder {
    protected int modifiers = 0;

    public void setPrivate(boolean value) {
        this.setCode(value, 2);
    }

    public void setPrivate() {
        this.modifiers |= 2;
    }

    public void setProtected(boolean value) {
        this.setCode(value, 4);
    }

    public void setProtected() {
        this.modifiers |= 4;
    }

    public void setPublic(boolean value) {
        this.setCode(value, 1);
    }

    public void setPublic() {
        this.modifiers |= 1;
    }

    public void setAbstract(boolean value) {
        this.setCode(value, 1024);
    }

    public void setAbstract() {
        this.modifiers |= 0x400;
    }

    public void setSynchronized(boolean value) {
        this.setCode(value, 32);
    }

    public void setSynchronized() {
        this.modifiers |= 0x20;
    }

    public void setStatic(boolean value) {
        this.setCode(value, 8);
    }

    public void setStatic() {
        this.modifiers |= 8;
    }

    public void setFinal() {
        this.modifiers |= 0x10;
    }

    public void setVolatile() {
        this.modifiers |= 0x40;
    }

    public void setTransient() {
        this.modifiers |= 0x80;
    }

    public void setNative() {
        this.modifiers |= 0x100;
    }

    public void setInterface() {
        this.modifiers |= 0x200;
    }

    public void setStrict() {
        this.modifiers |= 0x800;
    }

    public void setModifiers(int modifiers) {
        this.modifiers = modifiers;
    }

    public boolean isAbstract() {
        return (this.modifiers & 0x400) != 0;
    }

    public boolean isExplicit() {
        return (this.modifiers & 0x2000) != 0;
    }

    public boolean isFinal() {
        return (this.modifiers & 0x10) != 0;
    }

    public boolean isInterface() {
        return (this.modifiers & 0x200) != 0;
    }

    public boolean isNative() {
        return (this.modifiers & 0x100) != 0;
    }

    public boolean isPrivate() {
        return (this.modifiers & 2) != 0;
    }

    public boolean isProtected() {
        return (this.modifiers & 4) != 0;
    }

    public boolean isPublic() {
        return (this.modifiers & 1) != 0;
    }

    public boolean isStatic() {
        return (this.modifiers & 8) != 0;
    }

    public boolean isStrictFP() {
        return (this.modifiers & 0x800) != 0;
    }

    public boolean isSynchronized() {
        return (this.modifiers & 0x20) != 0;
    }

    public boolean isTransient() {
        return (this.modifiers & 0x80) != 0;
    }

    public boolean isVolatile() {
        return (this.modifiers & 0x40) != 0;
    }

    public boolean isPackage() {
        return !this.isPublic() && !this.isProtected() && !this.isPrivate();
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public void copyModifiers(ModifierHolder source) {
        this.modifiers = source.getModifiers();
    }

    public void addModifier(String mod) {
        if (mod == null || mod.length() == 0) {
            return;
        }
        if (mod.equalsIgnoreCase(ModifierHolder.names[0])) {
            this.modifiers |= 0x400;
        } else if (mod.equalsIgnoreCase(ModifierHolder.names[1])) {
            this.modifiers |= 0x2000;
        } else if (mod.equalsIgnoreCase(ModifierHolder.names[2])) {
            this.modifiers |= 0x10;
        } else if (mod.equalsIgnoreCase(ModifierHolder.names[3])) {
            this.modifiers |= 0x200;
        } else if (mod.equalsIgnoreCase(ModifierHolder.names[4])) {
            this.modifiers |= 0x100;
        } else if (mod.equalsIgnoreCase(ModifierHolder.names[5])) {
            this.modifiers |= 2;
        } else if (mod.equalsIgnoreCase(ModifierHolder.names[6])) {
            this.modifiers |= 4;
        } else if (mod.equalsIgnoreCase(ModifierHolder.names[7])) {
            this.modifiers |= 1;
        } else if (mod.equalsIgnoreCase(ModifierHolder.names[8])) {
            this.modifiers |= 8;
        } else if (mod.equalsIgnoreCase(ModifierHolder.names[10])) {
            this.modifiers |= 0x800;
        } else if (mod.equalsIgnoreCase(ModifierHolder.names[11])) {
            this.modifiers |= 0x20;
        } else if (mod.equalsIgnoreCase(ModifierHolder.names[12])) {
            this.modifiers |= 0x80;
        } else if (mod.equalsIgnoreCase(ModifierHolder.names[13])) {
            this.modifiers |= 0x40;
        }
    }

    protected void setCode(boolean value, int code) {
        this.modifiers = value ? (this.modifiers |= code) : (this.modifiers &= ~code);
    }
}

