/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jrefactory.ast;

import java.util.StringTokenizer;
import net.sourceforge.jrefactory.ast.ASTIdentifier;
import net.sourceforge.jrefactory.ast.SimpleNode;
import net.sourceforge.jrefactory.parser.JavaParser;
import net.sourceforge.jrefactory.parser.JavaParserVisitor;

public class ASTName
extends SimpleNode
implements Cloneable {
    protected String name = null;

    public ASTName() {
        super(48);
    }

    public ASTName(int identifier) {
        super(identifier);
    }

    public ASTName(JavaParser parser, int identifier) {
        super(parser, identifier);
    }

    public void setNamePart(int ndx, String value) {
        this.name = null;
        int count = 0;
        for (int i = 0; i < this.children.length; ++i) {
            if (!(this.children[i] instanceof ASTIdentifier)) continue;
            if (count == ndx) {
                ((ASTIdentifier)this.children[i]).setName(value);
                return;
            }
            ++count;
        }
    }

    public void setImage(String image) {
        this.fromString(image);
    }

    public String getNamePart(int ndx) {
        int count = 0;
        for (int i = 0; i < this.children.length; ++i) {
            if (!(this.children[i] instanceof ASTIdentifier)) continue;
            if (count == ndx) {
                return ((ASTIdentifier)this.children[i]).getName();
            }
            ++count;
        }
        return null;
    }

    public String getName() {
        if (this.name == null) {
            if (this.children == null) {
                this.name = "";
                return this.name;
            }
            StringBuffer buf = new StringBuffer();
            boolean first = true;
            for (int i = 0; i < this.children.length; ++i) {
                if (!(this.children[i] instanceof ASTIdentifier)) continue;
                if (!first) {
                    buf.append(".");
                }
                buf.append(((ASTIdentifier)this.children[i]).getName());
                first = false;
            }
            this.name = buf.toString();
        }
        return this.name;
    }

    public int getNameSize() {
        int count = 0;
        for (int i = 0; i < this.children.length; ++i) {
            if (!(this.children[i] instanceof ASTIdentifier)) continue;
            ++count;
        }
        return count;
    }

    public void insertNamePart(int ndx, String value) {
        this.name = null;
        int count = 0;
        ASTIdentifier ident = new ASTIdentifier(this.parser, 20);
        ident.setName(value);
        for (int i = 0; i < this.children.length; ++i) {
            if (!(this.children[i] instanceof ASTIdentifier)) continue;
            if (count == ndx) {
                this.jjtInsertChild(ident, i);
                return;
            }
            ++count;
        }
        ident.setLineAndColumnInfo(this.getBeginLine(), this.getBeginColumn(), this.getEndLine(), this.getEndColumn());
    }

    public void addNamePart(String newName) {
        this.name = null;
        ASTIdentifier ident = new ASTIdentifier(this.parser, 20);
        ident.setName(newName);
        this.jjtAddChild(ident, this.children == null ? 0 : this.children.length);
    }

    public void fromString(String input) {
        this.name = null;
        this.children = null;
        StringTokenizer tok = new StringTokenizer(input, ".");
        while (tok.hasMoreTokens()) {
            String next = tok.nextToken();
            this.addNamePart(next);
        }
    }

    public boolean equals(Object other) {
        ASTName otherName;
        if (other == this) {
            return true;
        }
        if (other instanceof ASTName && (otherName = (ASTName)other).getNameSize() == this.getNameSize()) {
            return this.getName().equals(otherName.getName());
        }
        return false;
    }

    public int hashCode() {
        if (this.name == null) {
            this.name = this.getName();
        }
        return this.name.hashCode();
    }

    public boolean startsWith(ASTName otherName) {
        if (otherName.getNameSize() > this.getNameSize()) {
            return false;
        }
        int last = Math.min(otherName.getNameSize(), this.getNameSize());
        for (int ndx = 0; ndx < last; ++ndx) {
            if (this.getNamePart(ndx).equals(otherName.getNamePart(ndx))) continue;
            return false;
        }
        return true;
    }

    public ASTName changeStartingPart(ASTName oldBase, ASTName newBase) {
        int start;
        ASTName result = new ASTName();
        int last = newBase.getNameSize();
        for (int ndx = 0; ndx < last; ++ndx) {
            result.addNamePart(newBase.getNamePart(ndx));
        }
        int end = this.getNameSize();
        for (int ndx = start = oldBase.getNameSize(); ndx < end; ++ndx) {
            result.addNamePart(this.getNamePart(ndx));
        }
        result.setLineAndColumnInfo(this.getBeginLine(), this.getBeginColumn(), this.getEndLine(), this.getEndColumn());
        return result;
    }

    public Object jjtAccept(JavaParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }
}

