/*
 * Decompiled with CFR 0.152.
 */
package ceb.test;

import bluej.extensions.BClass;
import bluej.extensions.BPackage;
import ceb.manager.TestManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestListener;

public class TestRunner
extends JFrame
implements TestListener {
    private JButton btnStart;
    private JScrollPane scrollPane;
    private JTextArea txtError;
    private JProgressBar progressTest;
    private JLabel lblTitle;
    private JPanel panTest;
    private BPackage curPackage;

    public TestRunner(BPackage fPackage) {
        this.setTitle("CEB Test Suite");
        this.curPackage = fPackage;
        this.initComponents();
        this.setSize(200, 200);
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenDim.width - 200) / 2, (screenDim.height - 200) / 2);
        this.setVisible(true);
        this.addWindowListener(new WindowAdapter(){

            public void winodwClosing(WindowEvent e) {
                TestRunner.this.dispose();
            }
        });
    }

    private void initComponents() {
        this.panTest = new JPanel();
        this.progressTest = new JProgressBar();
        this.btnStart = new JButton();
        this.lblTitle = new JLabel();
        this.txtError = new JTextArea();
        this.scrollPane = new JScrollPane(this.txtError, 20, 30);
        this.txtError.setEditable(false);
        this.getContentPane().setLayout(new GridLayout(0, 1));
        this.panTest.setLayout(new BorderLayout());
        this.panTest.add((Component)this.progressTest, "Center");
        this.btnStart.setText("Start Tests");
        this.btnStart.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TestRunner.this.btnStartActionPerformed(evt);
            }
        });
        this.panTest.add((Component)this.btnStart, "South");
        this.lblTitle.setText("CEB Tests");
        this.panTest.add((Component)this.lblTitle, "North");
        this.getContentPane().add(this.panTest);
        this.getContentPane().add(this.scrollPane);
        this.pack();
    }

    private void btnStartActionPerformed(ActionEvent evt) {
        TestManager testManager = new TestManager(this.curPackage);
        this.txtError.setText("");
        this.progressTest.setMaximum(testManager.getTestCount());
        this.progressTest.setValue(0);
        this.progressTest.setForeground(Color.BLUE);
        if (testManager.testStart(this)) {
            this.lblTitle.setText("Test Complete");
        }
    }

    public void addError(Test test, Throwable t) {
        this.progressTest.setForeground(Color.RED);
        this.txtError.setText(String.valueOf(this.txtError.getText()) + "\nError : " + test.toString() + " : " + t.getMessage());
    }

    public void addFailure(Test test, AssertionFailedError assertError) {
        this.progressTest.setForeground(Color.RED);
        this.txtError.setText(String.valueOf(this.txtError.getText()) + "\nFailure : " + test.toString() + " : " + assertError.getMessage());
    }

    public void endTest(Test test) {
        this.progressTest.setValue(this.progressTest.getValue() + 1);
    }

    public void startTest(Test test) {
    }

    public void setClass(BClass bClass) {
        this.lblTitle.setText("Testing " + bClass.toString());
    }
}

