/*
 * Decompiled with CFR 0.152.
 */
package ceb.metrics;

import bluej.extensions.BClass;
import ceb.metrics.BasicMetrics;
import ceb.parser.ParsedClass;
import ceb.parser.ParsedMethod;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JOptionPane;

public class LCOMMetrics
extends BasicMetrics {
    public static final int USE_LCOM1 = 1;
    public static final int USE_LCOM2 = 2;
    public static final int USE_LCOM3 = 3;
    private int nLCOMType = 1;

    public LCOMMetrics(BClass fbcCurrent, ParsedClass fparsedClass) {
        super(fbcCurrent, fparsedClass);
    }

    public LCOMMetrics(BClass fbcCurrent, ParsedClass fparsedClass, int nType) {
        super(fbcCurrent, fparsedClass);
        this.nLCOMType = nType;
        this.nMetrics = this.eValueMetrics();
    }

    public int eValueMetrics() {
        int nRet = 0;
        switch (this.nLCOMType) {
            case 1: {
                nRet = this.eValueLCOM1();
                break;
            }
            case 2: {
                nRet = this.eValueLCOM2();
                break;
            }
            case 3: {
                nRet = this.eValueLCOM3();
            }
        }
        return nRet;
    }

    private int eValueLCOM1() {
        int P = 0;
        int Q = 0;
        int i = 0;
        int j = 0;
        HashSet a = null;
        HashSet b = null;
        Iterator iter = null;
        try {
            ParsedMethod[] arrMethods = this.parsedClass.getParsedMethods();
            i = 0;
            while (i < arrMethods.length) {
                a = arrMethods[i].getSetUseClassAttr();
                j = i + 1;
                while (j < arrMethods.length) {
                    b = arrMethods[j].getSetUseClassAttr();
                    iter = b.iterator();
                    while (iter.hasNext()) {
                        if (!a.contains((String)iter.next())) continue;
                        ++Q;
                        break;
                    }
                    if (!iter.hasNext()) {
                        ++P;
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "LCOMMetrics:eValueLCOM1 " + e.toString() + " " + e.getMessage());
        }
        return Q > P ? 0 : P - Q;
    }

    public int eValueLCOM2() {
        int nSum = 0;
        float fTemp = 0.0f;
        int nRet = 0;
        int i = 0;
        HashSet a = null;
        Object iter = null;
        try {
            ParsedMethod[] arrMethods = this.parsedClass.getParsedMethods();
            String[] arrAttr = this.parsedClass.getAttrs();
            if (arrMethods.length == 0 || arrAttr.length == 0) {
                return 0;
            }
            i = 0;
            while (i < arrMethods.length) {
                a = arrMethods[i].getSetUseClassAttr();
                nSum += a.size();
                ++i;
            }
            fTemp = 1.0f - (float)nSum / (float)(arrMethods.length * arrAttr.length);
            nRet = Math.round(fTemp * 10.0f);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "LCOMMetrics:eValueLCOM2 " + e.toString() + " " + e.getMessage());
        }
        return nRet;
    }

    public int eValueLCOM3() {
        int nSum = 0;
        float fTemp = 0.0f;
        int nRet = 0;
        int i = 0;
        HashSet a = null;
        Object iter = null;
        try {
            ParsedMethod[] arrMethods = this.parsedClass.getParsedMethods();
            String[] arrAttr = this.parsedClass.getAttrs();
            if (arrMethods.length == 1 || arrAttr.length == 0) {
                return 0;
            }
            i = 0;
            while (i < arrMethods.length) {
                a = arrMethods[i].getSetUseClassAttr();
                nSum += a.size();
                ++i;
            }
            fTemp = (float)arrMethods.length - (float)nSum / (float)arrAttr.length;
            nRet = Math.round((fTemp /= (float)(arrMethods.length - 1)) * 10.0f);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "LCOMMetrics:eValueLCOM3 " + e.toString() + " " + e.getMessage());
        }
        return nRet;
    }
}

