/*
 * Decompiled with CFR 0.152.
 */
package ceb.manager;

import bluej.extensions.BClass;
import bluej.extensions.BMethod;
import ceb.parser.JavaParser;
import ceb.parser.ParseException;
import ceb.parser.ParsedClass;
import java.io.FileInputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import javax.swing.JOptionPane;

public class ParseManager {
    private BClass bcClass = null;
    private ParsedClass pcClass = new ParsedClass();

    public ParseManager(BClass fbcClass) {
        this.bcClass = fbcClass;
        this.specifyClass();
        this.ParseClass();
    }

    public void ParseClass() {
        try {
            JavaParser parser = new JavaParser(new FileInputStream(this.bcClass.getJavaFile()));
            parser.setParsedClass(this.pcClass);
            parser.CompilationUnit();
        }
        catch (ParseException e) {
            JOptionPane.showMessageDialog(null, "ParsedManager:ParseClass " + e.getMessage());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "ParsedManager:ParseClass " + e.getMessage());
        }
    }

    public void specifyClass() {
        int i = 0;
        int nDepth = 0;
        BClass bcTemp = this.bcClass;
        HashSet<String> setMethod = new HashSet<String>();
        HashSet<String> setAttr = new HashSet<String>();
        Object clTemp = null;
        try {
            while (bcTemp != null) {
                BMethod[] arrMethod = bcTemp.getDeclaredMethods();
                i = 0;
                while (i < arrMethod.length) {
                    if (nDepth == 0 || !Modifier.isPrivate(arrMethod[i].getModifiers())) {
                        setMethod.add(arrMethod[i].getName());
                    }
                    ++i;
                }
                Field[] arrField = bcTemp.getJavaClass().getDeclaredFields();
                i = 0;
                while (i < arrField.length) {
                    if (nDepth == 0 || !Modifier.isPrivate(arrField[i].getModifiers())) {
                        setAttr.add(arrField[i].getName());
                    }
                    ++i;
                }
                bcTemp = bcTemp.getSuperclass();
                ++nDepth;
            }
            this.pcClass.setMethods(setMethod);
            this.pcClass.setAttrs(setAttr);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "ParsedManager:specifyClass " + e.getMessage());
        }
    }

    public ParsedClass getParsedClass() {
        return this.pcClass;
    }
}

