/*
 * Decompiled with CFR 0.152.
 */
package ceb.chart;

import ceb.chart.BasicChart;
import ceb.manager.MetricsManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class TextChartClass
extends BasicChart {
    private JPanel textChartPanel;
    private JPanel descriptionPanel;
    private JLabel lbDIT = new JLabel("DIT : ", 4);
    private JLabel lbNOC = new JLabel("NOC : ", 4);
    private JLabel lbWMC = new JLabel("WMC : ", 4);
    private JLabel lbRFC = new JLabel("RFC : ", 4);
    private JLabel lbCBO = new JLabel("CBO : ", 4);
    private JLabel lbLCOM = new JLabel("LCOM : ", 4);
    private JTextField tfDIT = new JTextField(5);
    private JTextField tfNOC = new JTextField(5);
    private JTextField tfWMC = new JTextField(5);
    private JTextField tfRFC = new JTextField(5);
    private JTextField tfCBO = new JTextField(5);
    private JTextField tfLCOM = new JTextField(5);
    private JLabel lbClassName = new JLabel("Class Name : ");
    private JTextArea taExtends = new JTextArea(5, 5);
    private JProgressBar progressDIT = new JProgressBar(0, 0, 10);
    private JProgressBar progressNOC = new JProgressBar(0, 0, 10);
    private JProgressBar progressWMC = new JProgressBar(0, 0, 10);
    private JProgressBar progressRFC = new JProgressBar(0, 0, 10);
    private JProgressBar progressCBO = new JProgressBar(0, 0, 10);
    private JProgressBar progressLCOM = new JProgressBar(0, 0, 10);

    public TextChartClass(MetricsManager fclassData) {
        this.classData = fclassData;
        this.setData();
        this.init();
    }

    public void setData() {
        this.tfDIT.setText(String.valueOf(this.classData.getMetrics("DIT")));
        this.tfNOC.setText(String.valueOf(this.classData.getMetrics("NOC")));
        this.tfWMC.setText(String.valueOf(this.classData.getMetrics("WMC")));
        this.tfRFC.setText(String.valueOf(this.classData.getMetrics("RFC")));
        this.tfCBO.setText(String.valueOf(this.classData.getMetrics("CBO")));
        this.tfLCOM.setText(String.valueOf(this.classData.getMetrics("LCOM")));
    }

    public void init() {
        if (this.getMetricsMaxValue() > 10) {
            this.progressDIT.setMaximum(this.getMetricsMaxValue());
            this.progressWMC.setMaximum(this.getMetricsMaxValue());
            this.progressNOC.setMaximum(this.getMetricsMaxValue());
            this.progressRFC.setMaximum(this.getMetricsMaxValue());
            this.progressCBO.setMaximum(this.getMetricsMaxValue());
            this.progressLCOM.setMaximum(this.getMetricsMaxValue());
        }
        this.textChartPanel = new JPanel(new BorderLayout());
        this.textChartPanel.setBorder(new TitledBorder("Class Name : " + this.classData.getClassName()));
        JLabel textChartName = new JLabel("TextChart", 0);
        Color color = textChartName.getBackground();
        textChartName.setFont(new Font("SansSerif", 1, 18));
        this.textChartPanel.add("North", textChartName);
        JPanel p2 = new JPanel(new GridLayout(6, 1));
        p2.add(this.lbNOC);
        this.lbNOC.setForeground(this.getColorNOC());
        p2.add(this.lbDIT);
        this.lbDIT.setForeground(this.getColorDIT());
        p2.add(this.lbLCOM);
        this.lbLCOM.setForeground(this.getColorLCOM());
        p2.add(this.lbWMC);
        this.lbWMC.setForeground(this.getColorWMC());
        p2.add(this.lbRFC);
        this.lbRFC.setForeground(this.getColorRFC());
        p2.add(this.lbCBO);
        this.lbCBO.setForeground(this.getColorCBO());
        this.textChartPanel.add("West", p2);
        JPanel p = new JPanel(new GridLayout(6, 1));
        JPanel nocPanel = new JPanel(new FlowLayout(0));
        this.progressNOC.setString(String.valueOf(this.classData.getMetrics("NOC")));
        this.progressNOC.setStringPainted(true);
        this.progressNOC.setValue(this.classData.getMetrics("NOC"));
        this.progressNOC.setPreferredSize(new Dimension(300, 20));
        nocPanel.add(this.progressNOC);
        p.add(nocPanel);
        JPanel ditPanel = new JPanel(new FlowLayout(0));
        this.progressDIT.setString(String.valueOf(this.classData.getMetrics("DIT")));
        this.progressDIT.setStringPainted(true);
        this.progressDIT.setValue(this.classData.getMetrics("DIT"));
        this.progressDIT.setPreferredSize(new Dimension(300, 20));
        ditPanel.add(this.progressDIT);
        p.add(ditPanel);
        JPanel lcomPanel = new JPanel(new FlowLayout(0));
        this.progressLCOM.setString(String.valueOf(this.classData.getMetrics("LCOM")));
        this.progressLCOM.setStringPainted(true);
        this.progressLCOM.setValue(this.classData.getMetrics("LCOM"));
        this.progressLCOM.setPreferredSize(new Dimension(300, 20));
        lcomPanel.add(this.progressLCOM);
        p.add(lcomPanel);
        JPanel wmcPanel = new JPanel(new FlowLayout(0));
        this.progressWMC.setString(String.valueOf(this.classData.getMetrics("WMC")));
        this.progressWMC.setStringPainted(true);
        this.progressWMC.setValue(this.classData.getMetrics("WMC"));
        this.progressWMC.setPreferredSize(new Dimension(300, 20));
        wmcPanel.add(this.progressWMC);
        p.add(wmcPanel);
        this.textChartPanel.add("Center", p);
        JPanel rfcPanel = new JPanel(new FlowLayout(0));
        this.progressRFC.setString(String.valueOf(this.classData.getMetrics("RFC")));
        this.progressRFC.setStringPainted(true);
        this.progressRFC.setValue(this.classData.getMetrics("RFC"));
        this.progressRFC.setPreferredSize(new Dimension(300, 20));
        rfcPanel.add(this.progressRFC);
        p.add(rfcPanel);
        this.textChartPanel.add("Center", p);
        JPanel cboPanel = new JPanel(new FlowLayout(0));
        this.progressCBO.setString(String.valueOf(this.classData.getMetrics("CBO")));
        this.progressCBO.setStringPainted(true);
        this.progressCBO.setValue(this.classData.getMetrics("CBO"));
        this.progressCBO.setPreferredSize(new Dimension(300, 20));
        cboPanel.add(this.progressCBO);
        p.add(cboPanel);
        this.textChartPanel.add("Center", p);
    }

    public JPanel getChartPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add("Center", this.textChartPanel);
        panel.add("South", super.getDescriptionWordPanel());
        return panel;
    }
}

