/*
 * Decompiled with CFR 0.152.
 */
package ceb.chart;

import java.awt.Color;
import java.awt.Graphics;
import java.util.Vector;
import javax.swing.JPanel;
import org.jfree.data.PieDataset;

public class RadarChartPanel
extends JPanel {
    private PieDataset dataset;
    private int nItemCount;
    private Color[] arrLabelColor;
    private String strName;
    private String strColor;
    private int[] x;
    private int[] y;
    private Vector vCoordX;
    private Vector vCoordY;
    private int[] arrPolygonX;
    private int[] arrPolygonY;
    private int nCenterX;
    private int nCenterY;
    private int nMaxData = 0;
    private int nHeight;
    private int nWidth;

    public RadarChartPanel(PieDataset data, Color[] arrLabelColor) {
        this.dataset = data;
        this.nItemCount = data.getItemCount();
        this.arrLabelColor = arrLabelColor;
    }

    private void calCoord() {
        this.nWidth = this.getWidth();
        this.nHeight = this.getHeight();
        this.vCoordX = new Vector();
        this.vCoordY = new Vector();
        double dDistanceX = 0.0;
        double dDistanceY = 0.0;
        double dLength = 0.0;
        this.nCenterX = this.getWidth() / 2;
        this.nCenterY = this.getHeight() / 2;
        this.x = new int[this.nItemCount];
        this.y = new int[this.nItemCount];
        this.arrPolygonX = new int[this.nItemCount];
        this.arrPolygonY = new int[this.nItemCount];
        dLength = this.getWidth() < this.getHeight() ? (double)(this.getWidth() / 2 - 15) : (double)(this.getHeight() / 2 - 15);
        int i = 0;
        while (i < this.nItemCount) {
            if (this.nMaxData < this.dataset.getValue(i).intValue()) {
                this.nMaxData = this.dataset.getValue(i).intValue();
            }
            ++i;
        }
        i = 1;
        while (i <= this.nItemCount) {
            double dItemWidth = Math.PI * 2 / (double)this.nItemCount;
            dDistanceX = (int)(dLength * Math.cos(1.5707963267948966 - (double)i * dItemWidth));
            dDistanceY = (int)(dLength * Math.sin(1.5707963267948966 - (double)i * dItemWidth));
            this.x[i - 1] = this.nCenterX + (int)dDistanceX;
            this.y[i - 1] = this.nCenterY - (int)dDistanceY;
            this.vCoordX.add(i - 1, new Double(dDistanceX));
            this.vCoordY.add(i - 1, new Double(dDistanceY));
            double[] arrTempX = new double[this.nItemCount];
            double[] arrTempY = new double[this.nItemCount];
            arrTempX[i - 1] = (double)this.nCenterX + dDistanceX / (double)this.nMaxData * (Double)this.dataset.getValue(i - 1);
            arrTempY[i - 1] = (double)this.nCenterY - dDistanceY / (double)this.nMaxData * (Double)this.dataset.getValue(i - 1);
            this.arrPolygonX[i - 1] = (int)arrTempX[i - 1];
            this.arrPolygonY[i - 1] = (int)arrTempY[i - 1];
            ++i;
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.calCoord();
        this.setBackground(new Color(255, 255, 255));
        g.setColor(Color.BLUE);
        g.fillPolygon(this.arrPolygonX, this.arrPolygonY, this.nItemCount);
        Color chartColor = new Color(0, 0, 0);
        g.setColor(chartColor);
        g.drawPolygon(this.arrPolygonX, this.arrPolygonY, this.nItemCount);
        int i = 0;
        while (i < this.nItemCount) {
            chartColor = new Color(0, 0, 0);
            g.setColor(chartColor);
            g.drawLine(this.nCenterX, this.nCenterY, this.x[i], this.y[i]);
            ++i;
        }
        int j = 0;
        while (j < this.nItemCount) {
            int nNextJ = j + 1 == this.nItemCount ? 0 : j + 1;
            int i2 = 0;
            while (i2 <= 5) {
                double x1 = (double)this.nCenterX + ((Double)this.vCoordX.get(j) - (Double)this.vCoordX.get(j) / 100.0 * (double)(i2 * 20));
                double y1 = (double)this.nCenterY - ((Double)this.vCoordY.get(j) - (Double)this.vCoordY.get(j) / 100.0 * (double)(i2 * 20));
                double x2 = (double)this.nCenterX + ((Double)this.vCoordX.get(nNextJ) - (Double)this.vCoordX.get(nNextJ) / 100.0 * (double)(i2 * 20));
                double y2 = (double)this.nCenterY - ((Double)this.vCoordY.get(nNextJ) - (Double)this.vCoordY.get(nNextJ) / 100.0 * (double)(i2 * 20));
                chartColor = new Color(64, 128, 128);
                g.setColor(chartColor);
                g.drawLine((int)x1, (int)y1, (int)x2, (int)y2);
                g.setColor(this.arrLabelColor[j]);
                if (i2 == 0) {
                    String elementtext = String.valueOf(this.dataset.getKey(j).toString()) + "(" + this.dataset.getValue(j).intValue() + ")";
                    int nFontWidth = g.getFontMetrics().stringWidth(elementtext) + 5;
                    if (x1 < (double)this.nCenterX) {
                        if (y1 > (double)this.nCenterY) {
                            g.drawString(elementtext, (int)x1 - nFontWidth, (int)y1 + 10);
                        } else {
                            g.drawString(elementtext, (int)x1 - nFontWidth, (int)y1 - 5);
                        }
                    } else if (y1 > (double)this.nCenterY) {
                        g.drawString(elementtext, (int)x1, (int)y1 + 10);
                    } else {
                        g.drawString(elementtext, (int)x1, (int)y1 - 5);
                    }
                }
                ++i2;
            }
            ++j;
        }
    }
}

