/*
 * Decompiled with CFR 0.152.
 */
package ceb.chart;

import ceb.chart.BasicChart;
import ceb.chart.RadarChartPanel;
import ceb.manager.MetricsManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.jfree.data.DefaultPieDataset;

public class RadarChartClass
extends BasicChart {
    private DefaultPieDataset dataset = new DefaultPieDataset();
    private JPanel chartPanel;

    public RadarChartClass(MetricsManager fclassData) {
        this.classData = fclassData;
        this.setData();
        this.init();
    }

    public JPanel getChartPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(new TitledBorder("Class Name : " + this.classData.getClassName()));
        panel.add("Center", this.chartPanel);
        panel.add("South", super.getDescriptionWordPanel());
        return panel;
    }

    public void setData() {
        this.dataset.setValue((Comparable)((Object)"DIT"), this.classData.getMetrics("DIT"));
        this.dataset.setValue((Comparable)((Object)"LCOM"), this.classData.getMetrics("LCOM"));
        this.dataset.setValue((Comparable)((Object)"WMC"), this.classData.getMetrics("WMC"));
        this.dataset.setValue((Comparable)((Object)"RFC"), this.classData.getMetrics("RFC"));
        this.dataset.setValue((Comparable)((Object)"CBO"), this.classData.getMetrics("CBO"));
        this.dataset.setValue((Comparable)((Object)"NOC"), this.classData.getMetrics("NOC"));
    }

    public void init() {
        this.chartPanel = new JPanel(new BorderLayout());
        this.chartPanel.setBackground(super.getDescriptionWordPanel().getBackground());
        JLabel lblName = new JLabel("RadarChart", 0);
        lblName.setFont(new Font("SansSerif", 1, 18));
        this.chartPanel.add("North", lblName);
        Color[] arrTxtColor = new Color[this.dataset.getItemCount()];
        arrTxtColor[0] = this.getColorDIT();
        arrTxtColor[1] = this.getColorLCOM();
        arrTxtColor[2] = this.getColorWMC();
        arrTxtColor[3] = this.getColorRFC();
        arrTxtColor[4] = this.getColorCBO();
        arrTxtColor[5] = this.getColorNOC();
        RadarChartPanel radarChartPanel = new RadarChartPanel(this.dataset, arrTxtColor);
        this.chartPanel.add(radarChartPanel);
        this.chartPanel.setPreferredSize(new Dimension(300, 200));
    }
}

