/*
 * Decompiled with CFR 0.152.
 */
package ceb.chart;

import ceb.manager.MetricsManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public abstract class BasicChart {
    private JLabel labelDIT = new JLabel("DIT : Depth Inheritance Tree ");
    private JLabel labelNOC = new JLabel("NOC : Number Of Children");
    private JLabel labelWMC = new JLabel("WMC : Weighted Methods per Class");
    private JLabel labelRFC = new JLabel("RFC : Response For a Class");
    private JLabel labelCBO = new JLabel("CBO : Coupling Between Objects");
    private JLabel labelLCOM = new JLabel("LCOM : Lack of Cohesion in Methods");
    private JLabel labelDIT_Sub_Left = new JLabel("Lower : Good  ", 2);
    private JLabel labelNOC_Sub_Left = new JLabel("Lower : Bad   ", 2);
    private JLabel labelWMC_Sub_Left = new JLabel("Lower : Good  ", 2);
    private JLabel labelRFC_Sub_Left = new JLabel("Lower : Good  ", 2);
    private JLabel labelCBO_Sub_Left = new JLabel("Lower : Good  ", 2);
    private JLabel labelLCOM_Sub_Left = new JLabel("Lower : Good  ", 2);
    private JLabel labelDIT_Sub_right = new JLabel("Higher : Bad", 2);
    private JLabel labelNOC_Sub_right = new JLabel("Higher : Good", 2);
    private JLabel labelWMC_Sub_right = new JLabel("Higher : Bad", 2);
    private JLabel labelRFC_Sub_right = new JLabel("Higher : Bad", 2);
    private JLabel labelCBO_Sub_right = new JLabel("Higher : Bad", 2);
    private JLabel labelLCOM_Sub_right = new JLabel("Higher : Bad", 2);
    protected MetricsManager classData;

    public abstract JPanel getChartPanel();

    public abstract void setData();

    public abstract void init();

    public JPanel getDescriptionWordPanel() {
        this.labelDIT.setForeground(this.getColorDIT());
        this.labelNOC.setForeground(this.getColorNOC());
        this.labelWMC.setForeground(this.getColorWMC());
        this.labelRFC.setForeground(this.getColorRFC());
        this.labelCBO.setForeground(this.getColorCBO());
        this.labelLCOM.setForeground(this.getColorLCOM());
        JPanel descriptionPanel = new JPanel(new BorderLayout());
        descriptionPanel.setBorder(new TitledBorder("Descriptions"));
        JPanel p = new JPanel(new GridLayout(6, 1));
        p.add(this.labelNOC);
        p.add(this.labelDIT);
        p.add(this.labelLCOM);
        p.add(this.labelWMC);
        p.add(this.labelRFC);
        p.add(this.labelCBO);
        descriptionPanel.add("Center", p);
        JPanel p1 = new JPanel(new GridLayout(6, 1, -8, -8));
        JPanel p11 = new JPanel(new FlowLayout(0));
        p11.add(new JLabel("("));
        p11.add(this.labelNOC_Sub_Left);
        p11.add(new JLabel(";"));
        p11.add(this.labelNOC_Sub_right);
        p11.add(new JLabel(")"));
        JPanel p12 = new JPanel(new FlowLayout(0));
        p12.add(new JLabel("("));
        p12.add(this.labelDIT_Sub_Left);
        p12.add(new JLabel(";"));
        p12.add(this.labelDIT_Sub_right);
        p12.add(new JLabel(")"));
        JPanel p13 = new JPanel(new FlowLayout(0));
        p13.add(new JLabel("("));
        p13.add(this.labelLCOM_Sub_Left);
        p13.add(new JLabel(";"));
        p13.add(this.labelLCOM_Sub_right);
        p13.add(new JLabel(")"));
        JPanel p14 = new JPanel(new FlowLayout(0));
        p14.add(new JLabel("("));
        p14.add(this.labelWMC_Sub_Left);
        p14.add(new JLabel(";"));
        p14.add(this.labelWMC_Sub_right);
        p14.add(new JLabel(")"));
        JPanel p15 = new JPanel(new FlowLayout(0));
        p15.add(new JLabel("("));
        p15.add(this.labelRFC_Sub_Left);
        p15.add(new JLabel(";"));
        p15.add(this.labelRFC_Sub_right);
        p15.add(new JLabel(")"));
        JPanel p16 = new JPanel(new FlowLayout(0));
        p16.add(new JLabel("("));
        p16.add(this.labelCBO_Sub_Left);
        p16.add(new JLabel(";"));
        p16.add(this.labelCBO_Sub_right);
        p16.add(new JLabel(")"));
        this.labelDIT_Sub_Left.setForeground(Color.BLUE);
        this.labelDIT_Sub_right.setForeground(Color.red);
        this.labelNOC_Sub_Left.setForeground(Color.red);
        this.labelNOC_Sub_right.setForeground(Color.blue);
        this.labelWMC_Sub_Left.setForeground(Color.BLUE);
        this.labelWMC_Sub_right.setForeground(Color.red);
        this.labelRFC_Sub_Left.setForeground(Color.BLUE);
        this.labelRFC_Sub_right.setForeground(Color.red);
        this.labelCBO_Sub_Left.setForeground(Color.BLUE);
        this.labelCBO_Sub_right.setForeground(Color.red);
        this.labelLCOM_Sub_Left.setForeground(Color.BLUE);
        this.labelLCOM_Sub_right.setForeground(Color.red);
        p1.add(p11);
        p1.add(p12);
        p1.add(p13);
        p1.add(p14);
        p1.add(p15);
        p1.add(p16);
        descriptionPanel.add("East", p1);
        return descriptionPanel;
    }

    public Color getColorDIT() {
        Color color = Color.RED;
        return color;
    }

    public Color getColorNOC() {
        Color color = Color.BLUE;
        return color;
    }

    public Color getColorWMC() {
        Color color = new Color(29, 153, 167);
        return color;
    }

    public Color getColorRFC() {
        Color color = new Color(101, 78, 37);
        return color;
    }

    public Color getColorCBO() {
        Color color = new Color(48, 139, 62);
        return color;
    }

    public Color getColorLCOM() {
        Color color = new Color(80, 64, 172);
        return color;
    }

    public int getMetricsMaxValue() {
        int[] num = new int[]{this.classData.getMetrics("DIT"), this.classData.getMetrics("WMC"), this.classData.getMetrics("CBO"), this.classData.getMetrics("NOC"), this.classData.getMetrics("RFC"), this.classData.getMetrics("LCOM")};
        int maxValue = num[0];
        int i = 1;
        while (i < num.length) {
            if (maxValue < num[i]) {
                maxValue = num[i];
            }
            ++i;
        }
        return maxValue + 2;
    }
}

