/*
 * Decompiled with CFR 0.152.
 */
package ceb.chart;

import bluej.extensions.BClass;
import ceb.chart.BasicChart;
import ceb.manager.MetricsManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.BarRenderer;
import org.jfree.data.CategoryDataset;
import org.jfree.data.DefaultCategoryDataset;

public class BarChartClass
extends BasicChart {
    private JFreeChart chart;
    private ChartPanel chartPanel;
    private BClass curClass;
    private DefaultCategoryDataset dataset = new DefaultCategoryDataset();
    private JPanel descriptionPanel;
    private Color color;

    public BarChartClass(MetricsManager fclassData) {
        this.classData = fclassData;
        this.setData();
        this.init();
    }

    public void init() {
        this.chart = this.createChart(this.dataset);
        this.chartPanel = new ChartPanel(this.chart);
        this.chartPanel.setPreferredSize(new Dimension(300, 200));
    }

    public JPanel getChartPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(new TitledBorder("Class Name : " + this.classData.getClassName()));
        panel.add("Center", this.chartPanel);
        this.descriptionPanel = super.getDescriptionWordPanel();
        panel.add("South", this.descriptionPanel);
        return panel;
    }

    public JFreeChart createChart(CategoryDataset dataset) {
        JFreeChart chart = ChartFactory.createBarChart("BarChart", "Metrics", "Value", dataset, PlotOrientation.VERTICAL, false, false, false);
        chart.setBackgroundPaint(super.getDescriptionWordPanel().getBackground());
        CategoryPlot plot = chart.getCategoryPlot();
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        if (this.getMetricsMaxValue() > 10) {
            rangeAxis.setUpperBound(this.getMetricsMaxValue());
        } else {
            rangeAxis.setUpperBound(10.0);
        }
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        BarRenderer renderer = (BarRenderer)plot.getRenderer();
        renderer.setDrawBarOutline(true);
        GradientPaint gp0 = new GradientPaint(0.0f, 0.0f, this.getColorNOC(), 0.0f, 0.0f, this.getColorNOC());
        GradientPaint gp1 = new GradientPaint(0.0f, 0.0f, this.getColorDIT(), 0.0f, 0.0f, this.getColorDIT());
        GradientPaint gp2 = new GradientPaint(0.0f, 0.0f, this.getColorLCOM(), 0.0f, 0.0f, this.getColorLCOM());
        GradientPaint gp3 = new GradientPaint(0.0f, 0.0f, this.getColorWMC(), 0.0f, 0.0f, this.getColorWMC());
        GradientPaint gp4 = new GradientPaint(0.0f, 0.0f, this.getColorRFC(), 0.0f, 0.0f, this.getColorRFC());
        GradientPaint gp5 = new GradientPaint(0.0f, 0.0f, this.getColorCBO(), 0.0f, 0.0f, this.getColorCBO());
        renderer.setSeriesPaint(0, gp0);
        renderer.setSeriesPaint(1, gp1);
        renderer.setSeriesPaint(2, gp2);
        renderer.setSeriesPaint(3, gp3);
        renderer.setSeriesPaint(4, gp4);
        renderer.setSeriesPaint(5, gp5);
        CategoryAxis domainAxis = plot.getDomainAxis();
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.STANDARD);
        domainAxis.setMaxCategoryLabelWidthRatio(20.0f);
        return chart;
    }

    public void setData() {
        String domainNameNOC = "NOC(" + this.classData.getMetrics("NOC") + ")";
        String domainNameDIT = "DIT(" + this.classData.getMetrics("DIT") + ")";
        String domainNameLCOM = "LCOM(" + this.classData.getMetrics("LCOM") + ")";
        String domainNameWMC = "WMC(" + this.classData.getMetrics("WMC") + ")";
        String domainNameRFC = "RFC(" + this.classData.getMetrics("RFC") + ")";
        String domainNameCBO = "CBO(" + this.classData.getMetrics("CBO") + ")";
        this.dataset.addValue(this.classData.getMetrics("NOC"), (Comparable)((Object)"1"), (Comparable)((Object)domainNameNOC));
        this.dataset.addValue(this.classData.getMetrics("DIT"), (Comparable)((Object)"2"), (Comparable)((Object)domainNameDIT));
        this.dataset.addValue(this.classData.getMetrics("LCOM"), (Comparable)((Object)"3"), (Comparable)((Object)domainNameLCOM));
        this.dataset.addValue(this.classData.getMetrics("WMC"), (Comparable)((Object)"4"), (Comparable)((Object)domainNameWMC));
        this.dataset.addValue(this.classData.getMetrics("RFC"), (Comparable)((Object)"5"), (Comparable)((Object)domainNameRFC));
        this.dataset.addValue(this.classData.getMetrics("CBO"), (Comparable)((Object)"6"), (Comparable)((Object)domainNameCBO));
    }
}

