/*
 * Decompiled with CFR 0.152.
 */
package ceb;

import bluej.extensions.BClass;
import ceb.chart.BarChartClass;
import ceb.chart.RadarChartClass;
import ceb.chart.TextChartClass;
import ceb.manager.MetricsManager;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class ChartPanel
extends JPanel {
    private BClass curClass;
    public MetricsManager dataClass;
    private BarChartClass barChartClass;
    private RadarChartClass radarChartClass;
    private TextChartClass textChartClass;
    private JTabbedPane tabPane = new JTabbedPane();

    public ChartPanel(BClass bc, int defaultLCOM) {
        this.curClass = bc;
        this.dataClass = new MetricsManager(this.curClass);
        this.dataClass = new MetricsManager(this.curClass);
        this.dataClass.setNLCOMType(defaultLCOM);
        this.dataClass.eValueMetrics();
        this.makeUI();
    }

    public void freshLCOM(int nLcom) {
        this.tabPane.removeAll();
        this.dataClass.setNLCOMType(nLcom);
        this.dataClass.eValueMetrics();
        this.makeUI();
    }

    public void makeUI() {
        this.barChartClass = new BarChartClass(this.dataClass);
        JPanel barPanel = this.barChartClass.getChartPanel();
        this.tabPane.addTab("BarChart", barPanel);
        this.radarChartClass = new RadarChartClass(this.dataClass);
        JPanel radarPanel = this.radarChartClass.getChartPanel();
        this.tabPane.addTab("RadarChart", radarPanel);
        this.textChartClass = new TextChartClass(this.dataClass);
        JPanel textPanel = this.textChartClass.getChartPanel();
        this.tabPane.addTab("TextChart", textPanel);
        this.tabPane.setTabPlacement(3);
        this.add(this.tabPane);
    }
}

