/*
 * Decompiled with CFR 0.152.
 */
package ceb;

import bluej.extensions.BClass;
import ceb.ChartFrameInterface;
import ceb.ChartPanel;
import ceb.CommonMenu;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileOutputStream;
import java.io.PrintStream;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;

public class ChartFrame
extends JFrame
implements ChartFrameInterface {
    private int ditValue = 0;
    private int nocValue = 0;
    private int wmcValue = 0;
    private JRootPane tabJRootPane;
    private Container tabContainer;
    private int defaultLCOM = 2;
    public ChartPanel panel = null;

    public ChartFrame(BClass bc) {
        this.setTitle("Evaluate CK Metrics");
        this.panel = new ChartPanel(bc, this.defaultLCOM);
        this.addChart();
        this.addMenu();
        this.setSize(450, 470);
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenDim.width - 400) / 2, (screenDim.height - 400) / 2);
        this.setVisible(true);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void winodwClosing(WindowEvent e) {
                ChartFrame.this.dispose();
            }
        });
    }

    public void addMenu() {
        CommonMenu menuBar = new CommonMenu(this);
        this.setJMenuBar(menuBar);
    }

    public void addChart() {
        this.tabJRootPane = this.getRootPane();
        this.tabContainer = this.tabJRootPane.getContentPane();
        this.tabContainer.add(this.panel);
    }

    public void saveFile() {
        FileDialog d = new FileDialog((Frame)this, "Save " + this.panel.dataClass.getClassName(), 1);
        d.setDirectory(".");
        d.setFile(String.valueOf(this.panel.dataClass.getClassName()) + ".csv");
        d.show();
        if (d.getFile() == null) {
            return;
        }
        try {
            PrintStream out = new PrintStream(new FileOutputStream(String.valueOf(d.getDirectory()) + d.getFile()));
            out.println("Class," + this.panel.dataClass.getClassName());
            out.println("DIT," + this.panel.dataClass.getMetrics("DIT"));
            out.println("NOC," + this.panel.dataClass.getMetrics("NOC"));
            out.println("WMC," + this.panel.dataClass.getMetrics("WMC"));
            out.println("RFC," + this.panel.dataClass.getMetrics("RFC"));
            out.println("CBO," + this.panel.dataClass.getMetrics("CBO"));
            out.println("LCOM," + this.panel.dataClass.getMetrics("LCOM"));
            out.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage());
        }
    }

    public void closeFrame() {
        this.dispose();
    }

    public void setLCOM(int nLCOM) {
        this.defaultLCOM = nLCOM;
        this.panel.freshLCOM(nLCOM);
    }

    public ChartPanel getPanel() {
        return this.panel;
    }
}

