/*
 * Decompiled with CFR 0.152.
 */
package ceb;

import bluej.extensions.BClass;
import bluej.extensions.BPackage;
import ceb.ChartFrameInterface;
import ceb.ChartPanel;
import ceb.CommonMenu;
import ceb.MetricsPanel;
import ceb.TreeClass;
import ceb.manager.MetricsManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;

public class AllChartFrame
extends JFrame
implements ChartFrameInterface {
    private JPanel treePanel = null;
    private JTree tree = null;
    private JSplitPane split = null;
    public ChartPanel panel = null;
    private int defaultLCOM = 2;
    private BPackage pkgLocal = null;

    public AllChartFrame(BPackage bPackage) {
        try {
            this.pkgLocal = bPackage;
            BClass[] temp = bPackage.getClasses();
            Vector<TreeClass> vecClass = new Vector<TreeClass>();
            String pkgName = this.pkgLocal.getProject().getName();
            int i = 0;
            while (i < temp.length) {
                vecClass.add(new TreeClass(temp[i], pkgName));
                ++i;
            }
            this.tree = new JTree(vecClass.toArray());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage());
        }
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)AllChartFrame.this.tree.getLastSelectedPathComponent();
                if (node == null) {
                    return;
                }
                TreeClass nodeInfo = (TreeClass)node.getUserObject();
                AllChartFrame.this.panel = new ChartPanel(nodeInfo.getObject(), AllChartFrame.this.defaultLCOM);
                AllChartFrame.this.split.setRightComponent(AllChartFrame.this.panel);
                AllChartFrame.this.split.setDividerLocation(200);
            }
        });
        this.makeTree(this.tree);
        this.getContentPane().add(this.treePanel);
        this.setJMenuBar(new CommonMenu(this));
        this.pack();
        this.setVisible(true);
        try {
            this.setTitle(bPackage.getProject().getName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void closeFrame() {
        this.dispose();
    }

    public void setLCOM(int nLCOM) {
        this.defaultLCOM = nLCOM;
        this.panel.freshLCOM(nLCOM);
    }

    public ChartPanel getPanel() {
        return this.panel;
    }

    public void saveFile() {
        try {
            MetricsManager dataClass = null;
            FileDialog d = new FileDialog((Frame)this, "Save " + this.pkgLocal.getProject().getName(), 1);
            d.setDirectory(".");
            d.setFile(String.valueOf(this.pkgLocal.getProject().getName()) + ".csv");
            d.show();
            if (d.getFile() == null) {
                return;
            }
            PrintStream out = new PrintStream(new FileOutputStream(String.valueOf(d.getDirectory()) + d.getFile()));
            BClass[] arrClass = this.pkgLocal.getClasses();
            out.println("Class,DIT,NOC,WMC,RFC,CBO,LCOM" + this.defaultLCOM);
            int i = 0;
            while (i < arrClass.length) {
                dataClass = new MetricsManager(arrClass[i]);
                dataClass.setNLCOMType(this.defaultLCOM);
                dataClass.eValueMetrics();
                out.println(String.valueOf(dataClass.getClassName()) + "," + dataClass.getMetrics("DIT") + "," + dataClass.getMetrics("NOC") + "," + dataClass.getMetrics("WMC") + "," + dataClass.getMetrics("RFC") + "," + dataClass.getMetrics("CBO") + "," + dataClass.getMetrics("LCOM"));
                ++i;
            }
            out.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage());
        }
    }

    public void makeTree(JTree tree) {
        this.treePanel = new JPanel();
        this.treePanel.setLayout(new BorderLayout());
        this.split = new JSplitPane();
        this.split.setLeftComponent(new JScrollPane(tree));
        this.split.setRightComponent(new MetricsPanel(new BorderLayout()));
        this.split.setOrientation(1);
        this.split.setOneTouchExpandable(true);
        this.split.setDividerLocation(200);
        this.split.setDividerSize(2);
        this.split.setPreferredSize(new Dimension(650, 450));
        this.treePanel.add((Component)this.split, "Center");
    }
}

