/*
 This file is part of the BlueJ program. 
 Copyright (C) 1999-2009,2016  Michael Kolling and John Rosenberg 
 
 This program is free software; you can redistribute it and/or 
 modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation; either version 2 
 of the License, or (at your option) any later version. 
 
 This program is distributed in the hope that it will be useful, 
 but WITHOUT ANY WARRANTY; without even the implied warranty of 
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 GNU General Public License for more details. 
 
 You should have received a copy of the GNU General Public License 
 along with this program; if not, write to the Free Software 
 Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA. 
 
 This file is subject to the Classpath exception as provided in the  
 LICENSE.txt file that accompanied this code.
 */
package bluej.groupwork.actions;

import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.Project;
import bluej.pkgmgr.actions.PkgMgrAction;


/**
 * Action to show teamwork settings dialog
 * 
 * @version $Id$
 */
public class TeamSettingsAction extends PkgMgrAction
{
    /** Creates a new instance of TeamSettingsAction */
    public TeamSettingsAction(PkgMgrFrame pmf)
    {
        super(pmf, "team.settings");
    }

    public void actionPerformed(PkgMgrFrame pmf)
    {
        Project project = pmf.getProject();
        project.getTeamSettingsDialog().doTeamSettings();
    }
}
