/*
 * Decompiled with CFR 0.152.
 */
package org.bluej.extensions.submitter;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;
import org.bluej.extensions.submitter.Stat;
import org.bluej.utility.Utility;

public class ResultDialog
implements ActionListener {
    private Stat stat;
    private JButton okButton;
    private JDialog thisDialog;
    private JEditorPane resultArea;

    public ResultDialog(Stat i_stat, Frame parentFrame) {
        this.stat = i_stat;
        this.resultArea = new JEditorPane();
        HTMLEditorKit edKit = new HTMLEditorKit();
        this.resultArea.setEditorKit(edKit);
        this.resultArea.setEditable(false);
        this.resultArea.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && !Utility.openWebBrowser(((ResultDialog)ResultDialog.this).stat.bluej, e.getURL())) {
                    ((ResultDialog)ResultDialog.this).stat.submitDialog.statusWriteln("Can't open external browser");
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.resultArea);
        Dimension dimension = new Dimension(300, 250);
        scrollPane.setMaximumSize(dimension);
        scrollPane.setPreferredSize(dimension);
        JPanel buttonPanel = new JPanel();
        this.okButton = new JButton(this.stat.bluej.getLabel("okay"));
        this.okButton.addActionListener(this);
        buttonPanel.add(this.okButton);
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)scrollPane, "Center");
        mainPanel.add((Component)buttonPanel, "South");
        this.thisDialog = new JDialog(parentFrame, this.stat.bluej.getLabel("title.results"));
        this.thisDialog.setContentPane(mainPanel);
        this.thisDialog.pack();
        this.thisDialog.setLocation(100, 100);
    }

    void showResult(String result) {
        if (result == null) {
            return;
        }
        this.resultArea.setText(result);
        if (result.length() > 0) {
            this.thisDialog.setVisible(true);
        }
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        this.thisDialog.dispose();
    }
}

