/*
 * Decompiled with CFR 0.152.
 */
package bluej;

import bluej.BlueJLabel;
import bluej.GreenfootLabel;
import bluej.SplashLabel;
import bluej.SplashWindow;
import com.sun.glass.ui.Application;
import java.awt.EventQueue;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javafx.application.Platform;
import javafx.stage.Stage;
import threadchecker.OnThread;
import threadchecker.Tag;

public class Boot {
    public static final int BLUEJ_VERSION_MAJOR = 4;
    public static final int BLUEJ_VERSION_MINOR = 0;
    public static final int BLUEJ_VERSION_RELEASE = 0;
    public static final String BLUEJ_VERSION_SUFFIX = "preview2";
    public static final String BLUEJ_VERSION = "4.0.0preview2";
    public static final String BLUEJ_VERSION_TITLE = "BlueJ 4.0.0preview2";
    private static final int bluejBuildJars = 3;
    private static final String[] bluejUserJars = new String[]{"bluejcore.jar", "junit-4.11.jar", "hamcrest-core-1.3.jar", "lang-stride.jar"};
    private static final int bluejUserBuildJars = 1;
    private static final String JLAYER_MP3_JAR = "jl1.0.1.jar";
    public static final String[] GREENFOOT_EXPORT_JARS = new String[]{"jl1.0.1.jar", "lang-stride.jar"};
    private static final String[] greenfootUserJars = new String[]{"extensions" + File.separatorChar + "greenfoot.jar", "bluejcore.jar", "bluejeditor.jar", "bluejext.jar", "AppleJavaExtensions.jar", "junit-4.11.jar", "hamcrest-core-1.3.jar", "bluej.jar", "diffutils-1.2.1.jar", "commons-httpclient-3.1.jar", "commons-logging-api-1.1.2.jar", "commons-codec-1.3.jar", "jl1.0.1.jar", "opencsv-2.3.jar", "xom-1.2.9.jar", "lang-stride.jar", "guava-17.0.jar", "javassist-3.18.0.jar", "commons-vfs2-2.0.jar", "httpclient-4.1.1.jar", "httpcore-4.1.jar", "httpmime-4.1.1.jar"};
    private static final int greenfootUserBuildJars = 4;
    public static String GREENFOOT_VERSION = "3.0.3";
    public static String GREENFOOT_API_VERSION = "2.8.0";
    private static Boot instance;
    private static final String[] bluejJars;
    private static String[] runtimeJars;
    private static String[] userJars;
    private static int numBuildJars;
    private static int numUserBuildJars;
    private static String jfxrtJar;
    private static boolean isGreenfoot;
    private static File bluejLibDir;
    private static final ArrayList<File> macInitialProjects;
    private SplashWindow splashWindow;
    public static String[] cmdLineArgs;
    private final Properties commandLineProps;
    private File javaHomeDir;
    private ClassLoader bootLoader;
    private URL[] runtimeUserClassPath;
    private URL[] runtimeClassPath;
    private Runnable quitAction;

    private Boot(Properties properties, SwingSupplier<SplashLabel> swingSupplier) {
        try {
            EventQueue.invokeAndWait(() -> {
                this.splashWindow = new SplashWindow((SplashLabel)swingSupplier.get());
            });
        }
        catch (InterruptedException | InvocationTargetException exception) {
            exception.printStackTrace();
        }
        this.commandLineProps = properties;
    }

    public static void main(String[] stringArray) {
        cmdLineArgs = stringArray;
        javafx.application.Application.launch(App.class, (String[])stringArray);
    }

    public static List<File> getMacInitialProjects() {
        return macInitialProjects;
    }

    @OnThread(value=Tag.Any)
    public static void subMain() {
        SwingSupplier<SplashLabel> swingSupplier;
        Properties properties = Boot.processCommandLineProperties(cmdLineArgs);
        isGreenfoot = properties.getProperty("greenfoot", "false").equals("true");
        if (isGreenfoot) {
            swingSupplier = GreenfootLabel::new;
            runtimeJars = greenfootUserJars;
            userJars = greenfootUserJars;
            numBuildJars = 4;
            numUserBuildJars = 4;
        } else {
            swingSupplier = BlueJLabel::new;
        }
        jfxrtJar = properties.getProperty("jfxrt.jarpath");
        try {
            instance = new Boot(properties, swingSupplier);
            instance.bootBluej();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.exit(1);
        }
        Boot boot = instance;
        synchronized (boot) {
            while (true) {
                try {
                    while (true) {
                        instance.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    public static Boot getInstance() {
        return instance;
    }

    public static File getBluejLibDir() {
        if (bluejLibDir == null) {
            bluejLibDir = Boot.calculateBluejLibDir();
        }
        return bluejLibDir;
    }

    private static File calculateBluejLibDir() {
        File file = null;
        String string = Boot.class.getResource("Boot.class").toString();
        try {
            if (!string.startsWith("jar:")) {
                File file2;
                for (file2 = new File(new URI(string)).getParentFile(); file2 != null && !new File(file2.getParentFile(), "lib").isDirectory(); file2 = file2.getParentFile()) {
                }
                file = file2 == null ? null : new File(file2.getParentFile(), "lib");
            } else {
                int n = string.indexOf("!");
                String string2 = string.substring(4, n);
                File file3 = new File(new URI(string2));
                file = file3.getParentFile();
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return file;
    }

    public static URL getJREJar(String string) throws MalformedURLException {
        String string2 = System.getProperty("java.home");
        if (string2 != null) {
            File file = new File(string2);
            if (file.canRead()) {
                File file2 = new File(file, "lib/" + string);
                if (file2.canRead()) {
                    return file2.toURI().toURL();
                }
                System.err.println("Could not find " + string + " at: " + file2.getAbsolutePath());
            } else {
                System.err.println("Could not find JRE at: " + file.getAbsolutePath());
            }
        } else {
            System.err.println("Could not find Java path");
        }
        return null;
    }

    private static Properties processCommandLineProperties(String[] stringArray) {
        Properties properties = new Properties();
        for (String string : stringArray) {
            String string2;
            int n;
            if (!string.startsWith("-") || (n = (string2 = string.substring(1)).indexOf(61)) < 0) continue;
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1);
            if (string3.equals("") || string4.equals("")) continue;
            properties.put(string3, string4);
        }
        return properties;
    }

    public static boolean isTrialRecording() {
        return false;
    }

    public void disposeSplashWindow() {
        if (this.splashWindow != null) {
            this.splashWindow.dispose();
            this.splashWindow = null;
        }
    }

    public boolean isGreenfoot() {
        return isGreenfoot;
    }

    public File getJavaHome() {
        return this.javaHomeDir;
    }

    public URL[] getRuntimeClassPath() {
        return this.runtimeClassPath;
    }

    public URL[] getRuntimeUserClassPath() {
        return this.runtimeUserClassPath;
    }

    public ClassLoader getBootClassLoader() {
        return this.bootLoader;
    }

    @OnThread(value=Tag.Any)
    private void bootBluej() {
        this.initializeBoot();
        try {
            URLClassLoader uRLClassLoader = new URLClassLoader(this.runtimeClassPath, this.bootLoader);
            Class<?> clazz = Class.forName("bluej.Main", true, uRLClassLoader);
            clazz.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }

    private void initializeBoot() {
        this.bootLoader = this.getClass().getClassLoader();
        this.javaHomeDir = new File(System.getProperty("java.home"));
        try {
            this.runtimeClassPath = this.getKnownJars(Boot.getBluejLibDir(), runtimeJars, true, numBuildJars);
            this.runtimeUserClassPath = this.getKnownJars(Boot.getBluejLibDir(), userJars, false, numUserBuildJars);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private URL[] getKnownJars(File file, String[] stringArray, boolean bl, int n) throws MalformedURLException {
        URL uRL;
        Object object;
        File file2;
        boolean bl2 = this.commandLineProps.getProperty("useclassesdir", "false").equals("true");
        int n2 = 0;
        ArrayList<URL> arrayList = new ArrayList<URL>();
        if (n != 0 && bl2 && (file2 = new File(file.getParentFile(), "classes")).isDirectory()) {
            arrayList.add(file2.toURI().toURL());
            arrayList.add(new File(file.getParentFile(), "threadchecker/classes").toURI().toURL());
            if (isGreenfoot && (object = this.commandLineProps.getProperty("greenfootclassesdir")) != null) {
                file2 = new File((String)object);
                arrayList.add(file2.toURI().toURL());
            }
            n2 = n;
        }
        for (int i = n2; i < stringArray.length; ++i) {
            object = new File(file, stringArray[i]);
            if (!((File)object).canRead()) continue;
            arrayList.add(((File)object).toURI().toURL());
        }
        if (bl && (uRL = this.getToolsURL()) != null) {
            arrayList.add(uRL);
        }
        if (isGreenfoot && jfxrtJar != null && jfxrtJar.length() != 0) {
            arrayList.add(new File(jfxrtJar).toURI().toURL());
        }
        return arrayList.toArray(new URL[0]);
    }

    private URL getToolsURL() throws MalformedURLException {
        File file = new File(this.javaHomeDir, "lib/tools.jar");
        if (file.canRead()) {
            return file.toURI().toURL();
        }
        File file2 = this.javaHomeDir.getParentFile();
        file = new File(file2, "lib/tools.jar");
        if (file.canRead()) {
            return file.toURI().toURL();
        }
        System.err.println("class Boot: tools.jar not found. Potential problem for execution.  (Java Home: " + this.javaHomeDir.getAbsolutePath() + ")");
        return null;
    }

    public Properties getCommandLineProperties() {
        return this.commandLineProps;
    }

    public void setQuitHandler(Runnable runnable) {
        this.quitAction = runnable;
    }

    static {
        bluejJars = new String[]{"bluejcore.jar", "bluejeditor.jar", "bluejext.jar", "antlr-runtime-3.4.jar", "AppleJavaExtensions.jar", "commons-logging-api-1.1.2.jar", "commons-vfs2-2.0.jar", "diffutils-1.2.1.jar", "guava-17.0.jar", "hamcrest-core-1.3.jar", "httpclient-4.1.1.jar", "httpcore-4.1.jar", "httpmime-4.1.1.jar", "javassist-3.18.0.jar", "jsch-0.1.53.jar", "junit-4.11.jar", "lang-stride.jar", "org.eclipse.jgit-4.1.0.jar", "sequence-library-1.0.3.jar", "slf4j-api-1.7.2.jar", "slf4j-jdk14-1.7.2.jar", "sqljet-1.1.10.jar", "svnkit.jar", "svnkit-javahl.jar", "trilead.jar", "xom-1.2.9.jar"};
        runtimeJars = bluejJars;
        userJars = bluejUserJars;
        numBuildJars = 3;
        numUserBuildJars = 1;
        isGreenfoot = false;
        macInitialProjects = new ArrayList();
    }

    public static class App
    extends javafx.application.Application {
        public App() {
            if (System.getProperty("os.name").contains("OS X")) {
                Application application = Application.GetApplication();
                application.setEventHandler(new Application.EventHandler(){

                    public void handleOpenFilesAction(Application application, long l, String[] stringArray) {
                        for (String string : stringArray) {
                            if (string.contains(":") || string.equals("bluej.Boot") || string.startsWith("-")) continue;
                            macInitialProjects.add(new File(string));
                        }
                        super.handleOpenFilesAction(application, l, stringArray);
                    }

                    public void handleQuitAction(Application application, long l) {
                        Boot.getInstance().quitAction.run();
                        super.handleQuitAction(application, l);
                    }
                });
            }
        }

        @OnThread(value=Tag.FXPlatform, ignoreParent=true)
        public void start(Stage stage) throws Exception {
            Platform.setImplicitExit((boolean)false);
            stage.setTitle("BlueJ");
            new Thread(() -> Boot.subMain()).start();
        }
    }

    @FunctionalInterface
    private static interface SwingSupplier<T> {
        @OnThread(value=Tag.Swing)
        public T get();
    }
}

