/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.component.power.impl;

import com.pi4j.component.power.PowerBase;
import com.pi4j.component.power.PowerState;
import com.pi4j.component.power.PowerStateChangeEvent;
import com.pi4j.io.gpio.GpioPinDigitalOutput;
import com.pi4j.io.gpio.PinState;
import com.pi4j.io.gpio.event.GpioPinDigitalStateChangeEvent;
import com.pi4j.io.gpio.event.GpioPinListener;
import com.pi4j.io.gpio.event.GpioPinListenerDigital;

public class GpioPowerComponent
extends PowerBase {
    GpioPinDigitalOutput pin = null;
    PinState onState = PinState.HIGH;
    PinState offState = PinState.LOW;
    private GpioPinListenerDigital listener = new GpioPinListenerDigital(){

        public void handleGpioPinDigitalStateChangeEvent(GpioPinDigitalStateChangeEvent event) {
            if (event.getState() == GpioPowerComponent.this.onState) {
                GpioPowerComponent.this.notifyListeners(new PowerStateChangeEvent(GpioPowerComponent.this, PowerState.OFF, PowerState.ON));
            }
            if (event.getState() == GpioPowerComponent.this.offState) {
                GpioPowerComponent.this.notifyListeners(new PowerStateChangeEvent(GpioPowerComponent.this, PowerState.ON, PowerState.OFF));
            }
        }
    };

    public GpioPowerComponent(GpioPinDigitalOutput pin, PinState onState, PinState offState) {
        this(pin);
        this.onState = onState;
        this.offState = offState;
    }

    public GpioPowerComponent(GpioPinDigitalOutput pin) {
        this.pin = pin;
        this.pin.addListener(new GpioPinListener[]{this.listener});
    }

    @Override
    public PowerState getState() {
        if (this.pin.isState(this.onState)) {
            return PowerState.ON;
        }
        if (this.pin.isState(this.offState)) {
            return PowerState.OFF;
        }
        return PowerState.UNKNOWN;
    }

    @Override
    public void setState(PowerState state) {
        switch (state) {
            case OFF: {
                if (this.isOff()) break;
                this.pin.setState(this.offState);
                break;
            }
            case ON: {
                if (this.isOn()) break;
                this.pin.setState(this.onState);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Cannot set power state: " + state.toString());
            }
        }
    }
}

