/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.common.persistence;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public final class Translations {
    private static final String[] s_locales = Translations.buildVariants();
    private static final Translations INSTANCE = new Translations();
    private final Map<String, Properties> m_localizationProperties = new HashMap<String, Properties>();

    public void addProperties(String locale, Properties newProperties) {
        Properties currentProperties = this.m_localizationProperties.get(locale);
        if (currentProperties == null) {
            this.m_localizationProperties.put(locale, newProperties);
        } else {
            this.mergeProperties(newProperties, currentProperties);
        }
    }

    public void addTranslations(Translations translations) {
        String[] stringArray = translations.getLocales();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String locale = stringArray[n2];
            Properties newProperties = this.m_localizationProperties.get(locale);
            this.addProperties(locale, newProperties);
            ++n2;
        }
    }

    private String[] getLocales() {
        return this.m_localizationProperties.keySet().toArray(new String[this.m_localizationProperties.keySet().size()]);
    }

    private void mergeProperties(Properties source, Properties destination) {
        for (Map.Entry<Object, Object> entry : source.entrySet()) {
            destination.put(entry.getKey(), entry.getValue());
        }
    }

    public String getTranslation(String key) {
        if (key != null) {
            String[] stringArray = Translations.getVariants();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o;
                String locale = stringArray[n2];
                Properties p = this.m_localizationProperties.get(locale);
                if (p != null && (o = p.get(key)) != null) {
                    return (String)o;
                }
                ++n2;
            }
        }
        return null;
    }

    private static String[] buildVariants() {
        String nl = Locale.getDefault().toString();
        ArrayList<String> result = new ArrayList<String>(4);
        while (true) {
            result.add(nl);
            int lastSeparator = nl.lastIndexOf(95);
            if (lastSeparator == -1) break;
            nl = nl.substring(0, lastSeparator);
        }
        result.add("");
        return result.toArray(new String[result.size()]);
    }

    public static String[] getVariants() {
        return s_locales;
    }

    public static Translations getGlobal() {
        return INSTANCE;
    }
}

