/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.favorites.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.favorites.Actions;
import org.netbeans.modules.favorites.FavoritesNode;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataShadow;
import org.openide.util.Mutex;

public final class Favorites {
    private static Favorites INSTANCE;
    private static final Logger LOG;

    public static synchronized Favorites getDefault() {
        if (INSTANCE == null) {
            INSTANCE = new Favorites();
        }
        return INSTANCE;
    }

    public synchronized void add(FileObject ... fileObjectArray) throws NullPointerException, DataObjectNotFoundException {
        if (fileObjectArray.length == 0) {
            return;
        }
        this.addInternal(fileObjectArray);
    }

    public synchronized boolean selectWithAddition(FileObject fileObject) throws DataObjectNotFoundException {
        DataShadow dataShadow;
        DataShadow dataShadow2 = this.findShadow(fileObject);
        boolean bl = false;
        if (dataShadow2 == null) {
            dataShadow = this.addInternal(fileObject);
            if (((DataShadow[])dataShadow).length > 0) {
                dataShadow2 = dataShadow[0];
            }
            boolean bl2 = bl = dataShadow2 != null;
        }
        if (dataShadow2 != null) {
            dataShadow = dataShadow2;
            Mutex.EVENT.readAccess(new Runnable((DataObject)dataShadow){
                final /* synthetic */ DataObject val$fObj;
                {
                    this.val$fObj = dataObject;
                }

                @Override
                public void run() {
                    Actions.Add.selectAfterAddition(this.val$fObj);
                }
            });
        }
        return bl;
    }

    public synchronized boolean isInFavorites(FileObject fileObject) {
        return this.findShadow(fileObject) != null;
    }

    public String toString() {
        return "Favorites: " + this.getFavoriteRoots().toString();
    }

    void clearBrokenShadows() throws IOException {
        DataObject[] dataObjectArray;
        DataFolder dataFolder = FavoritesNode.getFolder();
        for (DataObject dataObject : dataObjectArray = dataFolder.getChildren()) {
            if (dataObject instanceof DataShadow) continue;
            dataObject.delete();
        }
    }

    private DataShadow findShadow(FileObject fileObject) {
        DataFolder dataFolder = FavoritesNode.getFolder();
        DataObject[] dataObjectArray = dataFolder.getChildren();
        for (int i = 0; i < dataObjectArray.length; ++i) {
            DataShadow dataShadow;
            if (!(dataObjectArray[i] instanceof DataShadow) || !fileObject.equals((dataShadow = (DataShadow)dataObjectArray[i]).getOriginal().getPrimaryFile())) continue;
            return dataShadow;
        }
        return null;
    }

    public synchronized List<FileObject> getFavoriteRoots() {
        DataFolder dataFolder = FavoritesNode.getFolder();
        DataObject[] dataObjectArray = dataFolder.getChildren();
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>(dataObjectArray.length);
        for (DataObject dataObject : dataObjectArray) {
            if (!(dataObject instanceof DataShadow)) continue;
            arrayList.add(((DataShadow)dataObject).getOriginal().getPrimaryFile());
        }
        return arrayList;
    }

    public synchronized void remove(FileObject ... fileObjectArray) throws IOException, NullPointerException {
        DataObject[] dataObjectArray;
        DataFolder dataFolder = FavoritesNode.getFolder();
        for (DataObject dataObject : dataObjectArray = dataFolder.getChildren()) {
            if (!(dataObject instanceof DataShadow)) continue;
            FileObject fileObject = ((DataShadow)dataObject).getOriginal().getPrimaryFile();
            for (FileObject fileObject2 : fileObjectArray) {
                if (!fileObject2.equals(fileObject)) continue;
                dataObject.delete();
            }
        }
    }

    private DataShadow[] addInternal(FileObject ... fileObjectArray) throws DataObjectNotFoundException {
        DataFolder dataFolder = FavoritesNode.getFolder();
        DataShadow[] dataShadowArray = this.createShadows(dataFolder, fileObjectArray);
        Actions.Add.reorderAfterAddition(dataFolder, dataFolder.getChildren(), Arrays.asList(dataShadowArray));
        return dataShadowArray;
    }

    private DataShadow[] createShadows(DataFolder dataFolder, FileObject[] fileObjectArray) throws DataObjectNotFoundException, IllegalArgumentException {
        ArrayList<DataShadow> arrayList = new ArrayList<DataShadow>(fileObjectArray.length);
        for (int i = 0; i < fileObjectArray.length; ++i) {
            DataObject dataObject;
            if (this.isInFavorites(fileObjectArray[i]) || (dataObject = DataObject.find((FileObject)fileObjectArray[i])) == null) continue;
            try {
                arrayList.add(dataObject.createShadow(dataFolder));
                continue;
            }
            catch (IOException iOException) {
                LOG.log(Level.WARNING, null, iOException);
            }
        }
        return arrayList.toArray(new DataShadow[arrayList.size()]);
    }

    static {
        LOG = Logger.getLogger(Favorites.class.getName());
    }
}

