/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.stride;

import bluej.collect.StrideEditReason;
import bluej.editor.stride.BorderPaneWithHighlightColor;
import bluej.editor.stride.CodeOverlayPane;
import bluej.editor.stride.FXTabbedEditor;
import bluej.editor.stride.FrameCatalogue;
import bluej.editor.stride.FrameEditor;
import bluej.editor.stride.FrameSelection;
import bluej.editor.stride.FrameShelfStorage;
import bluej.editor.stride.WindowOverlayPane;
import bluej.parser.AssistContent;
import bluej.stride.framedjava.ast.JavaFragment;
import bluej.stride.framedjava.ast.Loader;
import bluej.stride.framedjava.ast.SlotFragment;
import bluej.stride.framedjava.ast.links.PossibleLink;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.frames.GreenfootFrameUtil;
import bluej.stride.framedjava.frames.StrideCategory;
import bluej.stride.framedjava.frames.StrideDictionary;
import bluej.stride.framedjava.slots.ExpressionSlot;
import bluej.stride.generic.AssistContentThreadSafe;
import bluej.stride.generic.CanvasParent;
import bluej.stride.generic.ExtensionDescription;
import bluej.stride.generic.Frame;
import bluej.stride.generic.FrameCanvas;
import bluej.stride.generic.FrameCursor;
import bluej.stride.generic.FrameDictionary;
import bluej.stride.generic.FrameTypeCheck;
import bluej.stride.generic.InteractionManager;
import bluej.stride.generic.RecallableFocus;
import bluej.stride.slots.EditableSlot;
import bluej.stride.slots.LinkedIdentifier;
import bluej.stride.slots.SuggestionList;
import bluej.utility.BackgroundConsumer;
import bluej.utility.Utility;
import bluej.utility.javafx.FXPlatformConsumer;
import bluej.utility.javafx.FXPlatformRunnable;
import bluej.utility.javafx.FXSupplier;
import bluej.utility.javafx.JavaFXUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javafx.beans.Observable;
import javafx.beans.binding.DoubleExpression;
import javafx.beans.binding.StringExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableStringValue;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;
import javafx.util.Duration;
import nu.xom.Element;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FX)
public class FrameShelf
implements InteractionManager,
CanvasParent,
FrameTypeCheck {
    private final SimpleStringProperty fakeName = new SimpleStringProperty("...");
    private final ObjectProperty<Frame.View> viewHolder = new ReadOnlyObjectWrapper((Object)Frame.View.NORMAL);
    private final FXTabbedEditor parent;
    private final BorderPaneWithHighlightColor shelfPane = new BorderPaneWithHighlightColor();
    private final FrameCanvas canvas = new FrameCanvas((InteractionManager)this, (CanvasParent)this, "shelf-");
    private final FrameSelection selection = new FrameSelection(this);
    private final FrameShelfStorage centralStorage;
    private FrameCursor dragTarget;

    public FrameShelf(FXTabbedEditor parent, FrameShelfStorage storage) {
        this.parent = parent;
        this.shelfPane.setCenter(this.canvas.getNode());
        this.shelfPane.setStyle("-fx-font-size: " + (String)this.getFontSizeCSS().get() + ";");
        this.centralStorage = storage;
        storage.registerShelf(this);
    }

    @OnThread(value=Tag.FXPlatform)
    public void withCompletions(JavaFragment.PosInSourceDoc pos, ExpressionSlot<?> completing, CodeElement codeEl, FXPlatformConsumer<List<AssistContentThreadSafe>> handler) {
        JavaFXUtil.runAfterCurrent(() -> handler.accept(Collections.emptyList()));
    }

    @OnThread(value=Tag.FXPlatform)
    public void withAccessibleMembers(JavaFragment.PosInSourceDoc pos, Set<AssistContent.CompletionKind> kinds, boolean includeOverridden, FXPlatformConsumer<List<AssistContentThreadSafe>> handler) {
        JavaFXUtil.runAfterCurrent(() -> handler.accept(Collections.emptyList()));
    }

    @OnThread(value=Tag.FXPlatform)
    public void withSuperConstructors(FXPlatformConsumer<List<AssistContentThreadSafe>> handler) {
        JavaFXUtil.runAfterCurrent(() -> handler.accept(Collections.emptyList()));
    }

    @OnThread(value=Tag.FXPlatform)
    public void withTypes(BackgroundConsumer<Map<String, AssistContentThreadSafe>> handler) {
        Utility.runBackground(() -> handler.accept(Collections.emptyMap()));
    }

    @OnThread(value=Tag.FXPlatform)
    public void withTypes(Class<?> superType, boolean includeSelf, Set<InteractionManager.Kind> kinds, BackgroundConsumer<Map<String, AssistContentThreadSafe>> handler) {
        Utility.runBackground(() -> handler.accept(Collections.emptyMap()));
    }

    @OnThread(value=Tag.Any)
    public Map<SuggestionList.SuggestionShown, Collection<AssistContentThreadSafe>> getImportSuggestions() {
        return Collections.emptyMap();
    }

    public void addImport(String importSrc) {
    }

    public FrameCursor getFocusedCursor() {
        return null;
    }

    public List<InteractionManager.FileCompletion> getAvailableFilenames() {
        return Collections.emptyList();
    }

    public ObservableStringValue nameProperty() {
        return this.fakeName;
    }

    public FrameDictionary<StrideCategory> getDictionary() {
        return StrideDictionary.getDictionary();
    }

    @OnThread(value=Tag.FXPlatform)
    public void searchLink(PossibleLink link, FXPlatformConsumer<Optional<LinkedIdentifier>> callback) {
        JavaFXUtil.runAfterCurrent(() -> callback.accept(Optional.empty()));
    }

    public Pane getDragTargetCursorPane() {
        return this.parent.getDragCursorPane();
    }

    public void ensureImportsVisible() {
    }

    public void updateCatalog(FrameCursor f) {
    }

    public void updateErrorOverviewBar() {
    }

    public Paint getHighlightColor() {
        return (Paint)this.shelfPane.cssHighlightColorProperty().get();
    }

    public List<AssistContentThreadSafe> getThisConstructors() {
        return Collections.emptyList();
    }

    public FrameEditor getFrameEditor() {
        return null;
    }

    public void recordCodeCompletionStarted(SlotFragment position, int index, String stem) {
    }

    public void recordCodeCompletionEnded(SlotFragment position, int index, String stem, String completion) {
    }

    public void recordErrorIndicatorShown(int identifier) {
    }

    public void setupFrame(Frame f) {
        FXTabbedEditor.setupFrameDrag(f, true, (FXSupplier<FXTabbedEditor>)((FXSupplier)() -> this.parent), (FXSupplier<Boolean>)((FXSupplier)() -> true), (FXSupplier<FrameSelection>)((FXSupplier)() -> this.selection));
    }

    public void setupFrameCursor(FrameCursor c) {
    }

    public void setupFocusableSlotComponent(EditableSlot parent, Node focusableComponent, boolean canCodeComplete, FXSupplier<List<ExtensionDescription>> getExtensions, List<FrameCatalogue.Hint> hints) {
    }

    public void setupSuggestionWindow(Stage window) {
    }

    public void clickNearestCursor(double sceneX, double sceneY, boolean shiftDown) {
        FrameCursor c = this.canvas.findClosestCursor(sceneX, sceneY, Collections.emptyList(), false, true);
        if (c != null) {
            c.requestFocus();
        }
    }

    public FrameCursor findCursor(double sceneX, double sceneY, FrameCursor prevCursor, FrameCursor nextCursor, List<Frame> exclude, boolean isDrag, boolean canDescend) {
        return this.canvas.findClosestCursor(sceneX, sceneY, exclude, isDrag, canDescend);
    }

    public FrameCursor createCursor(FrameCanvas parent) {
        return new FrameCursor((InteractionManager)this, parent);
    }

    public Observable getObservableScroll() {
        return new ReadOnlyDoubleWrapper(0.0);
    }

    public DoubleExpression getObservableViewportHeight() {
        return new ReadOnlyDoubleWrapper(0.0);
    }

    public WindowOverlayPane getWindowOverlayPane() {
        return null;
    }

    public CodeOverlayPane getCodeOverlayPane() {
        return null;
    }

    public void modifiedFrame(Frame f, boolean force) {
    }

    public void recordEdits(StrideEditReason reason) {
    }

    public void afterRegenerateAndReparse(FXPlatformRunnable action) {
    }

    public void beginRecordingState(RecallableFocus f) {
    }

    public void endRecordingState(RecallableFocus f) {
    }

    public void scrollTo(Node n, double yOffsetFromTop, Duration duration) {
    }

    public FrameSelection getSelection() {
        return this.selection;
    }

    public void registerStackHighlight(Frame frame) {
    }

    public boolean isLoading() {
        return false;
    }

    public ReadOnlyObjectProperty<Frame.View> viewProperty() {
        return this.viewHolder;
    }

    public void showUndoDeleteBanner(int totalEffort) {
    }

    public boolean isEditable() {
        return true;
    }

    public BooleanProperty cheatSheetShowingProperty() {
        return null;
    }

    public void recordUnknownCommandKey(Frame enclosingFrame, int index, char key) {
    }

    public FrameTypeCheck check(FrameCanvas childCanvas) {
        return this;
    }

    public FrameCursor getCursorBefore(FrameCanvas c) {
        return null;
    }

    public FrameCursor getCursorAfter(FrameCanvas c) {
        return null;
    }

    public List<ExtensionDescription> getAvailableExtensions(FrameCanvas canvas, FrameCursor cursorInCanvas) {
        return Collections.emptyList();
    }

    public InteractionManager getEditor() {
        return this;
    }

    public void modifiedCanvasContent() {
    }

    public Frame getFrame() {
        return null;
    }

    public CanvasParent.CanvasKind getChildKind(FrameCanvas c) {
        return null;
    }

    public boolean canInsert(StrideCategory category) {
        return true;
    }

    public boolean canPlace(Class<? extends Frame> type) {
        return true;
    }

    public StringExpression getFontSizeCSS() {
        return new ReadOnlyStringWrapper("10pt");
    }

    public Node getNode() {
        return this.shelfPane;
    }

    public void draggedTo(List<Frame> dragSourceFrames, double sceneX, double sceneY, boolean copying) {
        Bounds shelfBounds = this.shelfPane.localToScene(this.shelfPane.getBoundsInLocal());
        if (sceneX < shelfBounds.getMinX() || sceneX > shelfBounds.getMaxX()) {
            if (this.dragTarget != null) {
                this.dragTarget.stopShowAsDropTarget();
                this.dragTarget = null;
            }
        } else {
            FrameCursor newDragTarget = this.canvas.findClosestCursor(sceneX, sceneY, dragSourceFrames, true, true);
            if (newDragTarget != null && this.dragTarget != newDragTarget) {
                if (this.dragTarget != null) {
                    this.dragTarget.stopShowAsDropTarget();
                    this.dragTarget = null;
                }
                boolean src = FXTabbedEditor.isUselessDrag(newDragTarget, dragSourceFrames, copying);
                boolean acceptsAll = true;
                for (Frame srcFrame : dragSourceFrames) {
                    acceptsAll &= newDragTarget.getParentCanvas().acceptsType(srcFrame);
                }
                newDragTarget.showAsDropTarget(src, acceptsAll, copying);
                this.dragTarget = newDragTarget;
            }
        }
        if (this.dragTarget != null) {
            this.dragTarget.updateDragCopyState(copying);
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public void dragEnd(ArrayList<Frame> dragSourceFrames, boolean fromShelf, boolean copying) {
        if (dragSourceFrames != null && !dragSourceFrames.isEmpty() && this.dragTarget != null) {
            boolean canMove = dragSourceFrames.stream().allMatch(src -> this.dragTarget.getParentCanvas().acceptsType(src));
            if (canMove && !FXTabbedEditor.isUselessDrag(this.dragTarget, dragSourceFrames, copying)) {
                this.beginRecordingState((RecallableFocus)this.dragTarget);
                this.performDrag(dragSourceFrames, fromShelf, copying);
                this.endRecordingState((RecallableFocus)this.dragTarget);
            }
            this.selection.clear();
            this.dragTarget.stopShowAsDropTarget();
            this.dragTarget = null;
        }
    }

    @OnThread(value=Tag.FXPlatform)
    private void performDrag(List<Frame> dragSourceFrames, boolean fromShelf, boolean copying) {
        Frame parentFrame = this.dragTarget.getParentCanvas().getParent().getFrame();
        boolean shouldDisable = parentFrame != null && !parentFrame.isFrameEnabled();
        InteractionManager editor = dragSourceFrames.get(0).getEditor();
        if (!fromShelf && !copying) {
            editor.recordEdits(StrideEditReason.FLUSH);
        }
        Collections.reverse(dragSourceFrames);
        List elements = GreenfootFrameUtil.getElementsForMultipleFrames(dragSourceFrames);
        for (CodeElement codeElement : elements) {
            Frame frame = codeElement.createFrame((InteractionManager)this);
            this.dragTarget.insertBlockAfter(frame);
            if (!shouldDisable) continue;
            frame.setFrameEnabled(false);
        }
        if (!copying) {
            dragSourceFrames.forEach(src -> src.getParentCanvas().removeBlock(src));
        }
        if (!fromShelf && !copying) {
            editor.recordEdits(StrideEditReason.FRAMES_DRAG_SHELF);
        }
    }

    public void cleanup() {
        this.centralStorage.deregisterShelf(this);
    }

    public ObservableList<Frame> getContent() {
        return this.canvas.getBlockContents();
    }

    public void setContent(Element framesElement) {
        this.canvas.clear();
        for (int i = 0; i < framesElement.getChildElements().size(); ++i) {
            this.canvas.insertBlockAfter(Loader.loadElement((Element)framesElement.getChildElements().get(i)).createFrame((InteractionManager)this), null);
        }
    }
}

