/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.stride;

import bluej.Config;
import bluej.editor.stride.FrameEditorTab;
import bluej.editor.stride.TabMenuManager;
import bluej.stride.generic.Frame;
import bluej.stride.slots.EditableSlot;
import bluej.utility.Utility;
import bluej.utility.javafx.FXRunnable;
import bluej.utility.javafx.JavaFXUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.input.KeyCharacterCombination;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;

class FrameMenuManager
extends TabMenuManager {
    private final FrameEditorTab editor;
    private final List<EditableSlot.SortedMenuItem> defaultEditItems;
    private final ObservableList<EditableSlot.SortedMenuItem> contextualEditItems = FXCollections.observableArrayList();
    private final ObservableList<EditableSlot.SortedMenuItem> extraViewItems = FXCollections.observableArrayList();
    private FXRunnable unbindEditItems;
    private FXRunnable unbindViewItems;
    private EditableSlot.MenuItems editMenuListener;
    private EditableSlot.MenuItems viewMenuListener;
    private List<Menu> menus = null;
    private final BooleanProperty javaPreviewShowing;

    FrameMenuManager(FrameEditorTab editor) {
        super(editor);
        this.editor = editor;
        this.javaPreviewShowing = new SimpleBooleanProperty(editor.getView() == Frame.View.JAVA_PREVIEW);
        JavaFXUtil.addChangeListener((ObservableValue)this.javaPreviewShowing, b -> {
            if (b.booleanValue()) {
                JavaFXUtil.runNowOrLater(editor::enableJavaPreview);
            } else {
                JavaFXUtil.runNowOrLater(editor::disableJavaPreview);
            }
        });
        EditableSlot.SortedMenuItem[] sortedMenuItemArray = new EditableSlot.SortedMenuItem[5];
        sortedMenuItemArray[0] = EditableSlot.MenuItemOrder.UNDO.item(JavaFXUtil.makeMenuItem((String)Config.getString((String)"editor.undoLabel"), editor::undo, (KeyCombination)new KeyCodeCombination(KeyCode.Z, new KeyCombination.Modifier[]{KeyCodeCombination.SHORTCUT_DOWN})));
        sortedMenuItemArray[1] = EditableSlot.MenuItemOrder.REDO.item(JavaFXUtil.makeMenuItem((String)Config.getString((String)"editor.redoLabel"), editor::redo, (KeyCombination)(Config.isMacOS() ? new KeyCodeCombination(KeyCode.Z, new KeyCombination.Modifier[]{KeyCodeCombination.SHORTCUT_DOWN, KeyCodeCombination.SHIFT_DOWN}) : new KeyCodeCombination(KeyCode.Y, new KeyCombination.Modifier[]{KeyCodeCombination.SHORTCUT_DOWN}))));
        sortedMenuItemArray[2] = EditableSlot.MenuItemOrder.CUT.item(JavaFXUtil.makeDisabledMenuItem((String)Config.getString((String)"editor.cutLabel"), (KeyCombination)new KeyCodeCombination(KeyCode.X, new KeyCombination.Modifier[]{KeyCodeCombination.SHORTCUT_DOWN})));
        sortedMenuItemArray[3] = EditableSlot.MenuItemOrder.COPY.item(JavaFXUtil.makeDisabledMenuItem((String)Config.getString((String)"editor.copyLabel"), (KeyCombination)new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{KeyCodeCombination.SHORTCUT_DOWN})));
        sortedMenuItemArray[4] = EditableSlot.MenuItemOrder.PASTE.item(JavaFXUtil.makeDisabledMenuItem((String)Config.getString((String)"editor.pasteLabel"), (KeyCombination)new KeyCodeCombination(KeyCode.V, new KeyCombination.Modifier[]{KeyCodeCombination.SHORTCUT_DOWN})));
        this.defaultEditItems = Arrays.asList(sortedMenuItemArray);
    }

    void notifyView(Frame.View v) {
        this.javaPreviewShowing.set(v == Frame.View.JAVA_PREVIEW);
    }

    @Override
    List<Menu> getMenus() {
        if (this.menus == null) {
            Menu editMenu = JavaFXUtil.makeMenu((String)Config.getString((String)"frame.editmenu.title"), (MenuItem[])new MenuItem[0]);
            JavaFXUtil.bindList((ObservableList)editMenu.getItems(), (ObservableList)EditableSlot.SortedMenuItem.sortAndAddDividers(this.contextualEditItems, this.defaultEditItems));
            editMenu.setOnShowing(e -> Utility.ifNotNull((Object)this.editMenuListener, EditableSlot.MenuItems::onShowing));
            editMenu.setOnHidden(e -> Utility.ifNotNull((Object)this.editMenuListener, EditableSlot.MenuItems::onHidden));
            MenuItem birdsEyeItem = JavaFXUtil.makeMenuItem((String)"", this.editor::enableCycleBirdseyeView, (KeyCombination)new KeyCharacterCombination("d", new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
            birdsEyeItem.textProperty().bind((ObservableValue)new StringBinding(){

                protected String computeValue() {
                    switch ((Frame.View)FrameMenuManager.this.editor.viewProperty().get()) {
                        case BIRDSEYE_NODOC: {
                            return Config.getString((String)"frame.viewmenu.birdseye.doc");
                        }
                    }
                    return Config.getString((String)"frame.viewmenu.birdseye");
                }
            });
            Object[] objectArray = new MenuItem[9];
            objectArray[0] = JavaFXUtil.makeMenuItem((String)Config.getString((String)"frame.viewmenu.nextError"), this.editor::nextError, (KeyCombination)new KeyCharacterCombination("k", new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
            objectArray[1] = new SeparatorMenuItem();
            objectArray[2] = JavaFXUtil.makeCheckMenuItem((String)Config.getString((String)"frame.viewmenu.cheatsheet"), (Property)this.editor.cheatSheetShowingProperty(), (KeyCombination)new KeyCodeCombination(KeyCode.F1, new KeyCombination.Modifier[0]));
            objectArray[3] = birdsEyeItem;
            objectArray[4] = JavaFXUtil.makeCheckMenuItem((String)Config.getString((String)"frame.viewmenu.java"), (Property)this.javaPreviewShowing, (KeyCombination)new KeyCharacterCombination("j", new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
            objectArray[5] = new SeparatorMenuItem();
            objectArray[6] = JavaFXUtil.makeMenuItem((String)Config.getString((String)"frame.viewmenu.fontbigger"), this.editor::increaseFontSize, (KeyCombination)new KeyCharacterCombination("=", new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
            objectArray[7] = JavaFXUtil.makeMenuItem((String)Config.getString((String)"frame.viewmenu.fontsmaller"), this.editor::decreaseFontSize, (KeyCombination)new KeyCharacterCombination("-", new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
            objectArray[8] = JavaFXUtil.makeMenuItem((String)Config.getString((String)"frame.viewmenu.fontdefault"), this.editor::resetFontSize, (KeyCombination)new KeyCharacterCombination("0", new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
            ObservableList standardViewMenuItems = FXCollections.observableArrayList((Object[])objectArray);
            Menu viewMenu = new Menu(Config.getString((String)"frame.viewmenu.title"));
            JavaFXUtil.bindList((ObservableList)viewMenu.getItems(), (ObservableList)standardViewMenuItems);
            viewMenu.setOnShowing(e -> Utility.ifNotNull((Object)this.viewMenuListener, EditableSlot.MenuItems::onShowing));
            viewMenu.setOnHidden(e -> Utility.ifNotNull((Object)this.viewMenuListener, EditableSlot.MenuItems::onHidden));
            this.updateMoveMenus();
            this.menus = Arrays.asList(JavaFXUtil.makeMenu((String)Config.getString((String)"frame.classmenu.title"), (MenuItem[])new MenuItem[]{this.mainMoveMenu, JavaFXUtil.makeMenuItem((String)Config.getString((String)"frame.classmenu.print"), () -> this.editor.getFrameEditor().printTo(null, false, false), (KeyCombination)new KeyCodeCombination(KeyCode.P, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN})), JavaFXUtil.makeMenuItem((String)Config.getString((String)"frame.classmenu.close"), () -> this.editor.getParent().close(this.editor), (KeyCombination)new KeyCodeCombination(KeyCode.W, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}))}), editMenu, viewMenu);
        } else {
            this.updateMoveMenus();
        }
        return this.menus;
    }

    void setMenuItems(Map<EditableSlot.TopLevelMenu, EditableSlot.MenuItems> items) {
        EditableSlot.MenuItems viewItems;
        EditableSlot.MenuItems editItems;
        if (this.unbindEditItems != null) {
            this.unbindEditItems.run();
            this.unbindEditItems = null;
            this.contextualEditItems.clear();
            this.editMenuListener = null;
        }
        if ((editItems = items.get(EditableSlot.TopLevelMenu.EDIT)) != null) {
            this.editMenuListener = editItems;
            this.unbindEditItems = JavaFXUtil.bindList(this.contextualEditItems, (ObservableList)editItems.getItems());
        }
        if (this.unbindViewItems != null) {
            this.unbindViewItems.run();
            this.unbindViewItems = null;
            this.extraViewItems.clear();
            this.viewMenuListener = null;
        }
        if ((viewItems = items.get(EditableSlot.TopLevelMenu.VIEW)) != null) {
            this.viewMenuListener = viewItems;
            this.unbindViewItems = JavaFXUtil.bindList(this.extraViewItems, (ObservableList)viewItems.getItems());
        }
    }
}

