/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.stride;

import bluej.utility.javafx.JavaFXUtil;
import javafx.beans.Observable;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.binding.DoubleExpression;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import threadchecker.OnThread;
import threadchecker.Tag;

public class CodeOverlayPane {
    private final Pane pane = new Pane();

    public CodeOverlayPane() {
        JavaFXUtil.addStyleClass((Styleable)this.pane, (String[])new String[]{"code-overlay-pane"});
        this.pane.pickOnBoundsProperty().set(false);
        this.pane.setMouseTransparent(false);
    }

    @OnThread(value=Tag.FXPlatform)
    public void addOverlay(Node overlay, Node relativeTo, DoubleExpression xOffset, DoubleExpression yOffset) {
        this.addOverlay(overlay, relativeTo, xOffset, yOffset, WidthLimit.NO_WIDTH_LIMIT);
    }

    @OnThread(value=Tag.FXPlatform)
    public void addOverlay(final Node overlay, final Node relativeTo, final DoubleExpression xOffset, final DoubleExpression yOffset, final WidthLimit widthLimit) {
        DoubleBinding xPosition = new DoubleBinding(){
            {
                super.bind(new Observable[]{relativeTo.layoutBoundsProperty()});
                super.bind(new Observable[]{relativeTo.localToSceneTransformProperty()});
                super.bind(new Observable[]{CodeOverlayPane.this.pane.layoutBoundsProperty()});
                super.bind(new Observable[]{CodeOverlayPane.this.pane.localToSceneTransformProperty()});
                if (xOffset != null) {
                    super.bind(new Observable[]{xOffset});
                }
            }

            protected double computeValue() {
                double usualX = relativeTo.localToScene(relativeTo.getBoundsInLocal()).getMinX() + (xOffset == null ? 0.0 : xOffset.get());
                if (widthLimit == WidthLimit.LIMIT_WIDTH_AND_SLIDE_LEFT) {
                    return Math.max(0.0, Math.min(usualX, CodeOverlayPane.this.pane.widthProperty().subtract((ObservableNumberValue)((Region)overlay).minWidthProperty()).get()));
                }
                return usualX;
            }
        };
        DoubleBinding yPosition = new DoubleBinding(){
            {
                super.bind(new Observable[]{relativeTo.layoutBoundsProperty()});
                super.bind(new Observable[]{relativeTo.localToSceneTransformProperty()});
                super.bind(new Observable[]{CodeOverlayPane.this.pane.layoutBoundsProperty()});
                super.bind(new Observable[]{CodeOverlayPane.this.pane.localToSceneTransformProperty()});
                if (yOffset != null) {
                    super.bind(new Observable[]{yOffset});
                }
            }

            protected double computeValue() {
                double endRef = relativeTo.localToScene(relativeTo.getBoundsInLocal()).getMinY();
                return CodeOverlayPane.this.sceneYToCodeOverlayY(endRef + (yOffset == null ? 0.0 : yOffset.get()));
            }
        };
        overlay.layoutXProperty().bind((ObservableValue)xPosition);
        overlay.layoutYProperty().bind((ObservableValue)yPosition);
        if (widthLimit != WidthLimit.NO_WIDTH_LIMIT) {
            ((Region)overlay).maxWidthProperty().bind((ObservableValue)this.pane.widthProperty().subtract((ObservableNumberValue)overlay.layoutXProperty()));
        }
        this.pane.getChildren().add((Object)overlay);
    }

    public double sceneYToCodeOverlayY(double sceneY) {
        return this.pane.sceneToLocal(0.0, sceneY).getY();
    }

    @OnThread(value=Tag.FXPlatform)
    public void removeOverlay(Node node) {
        this.pane.getChildren().remove((Object)node);
    }

    public Node getNode() {
        return this.pane;
    }

    public static void setDropShadow(Node n) {
        DropShadow dropShadow = new DropShadow();
        dropShadow.setRadius(8.0);
        dropShadow.setOffsetX(4.0);
        dropShadow.setOffsetY(4.0);
        dropShadow.setColor(Color.color((double)0.6, (double)0.6, (double)0.6));
        n.setEffect((Effect)dropShadow);
    }

    public Canvas addFullSizeCanvas() {
        Canvas c = new Canvas(this.pane.getWidth(), this.pane.getHeight());
        c.setLayoutX(0.0);
        c.setLayoutY(0.0);
        c.setMouseTransparent(true);
        this.pane.getChildren().add((Object)c);
        return c;
    }

    public static enum WidthLimit {
        NO_WIDTH_LIMIT,
        LIMIT_WIDTH,
        LIMIT_WIDTH_AND_SLIDE_LEFT;

    }
}

