/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.moe;

import bluej.editor.moe.AdvancedHighlightPainter;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.text.View;

public class MoeHighlighter
extends LayeredHighlighter {
    private JTextComponent component;
    private List<StandardMoeHighlight> highlights = new LinkedList<StandardMoeHighlight>();
    private LinkedList<MoeHighlight> layeredHighlights = new LinkedList();

    @Override
    public Object addHighlight(int p0, int p1, Highlighter.HighlightPainter p) throws BadLocationException {
        Document doc = this.component.getDocument();
        Position pos0 = doc.createPosition(p0);
        Position pos1 = doc.createPosition(p1);
        StandardMoeHighlight highlight = new StandardMoeHighlight(pos0, pos1, p);
        if (p instanceof LayeredHighlighter.LayerPainter) {
            this.layeredHighlights.add(highlight);
        } else {
            this.highlights.add(highlight);
        }
        highlight.repaintHighlight(this.component);
        return highlight;
    }

    public Object addHighlight(int p0, int p1, AdvancedHighlightPainter p) throws BadLocationException {
        Document doc = this.component.getDocument();
        Position pos0 = doc.createPosition(p0);
        Position pos1 = doc.createPosition(p1);
        AdvancedMoeHighlight highlight = new AdvancedMoeHighlight(pos0, pos1, p);
        this.layeredHighlights.add(highlight);
        highlight.repaintHighlight(this.component);
        return highlight;
    }

    @Override
    public void changeHighlight(Object tag, int p0, int p1) throws BadLocationException {
        MoeHighlight highlight = (MoeHighlight)tag;
        Document doc = this.component.getDocument();
        highlight.repaintHighlight(this.component);
        highlight.startPos = doc.createPosition(p0);
        highlight.endPos = doc.createPosition(p1);
        highlight.repaintHighlight(this.component);
    }

    @Override
    public void install(JTextComponent c) {
        this.removeAllHighlights();
        this.component = c;
    }

    @Override
    public void deinstall(JTextComponent c) {
        this.component = null;
    }

    @Override
    public Highlighter.Highlight[] getHighlights() {
        return this.highlights.toArray(new Highlighter.Highlight[this.highlights.size()]);
    }

    @Override
    public void paint(Graphics g) {
        Rectangle r = this.component.getBounds();
        Insets insets = this.component.getInsets();
        r.x = insets.left;
        r.y = insets.top;
        r.width -= insets.left + insets.right;
        r.height -= insets.top + insets.bottom;
        for (StandardMoeHighlight highlight : this.highlights) {
            highlight.getPainter().paint(g, highlight.getStartOffset(), highlight.getEndOffset(), r, this.component);
        }
    }

    @Override
    public void paintLayeredHighlights(Graphics g, int p0, int p1, Shape viewBounds, JTextComponent editor, View view) {
        int viewStart = view.getStartOffset();
        int viewEnd = view.getEndOffset();
        Iterator<MoeHighlight> i = this.layeredHighlights.descendingIterator();
        while (i.hasNext()) {
            MoeHighlight highlight = i.next();
            if (highlight.startPos.getOffset() >= viewEnd || highlight.endPos.getOffset() <= viewStart) continue;
            highlight.paint(g, p0, p1, viewBounds, editor, view);
        }
    }

    @Override
    public void removeAllHighlights() {
        this.layeredHighlights.clear();
        this.highlights.clear();
        if (this.component != null) {
            this.component.repaint();
        }
    }

    @Override
    public void removeHighlight(Object tag) {
        MoeHighlight mh = (MoeHighlight)tag;
        mh.repaintHighlight(this.component);
        this.highlights.remove(tag);
        this.layeredHighlights.remove(tag);
    }

    private static class AdvancedMoeHighlight
    extends MoeHighlight {
        private AdvancedHighlightPainter painter;

        public AdvancedMoeHighlight(Position startPos, Position endPos, AdvancedHighlightPainter painter) {
            super(startPos, endPos);
            this.painter = painter;
        }

        @Override
        public void repaintHighlight(JTextComponent component) {
            int p0 = this.startPos.getOffset();
            int p1 = this.endPos.getOffset();
            Rectangle r = component.getBounds();
            Insets insets = component.getInsets();
            r.x = insets.left;
            r.y = insets.top;
            r.width -= insets.left + insets.right;
            r.height -= insets.top + insets.bottom;
            View rootView = component.getUI().getRootView(component);
            this.painter.issueRepaint(p0, p1, r, component, rootView);
        }

        @Override
        public void paint(Graphics g, int p0, int p1, Shape viewBounds, JTextComponent editor, View view) {
            this.painter.paint(g, this.startPos.getOffset(), this.endPos.getOffset(), viewBounds, editor, view);
        }
    }

    private static class StandardMoeHighlight
    extends MoeHighlight {
        private Highlighter.HighlightPainter painter;

        public StandardMoeHighlight(Position startPos, Position endPos, Highlighter.HighlightPainter painter) {
            super(startPos, endPos);
            this.painter = painter;
        }

        public Highlighter.HighlightPainter getPainter() {
            return this.painter;
        }

        @Override
        public void paint(Graphics g, int p0, int p1, Shape viewBounds, JTextComponent editor, View view) {
            int start = this.startPos.getOffset();
            int end = this.endPos.getOffset();
            if (p0 < start && p1 > start || p0 >= start && p0 < end) {
                p0 = Math.max(p0, start);
                p1 = Math.min(p1, end);
                ((LayeredHighlighter.LayerPainter)this.painter).paintLayer(g, p0, p1, viewBounds, editor, view);
            }
        }
    }

    private static abstract class MoeHighlight {
        protected Position startPos;
        protected Position endPos;

        public MoeHighlight(Position startPos, Position endPos) {
            this.startPos = startPos;
            this.endPos = endPos;
        }

        public int getStartOffset() {
            return this.startPos.getOffset();
        }

        public int getEndOffset() {
            return this.endPos.getOffset();
        }

        public void repaintHighlight(JTextComponent component) {
            int p0 = this.startPos.getOffset();
            int p1 = this.endPos.getOffset();
            Rectangle r = component.getBounds();
            Insets insets = component.getInsets();
            r.x = insets.left;
            r.y = insets.top;
            r.width -= insets.left + insets.right;
            r.height -= insets.top + insets.bottom;
            View rootView = component.getUI().getRootView(component);
            try {
                Rectangle region = rootView.modelToView(p0, Position.Bias.Forward, p1, Position.Bias.Backward, r).getBounds();
                component.repaint(region);
            }
            catch (BadLocationException ble) {
                throw new RuntimeException(ble);
            }
        }

        public abstract void paint(Graphics var1, int var2, int var3, Shape var4, JTextComponent var5, View var6);
    }
}

