/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.locks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.netbeans.lib.profiler.results.locks.LockGraphBuilder;
import org.netbeans.lib.profiler.results.locks.MonitorInfo;

class ThreadInfo {
    private final int threadId;
    private final Map<MonitorInfo, MonitorDetail> waitMonitors;
    private final Map<MonitorInfo, MonitorDetail> ownerMonitors;
    private OpenMonitor openMonitor;
    private final String threadName;
    private final String threadClassName;

    ThreadInfo(int n, String string, String string2) {
        this.threadId = n;
        this.threadName = string;
        this.threadClassName = string2;
        this.waitMonitors = new HashMap<MonitorInfo, MonitorDetail>();
        this.ownerMonitors = new HashMap<MonitorInfo, MonitorDetail>();
    }

    void openMonitor(ThreadInfo threadInfo, MonitorInfo monitorInfo, long l) {
        assert (this.openMonitor == null);
        this.openMonitor = new OpenMonitor(monitorInfo, threadInfo, l);
    }

    void closeMonitor(MonitorInfo monitorInfo, long l) {
        assert (this.openMonitor != null);
        assert (monitorInfo.equals(this.openMonitor.monitor));
        long l2 = l - this.openMonitor.timeStamp;
        if (LockGraphBuilder.LOG.isLoggable(Level.FINEST)) {
            LockGraphBuilder.LOG.log(Level.FINEST, "Monitor exit mId = {0}, time diff = {1}", new Object[]{Integer.toHexString(monitorInfo.hashCode()), l2});
        }
        ThreadInfo.addMonitor(this.waitMonitors, monitorInfo, this.openMonitor.owner, l2);
        ThreadInfo.addMonitor(this.openMonitor.owner.ownerMonitors, monitorInfo, this, l2);
        this.openMonitor = null;
    }

    private static void addMonitor(Map<MonitorInfo, MonitorDetail> map, MonitorInfo monitorInfo, ThreadInfo threadInfo, long l) {
        MonitorDetail monitorDetail = map.get(monitorInfo);
        if (monitorDetail == null) {
            monitorDetail = new MonitorDetail(monitorInfo);
            map.put(monitorInfo, monitorDetail);
        }
        monitorDetail.addWait(threadInfo, l);
    }

    void timeAdjust(long l) {
        if (this.openMonitor != null) {
            this.openMonitor.timeAdjust(l);
            this.openMonitor.monitor.timeAdjust(this, l);
        }
    }

    boolean isEmpty() {
        return this.waitMonitors.isEmpty() && this.ownerMonitors.isEmpty();
    }

    List<MonitorDetail> cloneWaitMonitorDetails() {
        return ThreadInfo.cloneMonitorDetails(this.waitMonitors);
    }

    List<MonitorDetail> cloneOwnerMonitorDetails() {
        return ThreadInfo.cloneMonitorDetails(this.ownerMonitors);
    }

    private static List<MonitorDetail> cloneMonitorDetails(Map<MonitorInfo, MonitorDetail> map) {
        ArrayList<MonitorDetail> arrayList = new ArrayList<MonitorDetail>(map.size());
        for (MonitorDetail monitorDetail : map.values()) {
            arrayList.add(new MonitorDetail(monitorDetail));
        }
        return arrayList;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ThreadInfo) {
            ThreadInfo threadInfo = (ThreadInfo)object;
            return threadInfo.threadId == this.threadId;
        }
        return false;
    }

    public int hashCode() {
        return this.threadId;
    }

    String getName() {
        return this.threadName;
    }

    static class MonitorDetail {
        final MonitorInfo monitor;
        final Map<ThreadInfo, MonitorInfo.ThreadDetail> threads;
        long count;
        long waitTime;

        private MonitorDetail(MonitorInfo monitorInfo) {
            this.monitor = monitorInfo;
            this.threads = new HashMap<ThreadInfo, MonitorInfo.ThreadDetail>();
        }

        MonitorDetail(MonitorDetail monitorDetail) {
            this.monitor = monitorDetail.monitor;
            this.count = monitorDetail.count;
            this.waitTime = monitorDetail.waitTime;
            this.threads = new HashMap<ThreadInfo, MonitorInfo.ThreadDetail>();
            for (MonitorInfo.ThreadDetail threadDetail : monitorDetail.threads.values()) {
                this.threads.put(threadDetail.threadInfo, threadDetail);
            }
        }

        List<MonitorInfo.ThreadDetail> cloneThreadDetails() {
            return MonitorInfo.cloneThreadDetails(this.threads);
        }

        private void addWait(ThreadInfo threadInfo, long l) {
            this.waitTime += l;
            ++this.count;
            if (threadInfo != null) {
                this.addThread(threadInfo, l);
            }
        }

        private void addThread(ThreadInfo threadInfo, long l) {
            MonitorInfo.ThreadDetail threadDetail = this.threads.get(threadInfo);
            if (threadDetail == null) {
                threadDetail = new MonitorInfo.ThreadDetail(threadInfo);
                this.threads.put(threadInfo, threadDetail);
            }
            threadDetail.addWait(null, l);
        }
    }

    private static class OpenMonitor {
        final MonitorInfo monitor;
        final ThreadInfo owner;
        long timeStamp;

        OpenMonitor(MonitorInfo monitorInfo, ThreadInfo threadInfo, long l) {
            assert (monitorInfo != null);
            assert (threadInfo != null);
            this.monitor = monitorInfo;
            this.owner = threadInfo;
            this.timeStamp = l;
        }

        private void timeAdjust(long l) {
            this.timeStamp += l;
        }
    }
}

