/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.dnd;

import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;

public class ClipboardManager {
    private static final ClipboardManager INSTANCE = new ClipboardManager();
    private static final Transfer[] TRANSFER = new Transfer[]{TextTransfer.getInstance()};
    private final Clipboard m_clipboard = new Clipboard(null);
    private volatile boolean m_onlyVisible = false;
    private volatile boolean m_asRawData = true;
    private volatile boolean m_indenctForStructure = true;
    private volatile boolean m_copyColumnHeaders = true;
    private volatile boolean m_asCsv = false;

    ClipboardManager() {
    }

    public static ClipboardManager getDefault() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContents(String text) {
        Clipboard clipboard = this.m_clipboard;
        synchronized (clipboard) {
            this.m_clipboard.setContents(new Object[]{text}, TRANSFER);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContents() {
        Clipboard clipboard = this.m_clipboard;
        synchronized (clipboard) {
            return (String)this.m_clipboard.getContents((Transfer)TextTransfer.getInstance());
        }
    }

    public boolean shouldCopyOnlyVisible() {
        return this.m_onlyVisible;
    }

    public boolean shouldCopyAsRawData() {
        return this.m_asRawData;
    }

    public boolean shouldCopyAsCsv() {
        return this.m_asCsv;
    }

    public boolean shouldCopyColumnHeaders() {
        return this.m_copyColumnHeaders;
    }

    public boolean shouldIndentForStructure() {
        return this.m_indenctForStructure;
    }

    public void setCopyOnlyVisible(boolean onlyVisible) {
        this.m_onlyVisible = onlyVisible;
    }

    public void setCopyAsRawData(boolean asRawData) {
        this.m_asRawData = asRawData;
    }

    public void setCopyAsCsv(boolean asCsv) {
        this.m_asCsv = asCsv;
    }

    public void setIndentForStructure(boolean indent) {
        this.m_indenctForStructure = indent;
    }

    public void setCopyColumnHeaders(boolean checked) {
        this.m_copyColumnHeaders = checked;
    }
}

