/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.components;

import com.jrockit.mc.components.ui.behaviors.IComponent;
import com.jrockit.mc.components.ui.behaviors.IConfigurer;
import com.jrockit.mc.components.ui.components.ComponentDescriptor;
import com.jrockit.mc.components.ui.components.ComponentTypeDescriptor;
import com.jrockit.mc.components.ui.components.ComponentTypeDescriptorCategory;
import com.jrockit.mc.components.ui.design.UnknownComponent;
import com.jrockit.mc.components.ui.messages.internal.Messages;
import com.jrockit.mc.ui.UIPlugin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public final class ComponentTypeRegistry {
    private static final String COMPONENT_EXTENSION_POINT_ID = "com.jrockit.mc.components.ui.component";
    private static final String NAME = "name";
    private static final String ID = "id";
    private static final String DESCRIPTION = "description";
    private static final String CLASS = "class";
    private static final String CONFIGURER_CLASS = "configurer";
    private static final String ICON = "icon";
    private static final String CATEGORY = "type";
    private static final String DEFAULt_IDENTIFIER = "defaultIdentifier";
    private static final String REQUIRED_SERVICES = "requiredServices";
    private final List<ComponentTypeDescriptor> m_componentTypeDescriptors = new ArrayList<ComponentTypeDescriptor>();
    private final Map<String, ComponentTypeDescriptorCategory> m_componentTypeCategories = new LinkedHashMap<String, ComponentTypeDescriptorCategory>();

    public ComponentTypeRegistry() {
        this.initializeCategories();
        this.initializeRegistry();
    }

    IComponent createComponent(ComponentTypeDescriptor cd) {
        try {
            return (IComponent)cd.getConfigurationElement().createExecutableExtension(CLASS);
        }
        catch (Exception ce) {
            UIPlugin.getDefault().getLogger().log(Level.WARNING, "Could not create class for component " + cd.getName());
            return new UnknownComponent(cd);
        }
    }

    public IConfigurer createConfigurer(ComponentDescriptor cd) {
        return this.createConfigurer(this.getComponentTypeDescriptor(cd.getTypeIdentifier()));
    }

    public IConfigurer createConfigurer(ComponentTypeDescriptor cd) {
        try {
            return (IConfigurer)cd.getConfigurationElement().createExecutableExtension(CONFIGURER_CLASS);
        }
        catch (CoreException ce) {
            UIPlugin.getDefault().getLogger().log(Level.WARNING, "Could not create class for component " + cd.getName());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCategory(String name, String identifier, String imageString) {
        Map<String, ComponentTypeDescriptorCategory> map = this.m_componentTypeCategories;
        synchronized (map) {
            this.m_componentTypeCategories.put(identifier, new ComponentTypeDescriptorCategory(name, identifier, imageString));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ComponentTypeDescriptorCategory> getComponentTypeCategories() {
        Map<String, ComponentTypeDescriptorCategory> map = this.m_componentTypeCategories;
        synchronized (map) {
            return Collections.unmodifiableCollection(new ArrayList<ComponentTypeDescriptorCategory>(this.m_componentTypeCategories.values()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addComponentTypeDescriptor(ComponentTypeDescriptor componentTypeDescriptor) {
        List<ComponentTypeDescriptor> list = this.m_componentTypeDescriptors;
        synchronized (list) {
            this.m_componentTypeDescriptors.add(componentTypeDescriptor);
            ComponentTypeDescriptorCategory category = this.getComponentCategoryDescriptor(componentTypeDescriptor.getCategory());
            category.addComponentTypeDescriptor(componentTypeDescriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ComponentTypeDescriptor> getComponentTypeDescriptors() {
        List<ComponentTypeDescriptor> list = this.m_componentTypeDescriptors;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<ComponentTypeDescriptor>(this.m_componentTypeDescriptors));
        }
    }

    public boolean isInstanceOf(ComponentTypeDescriptor descriptor, Class<?> clazz) {
        IComponent o = this.createComponent(descriptor);
        if (o != null) {
            return clazz.isAssignableFrom(o.getClass());
        }
        return false;
    }

    public ComponentTypeDescriptor getDefault() {
        return this.getComponentTypeDescriptors().get(0);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[\n");
        for (ComponentTypeDescriptor ctd : this.getComponentTypeDescriptors()) {
            buffer.append(ctd.getName());
            buffer.append("\n");
        }
        buffer.append("]/n");
        return buffer.toString();
    }

    private void initializeRegistry() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint exPoint = registry.getExtensionPoint(COMPONENT_EXTENSION_POINT_ID);
        if (exPoint != null) {
            IExtension[] iExtensionArray = exPoint.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    this.addComponentTypeDescriptor(ComponentTypeRegistry.createComponentDescriptor(element));
                    ++n4;
                }
                ++n2;
            }
        }
    }

    private static ComponentTypeDescriptor createComponentDescriptor(IConfigurationElement element) {
        ComponentTypeDescriptor ctd = new ComponentTypeDescriptor();
        ctd.setName(element.getAttribute(NAME));
        ctd.setId(element.getAttribute(ID));
        ctd.setDescription(element.getAttribute(DESCRIPTION));
        ctd.setConfigurationElemenent(element);
        ctd.setCategory(element.getAttribute(CATEGORY));
        ctd.setDefaulTIdentifier(element.getAttribute(DEFAULt_IDENTIFIER));
        ctd.setIcon(ComponentTypeRegistry.createImage(element, ctd.getName()));
        ctd.setRequiredServices(element.getAttribute(REQUIRED_SERVICES));
        return ctd;
    }

    public ComponentTypeDescriptor getComponentTypeDescriptor(String typeIdentifier) {
        for (ComponentTypeDescriptor cd : this.getComponentTypeDescriptors()) {
            if (!cd.getId().equals(typeIdentifier)) continue;
            return cd;
        }
        return null;
    }

    public ComponentTypeDescriptorCategory getComponentCategoryDescriptor(String categoryIdentifier) {
        for (ComponentTypeDescriptorCategory ctd : this.getComponentTypeCategories()) {
            if (!ctd.getIdentifier().equals(categoryIdentifier)) continue;
            return ctd;
        }
        return null;
    }

    private static Image createImage(IConfigurationElement configElement, String name) {
        Image image = null;
        try {
            String iconName = configElement.getAttribute(ICON);
            if (iconName != null) {
                IExtension extension = configElement.getDeclaringExtension();
                String extendingPluginId = extension.getContributor().getName();
                ImageDescriptor desc = AbstractUIPlugin.imageDescriptorFromPlugin((String)extendingPluginId, (String)iconName);
                image = desc.createImage();
            }
        }
        catch (Exception e) {
            UIPlugin.getDefault().getLogger().log(Level.WARNING, "Could not load image for configurer with name " + name);
        }
        return image;
    }

    private void initializeCategories() {
        this.addCategory(Messages.COMPONENT_CATEGORY_CONTAINER, "container", "container.gif");
        this.addCategory(Messages.COMPONENT_CATEGORY_GRAPHICS, "graphics", "graphics.gif");
        this.addCategory(Messages.COMPONENT_CATEGORY_HISTOGRAM, "histogram", "histogram_16x16.gif");
        this.addCategory(Messages.COMPONENT_CATEGORY_TABLE, "table", "table.gif");
        this.addCategory(Messages.COMPONENT_CATEGORY_TREE, "tree", "tree.gif");
        this.addCategory(Messages.COMPONENT_CATEGORY_TEXT, "text", "text.gif");
        this.addCategory(Messages.COMPONENT_CATEGORY_MISC, "other", "other.gif");
    }

    public ComponentTypeDescriptorCategory getComponentTypeDescriptorCategory(ComponentDescriptor cd) {
        for (ComponentTypeDescriptorCategory ctc : this.getComponentTypeCategories()) {
            for (ComponentTypeDescriptor ctd : ctc.getComponentTypeDescriptors()) {
                if (!cd.getTypeIdentifier().equals(ctd.getId())) continue;
                return ctc;
            }
        }
        return null;
    }
}

