/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.parser.binary;

import com.jrockit.mc.flightrecorder.internal.parser.binary.ArrayParser;
import com.jrockit.mc.flightrecorder.internal.parser.binary.BooleanParser;
import com.jrockit.mc.flightrecorder.internal.parser.binary.ByteParser;
import com.jrockit.mc.flightrecorder.internal.parser.binary.CompositeParser;
import com.jrockit.mc.flightrecorder.internal.parser.binary.ConstantPool;
import com.jrockit.mc.flightrecorder.internal.parser.binary.DoubleParser;
import com.jrockit.mc.flightrecorder.internal.parser.binary.FloatParser;
import com.jrockit.mc.flightrecorder.internal.parser.binary.IParser;
import com.jrockit.mc.flightrecorder.internal.parser.binary.IntegerParser;
import com.jrockit.mc.flightrecorder.internal.parser.binary.LongMultiplyParser;
import com.jrockit.mc.flightrecorder.internal.parser.binary.LongParser;
import com.jrockit.mc.flightrecorder.internal.parser.binary.ShortParser;
import com.jrockit.mc.flightrecorder.internal.parser.binary.StringParser;
import com.jrockit.mc.flightrecorder.internal.parser.binary.UTFStringParser;
import com.jrockit.mc.flightrecorder.internal.parser.model.DataType;
import com.jrockit.mc.flightrecorder.internal.parser.model.ValueDescriptor;
import com.jrockit.mc.flightrecorder.spi.FieldType;
import java.util.Map;

public final class ParserFactory {
    private final Map<Integer, ConstantPool> constantPools;
    private final double nanosPerTic;

    public ParserFactory(Map<Integer, ConstantPool> constantPools, double ticsPerNano) {
        this.constantPools = constantPools;
        this.nanosPerTic = 1.0 / ticsPerNano;
    }

    public IParser createParser(ValueDescriptor[] descriptors) {
        if (descriptors.length == 1) {
            return this.createParser(descriptors[0]);
        }
        return new CompositeParser(this.createParsers(descriptors));
    }

    public IParser[] createParsers(ValueDescriptor[] valueDescriptors) {
        IParser[] parsers = new IParser[valueDescriptors.length];
        int n = 0;
        while (n < valueDescriptors.length) {
            parsers[n] = this.createParser(valueDescriptors[n]);
            ++n;
        }
        return parsers;
    }

    public IParser createParser(ValueDescriptor vd) {
        ConstantPool pool = this.constantPools.get(vd.getContentType());
        if (pool != null) {
            if (vd.getDataType() == DataType.ARRAY) {
                return new ArrayParser(pool);
            }
            return pool;
        }
        switch (vd.getContentType()) {
            case 2: 
            case 3: {
                return new LongMultiplyParser(1000000.0);
            }
            case 5: {
                return new LongMultiplyParser(this.nanosPerTic);
            }
        }
        return this.createSimpleParser(vd);
    }

    public FieldType getFieldType(ValueDescriptor desc) {
        if (this.constantPools.containsKey(desc.getContentType())) {
            return FieldType.OBJECT;
        }
        if (desc.getDataType().isNumeric()) {
            return FieldType.NUMERIC;
        }
        if (desc.getDataType().isTextual()) {
            return FieldType.STRING;
        }
        return FieldType.OBJECT;
    }

    private IParser createSimpleParser(ValueDescriptor vd) {
        DataType dataType = vd.getDataType();
        switch (dataType) {
            case BYTE: 
            case U1: {
                return ByteParser.INSTANCE;
            }
            case BOOLEAN: {
                return BooleanParser.INSTANCE;
            }
            case SHORT: 
            case U2: {
                return ShortParser.INSTANCE;
            }
            case INTEGER: 
            case U4: {
                return IntegerParser.INSTANCE;
            }
            case FLOAT: {
                return FloatParser.INSTANCE;
            }
            case LONG: 
            case U8: {
                return LongParser.INSTANCE;
            }
            case DOUBLE: {
                return DoubleParser.INSTANCE;
            }
            case STRING: {
                return StringParser.INSTANCE;
            }
            case UTF8: {
                return UTFStringParser.INSTANCE;
            }
            case ARRAY: 
            case STRUCTARRAY: {
                return new ArrayParser(this.createParser(vd.getChildren()));
            }
            case STRUCT: {
                return this.createParser(vd.getChildren());
            }
        }
        throw new IllegalStateException("Can't parse datatype " + (Object)((Object)dataType));
    }
}

