/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility.javafx;

import bluej.utility.Debug;
import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javafx.embed.swing.SwingNode;
import javafx.event.EventHandler;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import sun.swing.JLightweightFrame;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class SwingKeyEventHandlerFixed
implements EventHandler<KeyEvent> {
    private final SwingNode swingNode;
    private Field lwFrameField;

    @OnThread(value=Tag.Any)
    public SwingKeyEventHandlerFixed(SwingNode swingNode) {
        this.swingNode = swingNode;
        try {
            this.lwFrameField = SwingNode.class.getDeclaredField("lwFrame");
            this.lwFrameField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    public void handle(KeyEvent event) {
        try {
            this.handleSub(event);
        }
        catch (Exception e) {
            Debug.reportError(e);
        }
    }

    public void handleSub(KeyEvent event) throws IllegalAccessException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException {
        String text;
        JLightweightFrame frame = (JLightweightFrame)this.lwFrameField.get(this.swingNode);
        if (frame == null) {
            return;
        }
        if (event.getCharacter().isEmpty()) {
            return;
        }
        if (event.getCode() == KeyCode.LEFT || event.getCode() == KeyCode.RIGHT || event.getCode() == KeyCode.UP || event.getCode() == KeyCode.DOWN || event.getCode() == KeyCode.TAB) {
            event.consume();
        }
        Method fxKeyEventTypeToKeyID = Class.forName("javafx.embed.swing.SwingEvents").getDeclaredMethod("fxKeyEventTypeToKeyID", KeyEvent.class);
        fxKeyEventTypeToKeyID.setAccessible(true);
        int swingID = (Integer)fxKeyEventTypeToKeyID.invoke(null, event);
        if (swingID < 0) {
            return;
        }
        Method fxKeyModsToKeyMods = Class.forName("javafx.embed.swing.SwingEvents").getDeclaredMethod("fxKeyModsToKeyMods", KeyEvent.class);
        fxKeyModsToKeyMods.setAccessible(true);
        int swingModifiers = (Integer)fxKeyModsToKeyMods.invoke(null, event);
        int swingKeyCode = event.getCode().impl_getCode();
        char swingChar = event.getCharacter().charAt(0);
        if (event.getEventType() == KeyEvent.KEY_PRESSED && (text = event.getText()).length() == 1) {
            swingChar = text.charAt(0);
        }
        if (event.getEventType() == KeyEvent.KEY_TYPED && event.isAltDown() && event.isControlDown()) {
            swingModifiers = 0;
        }
        long swingWhen = System.currentTimeMillis();
        java.awt.event.KeyEvent keyEvent = new java.awt.event.KeyEvent(frame, swingID, swingWhen, swingModifiers, swingKeyCode, swingChar);
        AccessController.doPrivileged(new PostEventAction(keyEvent));
    }

    private static class PostEventAction
    implements PrivilegedAction<Void> {
        private AWTEvent event;

        public PostEventAction(AWTEvent event) {
            this.event = event;
        }

        @Override
        @OnThread(value=Tag.FXPlatform, ignoreParent=true)
        public @OnThread(value=Tag.FXPlatform, ignoreParent=true) Void run() {
            EventQueue eq = Toolkit.getDefaultToolkit().getSystemEventQueue();
            eq.postEvent(this.event);
            return null;
        }
    }
}

