/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility.javafx;

import bluej.utility.Utility;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MultiListener<T> {
    private final IdentityHashMap<T, BooleanAndRemoveAndUpdate> listening = new IdentityHashMap();
    private final Function<T, RemoveAndUpdate> addListener;

    public MultiListener(Function<T, RemoveAndUpdate> addListener) {
        this.addListener = addListener;
    }

    public void listenOnlyTo(Stream<T> items) {
        this.listening.forEach((k, v) -> {
            v.flaggedForRemoval = true;
        });
        for (T t : Utility.iterableStream(items)) {
            BooleanAndRemoveAndUpdate value = this.listening.get(t);
            if (value != null) {
                value.removeAndUpdate.updateListener();
                value.flaggedForRemoval = false;
                continue;
            }
            this.listening.put(t, new BooleanAndRemoveAndUpdate(this.addListener.apply(t)));
        }
        List<Map.Entry> stale = this.listening.entrySet().stream().filter(e -> ((BooleanAndRemoveAndUpdate)e.getValue()).flaggedForRemoval).collect(Collectors.toList());
        stale.forEach(e -> {
            ((BooleanAndRemoveAndUpdate)e.getValue()).removeAndUpdate.removeListener();
            this.listening.remove(e.getKey());
        });
    }

    public void stopListening() {
        this.listening.forEach((k, v) -> v.removeAndUpdate.removeListener());
        this.listening.clear();
    }

    private static class BooleanAndRemoveAndUpdate {
        public boolean flaggedForRemoval = false;
        public final RemoveAndUpdate removeAndUpdate;

        BooleanAndRemoveAndUpdate(RemoveAndUpdate removeAndUpdate) {
            this.removeAndUpdate = removeAndUpdate;
        }
    }

    public static interface RemoveAndUpdate {
        public void removeListener();

        default public void updateListener() {
        }
    }
}

