/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility.javafx;

import bluej.Config;
import bluej.editor.stride.CodeOverlayPane;
import bluej.editor.stride.FXTabbedEditor;
import bluej.editor.stride.WindowOverlayPane;
import bluej.stride.generic.InteractionManager;
import bluej.utility.Debug;
import bluej.utility.Utility;
import bluej.utility.javafx.FXBiConsumer;
import bluej.utility.javafx.FXCache;
import bluej.utility.javafx.FXConsumer;
import bluej.utility.javafx.FXFunction;
import bluej.utility.javafx.FXPlatformBiFunction;
import bluej.utility.javafx.FXPlatformConsumer;
import bluej.utility.javafx.FXPlatformRunnable;
import bluej.utility.javafx.FXPlatformSupplier;
import bluej.utility.javafx.FXRunnable;
import bluej.utility.javafx.FXSupplier;
import java.awt.AWTKeyStroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javafx.animation.FadeTransition;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.binding.DoubleExpression;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.binding.StringExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableDoubleValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableSet;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.SimpleStyleableDoubleProperty;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.SnapshotParameters;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputControl;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.input.InputEvent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.Duration;
import javax.imageio.ImageIO;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import threadchecker.OnThread;
import threadchecker.Tag;

public class JavaFXUtil {
    private static final FXCache<Font, FXCache<String, Double>> measured = new FXCache<Font, FXCache>(f -> new FXCache<String, Double>(s -> {
        if (s == null || s.length() == 0) {
            return 0.0;
        }
        Text text = new Text(s);
        text.setFont(f);
        return text.getLayoutBounds().getWidth();
    }, 10000), 3);

    public static void setPseudoclass(String pseudoClassName, boolean enabled, Node ... nodes) {
        if (!pseudoClassName.startsWith("bj-")) {
            throw new IllegalArgumentException("Our pseudoclasses should begin with bj- to avoid confusion with JavaFX's pseudo classes");
        }
        for (Node node : nodes) {
            node.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)pseudoClassName), enabled);
        }
    }

    public static boolean hasPseudoclass(Styleable node, String pseudoClassName) {
        return node.getPseudoClassStates().stream().filter(p -> p.getPseudoClassName().equals(pseudoClassName)).count() > 0L;
    }

    public static void selectPseudoClass(Node node, int index, String ... pseudoClasses) {
        for (int i = 0; i < pseudoClasses.length; ++i) {
            JavaFXUtil.setPseudoclass(pseudoClasses[i], i == index, node);
        }
    }

    public static void addStyleClass(Styleable node, String ... styleClasses) {
        for (String styleClass : styleClasses) {
            if (node.getStyleClass().contains((Object)styleClass)) continue;
            node.getStyleClass().add((Object)styleClass);
        }
    }

    public static <T extends Styleable> T withStyleClass(T node, String ... styleClasses) {
        JavaFXUtil.addStyleClass(node, styleClasses);
        return node;
    }

    @Deprecated
    public static void removeStyleClass(Styleable node, String ... styleClasses) {
        node.getStyleClass().removeAll((Object[])styleClasses);
    }

    public static double measureString(TextInputControl node, String str) {
        return JavaFXUtil.measureString(node, str, true, true);
    }

    public static double measureString(TextInputControl node, String str, boolean includeLeftInset, boolean includeRightInset) {
        return JavaFXUtil.measureString(node, str, node.getFont(), includeLeftInset, includeRightInset);
    }

    public static double measureString(TextInputControl node, String str, Font overrideFont, boolean includeLeftInset, boolean includeRightInset) {
        return measured.get(overrideFont).get(str) + (includeLeftInset ? node.getInsets().getLeft() : 0.0) + (includeRightInset ? node.getInsets().getRight() : 0.0);
    }

    public static double measureString(Labeled node, String str) {
        return measured.get(node.getFont()).get(str) + node.getLabelPadding().getLeft() + node.getLabelPadding().getRight() + node.getPadding().getLeft() + node.getPadding().getRight();
    }

    public static <T extends Styleable> CssMetaData<T, Number> cssSize(String propertyName, final Function<T, SimpleStyleableDoubleProperty> propGetter) {
        return new CssMetaData<T, Number>(propertyName, StyleConverter.getSizeConverter()){

            public boolean isSettable(T node) {
                return true;
            }

            public StyleableProperty<Number> getStyleableProperty(T node) {
                return (StyleableProperty)propGetter.apply(node);
            }
        };
    }

    public static <T extends Styleable> CssMetaData<T, Color> cssColor(String propertyName, final Function<T, SimpleStyleableObjectProperty<Color>> propGetter) {
        return new CssMetaData<T, Color>(propertyName, StyleConverter.getColorConverter()){

            public boolean isSettable(T node) {
                return true;
            }

            public StyleableProperty<Color> getStyleableProperty(T node) {
                return (StyleableProperty)propGetter.apply(node);
            }
        };
    }

    public static <T extends Styleable> CssMetaData<T, Insets> cssInsets(String propertyName, final Function<T, StyleableObjectProperty<Insets>> propGetter) {
        return new CssMetaData<T, Insets>(propertyName, StyleConverter.getInsetsConverter(), Insets.EMPTY){

            public boolean isSettable(T node) {
                return true;
            }

            public StyleableProperty<Insets> getStyleableProperty(T node) {
                return (StyleableProperty)propGetter.apply(node);
            }
        };
    }

    public static void writeImageTo(WritableImage image, String filename) {
        File file = new File(filename);
        BufferedImage renderedImage = SwingFXUtils.fromFXImage((Image)image, null);
        try {
            ImageIO.write((RenderedImage)renderedImage, "png", file);
        }
        catch (IOException e) {
            Debug.reportError(e);
        }
    }

    public static void workAroundFunctionKeyBug(TextField field) {
        field.addEventHandler(KeyEvent.KEY_RELEASED, e -> {
            switch (e.getCode()) {
                case F1: 
                case F2: 
                case F3: 
                case F4: 
                case F5: 
                case F6: 
                case F7: 
                case F8: 
                case F9: 
                case F10: 
                case F11: 
                case F12: {
                    Runnable r = (Runnable)field.getScene().getAccelerators().get((Object)new KeyCodeCombination(e.getCode(), new KeyCombination.Modifier[0]));
                    if (r == null) break;
                    r.run();
                    e.consume();
                    break;
                }
            }
        });
    }

    public static Label cloneLabel(Label l, ObservableValue<String> fontSize) {
        Label copy = new Label();
        copy.textProperty().bind((ObservableValue)l.textProperty());
        JavaFXUtil.bindList(copy.getStyleClass(), l.getStyleClass());
        copy.styleProperty().bind((ObservableValue)l.styleProperty().concat((Object)"-fx-font-size:").concat(fontSize).concat((Object)";"));
        JavaFXUtil.bindPseudoclasses((Node)copy, (ObservableSet<PseudoClass>)l.getPseudoClassStates());
        return copy;
    }

    public static void blitImage(WritableImage dest, int xOffset, int yOffset, Image src) {
        dest.getPixelWriter().setPixels(xOffset, yOffset, (int)Math.ceil(src.getWidth()), (int)Math.ceil(src.getHeight()), src.getPixelReader(), 0, 0);
    }

    public static <S, T> ObservableValue<T> apply(ObservableValue<S> object, FXFunction<S, ObservableValue<T>> property, T def) {
        SimpleObjectProperty r = new SimpleObjectProperty(object.getValue() == null ? def : property.apply(object.getValue()).getValue());
        JavaFXUtil.addChangeListener(object, arg_0 -> JavaFXUtil.lambda$apply$4((ObjectProperty)r, def, property, arg_0));
        return r;
    }

    public static ReadOnlyBooleanProperty delay(ObservableBooleanValue source, final Duration delayToTrue, final Duration delayToFalse) {
        final SimpleBooleanProperty delayed = new SimpleBooleanProperty(source.get());
        source.addListener((ChangeListener)new ChangeListener<Boolean>(){
            private FXPlatformRunnable cancel = null;

            @OnThread(value=Tag.FXPlatform, ignoreParent=true)
            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (this.cancel != null) {
                    this.cancel.run();
                }
                this.cancel = newValue != false ? JavaFXUtil.runAfter(delayToTrue, () -> delayed.set(true)) : JavaFXUtil.runAfter(delayToFalse, () -> delayed.set(false));
            }
        });
        return delayed;
    }

    @OnThread(value=Tag.FX)
    public static void ifOnPlatform(FXPlatformRunnable action) {
        if (Platform.isFxApplicationThread()) {
            ((Runnable)action::run).run();
        }
    }

    public static void addFocusListener(Stage focusTarget, FXPlatformConsumer<Boolean> listener) {
        focusTarget.focusedProperty().addListener((obs, oldVal, newVal) -> ((FXConsumer<Boolean>)listener::accept).accept((Boolean)newVal));
    }

    public static void addFocusListener(Node focusTarget, FXPlatformConsumer<Boolean> listener) {
        focusTarget.focusedProperty().addListener((obs, oldVal, newVal) -> ((FXConsumer<Boolean>)listener::accept).accept((Boolean)newVal));
    }

    @OnThread(value=Tag.Any)
    public static void runNowOrLater(FXPlatformRunnable action) {
        if (Platform.isFxApplicationThread()) {
            ((Runnable)action::run).run();
        } else {
            Platform.runLater(action::run);
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public static boolean confirmDialog(String titleLabel, String messageLabel, Stage parent) {
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION, Config.getString(messageLabel), new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        alert.setTitle(Config.getString(titleLabel));
        alert.setHeaderText(alert.getTitle());
        alert.initOwner((Window)parent);
        alert.initModality(Modality.WINDOW_MODAL);
        Optional pressed = alert.showAndWait();
        return ButtonType.OK == pressed.orElse(ButtonType.CANCEL);
    }

    @OnThread(value=Tag.FXPlatform)
    public static void errorDialog(String titleLabel, String messageLabel) {
        Alert alert = new Alert(Alert.AlertType.ERROR, Config.getString(messageLabel), new ButtonType[]{ButtonType.OK});
        alert.setTitle(Config.getString(titleLabel));
        alert.setHeaderText(alert.getTitle());
        alert.showAndWait();
    }

    public static void bindPseudoclass(Node node, String pseudoClass, BooleanExpression on) {
        JavaFXUtil.addChangeListener(on, b -> JavaFXUtil.setPseudoclass(pseudoClass, b, node));
    }

    public static void scrollTo(ScrollPane scrollPane, Node target) {
        double scrollWidth = scrollPane.getContent().getBoundsInLocal().getWidth();
        double scrollHeight = scrollPane.getContent().getBoundsInLocal().getHeight();
        Bounds b = scrollPane.getContent().sceneToLocal(target.localToScene(target.getBoundsInLocal()));
        scrollPane.setHvalue(b.getMinX() / scrollWidth);
        scrollPane.setVvalue(b.getMinY() / scrollHeight);
    }

    @OnThread(value=Tag.Any)
    public static <T> T initFX(FXSupplier<T> initCode) {
        return (T)((Supplier<Object>)initCode::get).get();
    }

    public static ListBuilder<CssMetaData<? extends Styleable, ?>> extendCss(List<CssMetaData<? extends Styleable, ?>> superClassCssMetaData) {
        return new ListBuilder(superClassCssMetaData);
    }

    public static void listenForContextMenu(Node node, FXPlatformBiFunction<Double, Double, Boolean> showContextMenu, KeyCode ... otherKeys) {
        EventHandler popupHandler = e -> {
            if (e.isPopupTrigger() && ((Boolean)showContextMenu.apply(e.getScreenX(), e.getScreenY())).booleanValue()) {
                e.consume();
            }
        };
        node.addEventHandler(MouseEvent.MOUSE_PRESSED, popupHandler);
        node.addEventHandler(MouseEvent.MOUSE_RELEASED, popupHandler);
        node.addEventHandler(KeyEvent.KEY_PRESSED, e -> {
            Scene scene;
            Point2D scenePt;
            Point2D screenPt;
            if ((e.getCode() == KeyCode.CONTEXT_MENU || Arrays.asList(otherKeys).contains(e.getCode())) && ((Boolean)showContextMenu.apply((screenPt = (scenePt = node.localToScene(5.0, 5.0)).add((scene = node.getScene()).getWindow().getX() + scene.getX(), scene.getWindow().getY() + scene.getY())).getX(), screenPt.getY())).booleanValue()) {
                e.consume();
            }
        });
    }

    public static MenuItem makeMenuItem(String text, FXPlatformRunnable run, KeyCombination shortcut) {
        MenuItem item = new MenuItem(text);
        if (run != null) {
            item.setOnAction(e -> run.run());
        }
        if (shortcut != null) {
            item.setAccelerator(shortcut);
        }
        return item;
    }

    public static MenuItem makeMenuItem(StringExpression text, FXPlatformRunnable run, KeyCombination shortcut) {
        MenuItem item = new MenuItem();
        item.textProperty().bind((ObservableValue)text);
        if (run != null) {
            item.setOnAction(e -> run.run());
        }
        if (shortcut != null) {
            item.setAccelerator(shortcut);
        }
        return item;
    }

    public static MenuItem makeDisabledMenuItem(String text, KeyCombination shortcut) {
        MenuItem item = new MenuItem(text);
        item.setDisable(true);
        if (shortcut != null) {
            item.setAccelerator(shortcut);
        }
        return item;
    }

    public static CheckMenuItem makeCheckMenuItem(String text, Property<Boolean> state, KeyCombination shortcut) {
        CheckMenuItem item = new CheckMenuItem(text);
        item.selectedProperty().bindBidirectional(state);
        if (shortcut != null) {
            item.setAccelerator(shortcut);
        }
        return item;
    }

    public static Menu makeMenu(String text, MenuItem ... items) {
        Menu menu = new Menu(text);
        menu.getItems().setAll((Object[])items);
        return menu;
    }

    public static void initializeCustomTooltipCatalogue(final FXTabbedEditor window, Node target, String tooltipText, final Duration delay) {
        final Label l = new Label(tooltipText);
        l.visibleProperty().bind((ObservableValue)l.textProperty().isNotEmpty());
        l.setMouseTransparent(true);
        l.setWrapText(true);
        JavaFXUtil.addStyleClass((Styleable)l, "frame-tooltip");
        JavaFXUtil.setPseudoclass("bj-tight-border", true, new Node[]{l});
        l.setMaxWidth(300.0);
        final FXRunnable show = () -> {
            WindowOverlayPane overlayPane = window.getOverlayPane();
            double x = overlayPane.sceneXToWindowOverlayX(target.localToScene(target.getBoundsInLocal()).getMinX());
            double y = overlayPane.sceneYToWindowOverlayY(target.localToScene(target.getBoundsInLocal()).getMaxY() + 10.0);
            overlayPane.addOverlay((Node)l, (ObservableDoubleValue)new ReadOnlyDoubleWrapper(x), (ObservableDoubleValue)new ReadOnlyDoubleWrapper(y), true);
            FadeTransition ft = new FadeTransition(Duration.millis((double)100.0), (Node)l);
            ft.setFromValue(0.0);
            ft.setToValue(1.0);
            ft.play();
        };
        target.addEventFilter(MouseEvent.ANY, (EventHandler)new EventHandler<MouseEvent>(){
            FXPlatformRunnable cancel;

            @OnThread(value=Tag.FXPlatform)
            public void handle(MouseEvent event) {
                if (event.getEventType() == MouseEvent.MOUSE_ENTERED) {
                    this.cancel = JavaFXUtil.runAfter(delay, show);
                } else if (event.getEventType() == MouseEvent.MOUSE_EXITED) {
                    if (this.cancel != null) {
                        this.cancel.run();
                        this.cancel = null;
                    }
                    window.getOverlayPane().removeOverlay((Node)l);
                }
            }
        });
    }

    public static void initializeCustomHelp(InteractionManager editor, Node parent, FXConsumer<FXConsumer<String>> requestTooltip, boolean onHoverToo) {
        TooltipListener listener = new TooltipListener(editor, parent, requestTooltip);
        parent.addEventHandler(KeyEvent.KEY_PRESSED, (EventHandler)listener);
        JavaFXUtil.addFocusListener(parent, (FXPlatformConsumer<Boolean>)listener);
        if (onHoverToo) {
            parent.addEventHandler(MouseEvent.MOUSE_ENTERED, (EventHandler)listener);
            parent.addEventHandler(MouseEvent.MOUSE_EXITED, (EventHandler)listener);
        }
    }

    public static void onceInScene(Node node, FXPlatformRunnable action) {
        JavaFXUtil.onceNotNull(node.sceneProperty(), s -> JavaFXUtil.runNowOrLater(action));
    }

    public static <T6> void onceNotNull(ObservableValue<T6> observable, final FXConsumer<T6> callback) {
        Object t = observable.getValue();
        if (t != null) {
            callback.accept(t);
            return;
        }
        ChangeListener listener = new ChangeListener<T6>(){

            public void changed(ObservableValue<? extends T6> observable, T6 oldValue, T6 newVal) {
                if (newVal != null) {
                    callback.accept(newVal);
                    observable.removeListener((ChangeListener)this);
                }
            }
        };
        observable.addListener(listener);
    }

    public static void onceTrue(ObservableValue<Boolean> observable, final FXConsumer<Boolean> callback) {
        boolean value = (Boolean)observable.getValue();
        if (value) {
            callback.accept(value);
            return;
        }
        ChangeListener<Boolean> listener = new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newVal) {
                if (newVal.booleanValue()) {
                    callback.accept(newVal);
                    observable.removeListener((ChangeListener)this);
                }
            }
        };
        observable.addListener((ChangeListener)listener);
    }

    public static <SRC2, DEST2> void bindMap(final List<DEST2> dest, final ObservableList<SRC2> src, final Function<SRC2, DEST2> func, final FXConsumer<FXRunnable> changeWrapper) {
        changeWrapper.accept(() -> {
            dest.clear();
            dest.addAll(Utility.mapList(src, func));
        });
        src.addListener(new ListChangeListener<SRC2>(){

            public void onChanged(ListChangeListener.Change<? extends SRC2> changes) {
                changeWrapper.accept(() -> {
                    while (changes.next()) {
                        int i;
                        if (changes.wasPermutated() || changes.wasUpdated()) {
                            for (i = changes.getFrom(); i < changes.getTo(); ++i) {
                                dest.set(i, func.apply(src.get(i)));
                            }
                            continue;
                        }
                        for (i = 0; i < changes.getRemovedSize(); ++i) {
                            dest.remove(changes.getFrom());
                        }
                        for (i = 0; i < changes.getAddedSubList().size(); ++i) {
                            dest.add(i + changes.getFrom(), func.apply(changes.getAddedSubList().get(i)));
                        }
                    }
                });
            }
        });
    }

    public static <T> void bindFuture(CompletableFuture<T> future, FXPlatformConsumer<T> andThen) {
        future.thenAccept(x -> JavaFXUtil.runPlatformLater(() -> andThen.accept(x)));
    }

    public static <T> ObservableList<T> listBool(BooleanExpression putInList, T ... items) {
        ObservableList r = FXCollections.observableArrayList();
        if (putInList.get()) {
            r.setAll((Object[])items);
        }
        putInList.addListener((a, b, newVal) -> {
            if (newVal.booleanValue()) {
                r.setAll(items);
            } else {
                r.clear();
            }
        });
        return r;
    }

    public static <T> FXRunnable addSelfRemovingListener(final ObservableValue<T> prop, final FXConsumer<T> callback) {
        ChangeListener l = new ChangeListener<T>(){

            public void changed(ObservableValue<? extends T> observable, T oldValue, T newValue) {
                callback.accept(newValue);
                prop.removeListener((ChangeListener)this);
            }
        };
        prop.addListener(l);
        return () -> JavaFXUtil.lambda$addSelfRemovingListener$18(prop, (ChangeListener)l);
    }

    public static <T> FXRunnable bindList(ObservableList<? super T> dest, ObservableList<T> src) {
        ListChangeListener obs = c -> dest.setAll((Collection)src);
        src.addListener(obs);
        dest.setAll(src);
        return () -> src.removeListener(obs);
    }

    public static <T> FXRunnable addChangeListener(ObservableValue<T> property, FXConsumer<? super T> listener) {
        ChangeListener wrapped = (a, b, newVal) -> listener.accept(newVal);
        property.addListener(wrapped);
        return () -> property.removeListener(wrapped);
    }

    @OnThread(value=Tag.FXPlatform)
    public static <T> FXPlatformRunnable addChangeListenerPlatform(ObservableValue<T> property, FXPlatformConsumer<T> listener) {
        ChangeListener wrapped = (a, b, newVal) -> ((FXConsumer<Object>)listener::accept).accept(newVal);
        property.addListener(wrapped);
        return () -> property.removeListener(wrapped);
    }

    public static FXRunnable sequence(FXRunnable ... actions) {
        return () -> Arrays.stream(actions).forEach(FXRunnable::run);
    }

    @OnThread(value=Tag.FXPlatform)
    public static FXPlatformRunnable runAfter(Duration delay, FXPlatformRunnable task) {
        if (delay.lessThanOrEqualTo(Duration.ZERO)) {
            task.run();
            return () -> {};
        }
        SimpleBooleanProperty okToRun = new SimpleBooleanProperty(true);
        Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(delay, arg_0 -> JavaFXUtil.lambda$runAfter$27((BooleanProperty)okToRun, task, arg_0), new KeyValue[0])});
        timeline.setCycleCount(1);
        timeline.play();
        return () -> JavaFXUtil.lambda$runAfter$28((BooleanProperty)okToRun, timeline);
    }

    public static FXRunnable runRegular(Duration interval, FXRunnable task) {
        if (interval.lessThanOrEqualTo(Duration.ZERO)) {
            throw new IllegalArgumentException("Cannot run at a regular interval of zero or less");
        }
        SimpleBooleanProperty okToRun = new SimpleBooleanProperty(true);
        Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(interval, arg_0 -> JavaFXUtil.lambda$runRegular$29((BooleanProperty)okToRun, task, arg_0), new KeyValue[0])});
        timeline.setCycleCount(-1);
        timeline.setAutoReverse(false);
        timeline.play();
        return () -> JavaFXUtil.lambda$runRegular$30((BooleanProperty)okToRun, timeline);
    }

    public static DragType getDragModifiers(MouseEvent event) {
        boolean forceCopy = Config.isMacOS() ? event.isAltDown() : event.isShortcutDown();
        boolean forceMove = event.isShiftDown();
        if (forceCopy) {
            return DragType.FORCE_COPYING;
        }
        if (forceMove) {
            return DragType.FORCE_MOVING;
        }
        return DragType.DEFAULT;
    }

    public static void bindPseudoclasses(Node to, ObservableSet<PseudoClass> from) {
        from.addListener(c -> {
            if (c.wasAdded()) {
                to.pseudoClassStateChanged((PseudoClass)c.getElementAdded(), true);
            }
            if (c.wasRemoved()) {
                to.pseudoClassStateChanged((PseudoClass)c.getElementRemoved(), false);
            }
        });
        from.forEach(c -> to.pseudoClassStateChanged(c, true));
    }

    @OnThread(value=Tag.Swing)
    public static FXPlatformSupplier<MenuBar> swingMenuBarToFX(JMenuBar swingMenu, Object eventSource) {
        ArrayList<FXPlatformSupplier<Menu>> menus = new ArrayList<FXPlatformSupplier<Menu>>();
        for (int i = 0; i < swingMenu.getMenuCount(); ++i) {
            JMenu menu = swingMenu.getMenu(i);
            menus.add(JavaFXUtil.swingMenuToFX(menu, eventSource, (a, b) -> {}));
        }
        return () -> {
            MenuBar menuBar = new MenuBar();
            for (FXPlatformSupplier menuFXSupplier : menus) {
                menuBar.getMenus().add(menuFXSupplier.get());
            }
            return menuBar;
        };
    }

    @OnThread(value=Tag.Swing)
    public static FXPlatformSupplier<MenuBar> swingMenuBarToFX(List<SwingOrFXMenu> mixedMenus, Object eventSource) {
        List menus = mixedMenus.stream().map(m -> m.getFXMenu(eventSource)).collect(Collectors.toList());
        return () -> {
            MenuBar menuBar = new MenuBar();
            for (FXPlatformSupplier menuFXSupplier : menus) {
                menuBar.getMenus().add(menuFXSupplier.get());
            }
            return menuBar;
        };
    }

    @OnThread(value=Tag.Swing)
    private static FXPlatformSupplier<Menu> swingMenuToFX(JMenu swingMenu, Object source, FXBiConsumer<JMenuItem, MenuItem> extraConvert) {
        ArrayList<JMenuItem> items = new ArrayList<JMenuItem>();
        for (int i = 0; i < swingMenu.getItemCount(); ++i) {
            items.add(swingMenu.getItem(i));
        }
        String swingMenuTitle = swingMenu.getText();
        return JavaFXUtil.swingMenuToFX(items, source, () -> new Menu(swingMenuTitle), extraConvert);
    }

    @OnThread(value=Tag.Swing)
    public static FXPlatformSupplier<Menu> swingMenuToFX(List<JMenuItem> swingMenuItems, Object source, FXPlatformSupplier<Menu> createMenu, FXBiConsumer<JMenuItem, MenuItem> extraConvert) {
        ArrayList<FXPlatformSupplier<Object>> items = new ArrayList<FXPlatformSupplier<Object>>();
        ArrayList onShow = new ArrayList();
        for (JMenuItem item : swingMenuItems) {
            if (item == null) {
                items.add(JavaFXUtil.createMenuSeparator());
                continue;
            }
            if (item instanceof JMenu) {
                items.add(JavaFXUtil.swingMenuToFX((JMenu)item, source, extraConvert));
                continue;
            }
            FXPlatformSupplier<MenuItemAndShow> menuItemAndShowFXSupplier = JavaFXUtil.swingMenuItemToFX(item, source);
            FXPlatformSupplier<MenuItem> menuItemFXSupplier = () -> {
                MenuItemAndShow itemAndShow = (MenuItemAndShow)menuItemAndShowFXSupplier.get();
                if (itemAndShow.onShow != null) {
                    onShow.add(itemAndShow.onShow);
                }
                extraConvert.accept(item, itemAndShow.menuItem);
                return itemAndShow.menuItem;
            };
            items.add(menuItemFXSupplier);
        }
        return () -> {
            Menu menu = (Menu)createMenu.get();
            for (FXPlatformSupplier menuItemFXSupplier : items) {
                menu.getItems().add(menuItemFXSupplier.get());
            }
            menu.setOnShowing(e -> onShow.forEach(FXPlatformRunnable::run));
            return menu;
        };
    }

    @OnThread(value=Tag.Swing)
    public static FXPlatformRunnable swingMenuItemsToContextMenu(ContextMenu destination, List<JMenuItem> swingItems, Object source, FXBiConsumer<JMenuItem, MenuItem> extraConvert) {
        ArrayList<FXPlatformSupplier<Object>> items = new ArrayList<FXPlatformSupplier<Object>>();
        ArrayList onShow = new ArrayList();
        for (JMenuItem item : swingItems) {
            if (item == null) {
                items.add(JavaFXUtil.createMenuSeparator());
                continue;
            }
            if (item instanceof JMenu) {
                items.add(JavaFXUtil.swingMenuToFX((JMenu)item, source, extraConvert));
                continue;
            }
            FXPlatformSupplier<MenuItemAndShow> menuItemAndShowFXSupplier = JavaFXUtil.swingMenuItemToFX(item, source);
            FXPlatformSupplier<MenuItem> menuItemFXSupplier = () -> {
                MenuItemAndShow itemAndShow = (MenuItemAndShow)menuItemAndShowFXSupplier.get();
                if (itemAndShow.onShow != null) {
                    onShow.add(itemAndShow.onShow);
                }
                extraConvert.accept(item, itemAndShow.menuItem);
                return itemAndShow.menuItem;
            };
            items.add(menuItemFXSupplier);
        }
        return () -> {
            for (FXPlatformSupplier menuItemFXSupplier : items) {
                destination.getItems().add(menuItemFXSupplier.get());
            }
            destination.addEventHandler(WindowEvent.WINDOW_SHOWING, e -> onShow.forEach(FXPlatformRunnable::run));
        };
    }

    @OnThread(value=Tag.Any)
    private static FXPlatformSupplier<? extends MenuItem> createMenuSeparator() {
        return () -> new SeparatorMenuItem();
    }

    @OnThread(value=Tag.Swing)
    private static FXPlatformSupplier<MenuItemAndShow> swingMenuItemToFX(JMenuItem swingItem, Object source) {
        String menuText = swingItem.getText();
        ActionListener[] actionListeners = swingItem.getActionListeners();
        KeyStroke shortcut = swingItem.getAccelerator();
        if (swingItem instanceof JCheckBoxMenuItem) {
            JCheckBoxMenuItem checkBoxMenuItem = (JCheckBoxMenuItem)swingItem;
            boolean selected = checkBoxMenuItem.isSelected();
            return () -> {
                CheckMenuItem item = new CheckMenuItem(menuText);
                item.setSelected(selected);
                item.setOnAction(e -> SwingUtilities.invokeLater(() -> checkBoxMenuItem.setSelected(!checkBoxMenuItem.isSelected())));
                item.setAccelerator(JavaFXUtil.swingKeyStrokeToFX(shortcut));
                FXRunnable getStatus = () -> SwingUtilities.invokeLater(() -> {
                    boolean curSelected = checkBoxMenuItem.isSelected();
                    Platform.runLater(() -> item.setSelected(curSelected));
                });
                SwingUtilities.invokeLater(() -> swingItem.addPropertyChangeListener("enabled", e2 -> {
                    boolean enabled = swingItem.isEnabled();
                    Platform.runLater(() -> item.setDisable(!enabled));
                }));
                return new MenuItemAndShow((MenuItem)item, getStatus);
            };
        }
        if (swingItem instanceof JRadioButtonMenuItem) {
            throw new UnsupportedOperationException();
        }
        boolean startsEnabled = swingItem.isEnabled();
        MenuItem item = ((BiFunction<String, Boolean, MenuItem>)JavaFXUtil::makeFXMenuItem).apply(menuText, startsEnabled);
        swingItem.addPropertyChangeListener("enabled", e2 -> {
            boolean enabled = swingItem.isEnabled();
            Platform.runLater(() -> item.setDisable(!enabled));
        });
        swingItem.addPropertyChangeListener("action", e2 -> {
            boolean enabled = swingItem.isEnabled();
            String label = swingItem.getText();
            Platform.runLater(() -> {
                item.setDisable(!enabled);
                item.setText(label);
            });
        });
        return () -> {
            item.setOnAction(e -> SwingUtilities.invokeLater(() -> {
                Action action = swingItem.getAction();
                if (action != null) {
                    action.actionPerformed(new ActionEvent(source, 0, menuText));
                } else {
                    Arrays.stream(actionListeners).forEach(a -> a.actionPerformed(new ActionEvent(source, 0, menuText)));
                }
            }));
            item.setAccelerator(JavaFXUtil.swingKeyStrokeToFX(shortcut));
            return new MenuItemAndShow(item);
        };
    }

    private static MenuItem makeFXMenuItem(String menuText, boolean startsEnabled) {
        MenuItem item = new MenuItem(menuText);
        item.setDisable(!startsEnabled);
        return item;
    }

    private static KeyCombination swingKeyStrokeToFX(AWTKeyStroke shortcut) {
        KeyCode code;
        if (shortcut == null) {
            return null;
        }
        int modifiers = shortcut.getModifiers();
        ArrayList<KeyCombination.Modifier> fxModifiers = new ArrayList<KeyCombination.Modifier>();
        if ((modifiers & 0x40) != 0) {
            fxModifiers.add(KeyCombination.SHIFT_DOWN);
        }
        if ((modifiers & 0x80) != 0) {
            fxModifiers.add(KeyCombination.CONTROL_DOWN);
        }
        if ((modifiers & 0x100) != 0) {
            fxModifiers.add(KeyCombination.META_DOWN);
        }
        if ((code = JavaFXUtil.awtKeyCodeToFX(shortcut.getKeyCode())) != null) {
            return new KeyCodeCombination(code, fxModifiers.toArray(new KeyCombination.Modifier[0]));
        }
        return null;
    }

    private static KeyCode awtKeyCodeToFX(int code) {
        switch (code) {
            case 65: {
                return KeyCode.A;
            }
            case 66: {
                return KeyCode.B;
            }
            case 67: {
                return KeyCode.C;
            }
            case 68: {
                return KeyCode.D;
            }
            case 69: {
                return KeyCode.E;
            }
            case 70: {
                return KeyCode.F;
            }
            case 71: {
                return KeyCode.G;
            }
            case 72: {
                return KeyCode.H;
            }
            case 73: {
                return KeyCode.I;
            }
            case 74: {
                return KeyCode.J;
            }
            case 75: {
                return KeyCode.K;
            }
            case 76: {
                return KeyCode.L;
            }
            case 77: {
                return KeyCode.M;
            }
            case 78: {
                return KeyCode.N;
            }
            case 79: {
                return KeyCode.O;
            }
            case 80: {
                return KeyCode.P;
            }
            case 81: {
                return KeyCode.Q;
            }
            case 82: {
                return KeyCode.R;
            }
            case 83: {
                return KeyCode.S;
            }
            case 84: {
                return KeyCode.T;
            }
            case 85: {
                return KeyCode.U;
            }
            case 86: {
                return KeyCode.V;
            }
            case 87: {
                return KeyCode.W;
            }
            case 88: {
                return KeyCode.X;
            }
            case 89: {
                return KeyCode.Y;
            }
            case 90: {
                return KeyCode.Z;
            }
            case 48: {
                return KeyCode.DIGIT0;
            }
            case 49: {
                return KeyCode.DIGIT1;
            }
            case 50: {
                return KeyCode.DIGIT2;
            }
            case 51: {
                return KeyCode.DIGIT3;
            }
            case 52: {
                return KeyCode.DIGIT4;
            }
            case 53: {
                return KeyCode.DIGIT5;
            }
            case 54: {
                return KeyCode.DIGIT6;
            }
            case 55: {
                return KeyCode.DIGIT7;
            }
            case 56: {
                return KeyCode.DIGIT8;
            }
            case 57: {
                return KeyCode.DIGIT9;
            }
            case 44: {
                return KeyCode.COMMA;
            }
            case 46: {
                return KeyCode.PERIOD;
            }
            case 192: {
                return KeyCode.BACK_QUOTE;
            }
            case 92: {
                return KeyCode.BACK_SLASH;
            }
            case 47: {
                return KeyCode.SLASH;
            }
            case 9: {
                return KeyCode.TAB;
            }
            case 8: {
                return KeyCode.BACK_SPACE;
            }
            case 112: {
                return KeyCode.F1;
            }
            case 113: {
                return KeyCode.F2;
            }
            case 114: {
                return KeyCode.F3;
            }
            case 115: {
                return KeyCode.F4;
            }
            case 116: {
                return KeyCode.F5;
            }
            case 117: {
                return KeyCode.F6;
            }
            case 118: {
                return KeyCode.F7;
            }
            case 119: {
                return KeyCode.F8;
            }
            case 120: {
                return KeyCode.F9;
            }
            case 121: {
                return KeyCode.F10;
            }
            case 122: {
                return KeyCode.F11;
            }
            case 123: {
                return KeyCode.F12;
            }
            case 61440: {
                return KeyCode.F13;
            }
            case 61441: {
                return KeyCode.F14;
            }
            case 61442: {
                return KeyCode.F15;
            }
            case 61443: {
                return KeyCode.F16;
            }
            case 61444: {
                return KeyCode.F17;
            }
            case 61445: {
                return KeyCode.F18;
            }
            case 61446: {
                return KeyCode.F19;
            }
            case 61447: {
                return KeyCode.F20;
            }
            case 61448: {
                return KeyCode.F21;
            }
            case 61449: {
                return KeyCode.F22;
            }
            case 61450: {
                return KeyCode.F23;
            }
            case 61451: {
                return KeyCode.F24;
            }
            case 59: {
                return KeyCode.SEMICOLON;
            }
            case 513: {
                return KeyCode.COLON;
            }
            case 520: {
                return KeyCode.NUMBER_SIGN;
            }
            case 10: {
                return KeyCode.ENTER;
            }
            case 155: {
                return KeyCode.INSERT;
            }
            case 36: {
                return KeyCode.HOME;
            }
            case 127: {
                return KeyCode.DELETE;
            }
            case 35: {
                return KeyCode.END;
            }
            case 33: {
                return KeyCode.PAGE_UP;
            }
            case 34: {
                return KeyCode.PAGE_DOWN;
            }
        }
        return null;
    }

    public static <T, R> ObjectBinding<R> of(ObservableValue<T> t, FXFunction<T, R> accessor) {
        return Bindings.createObjectBinding(() -> accessor.apply(t.getValue()), (Observable[])new Observable[]{t});
    }

    public static <T> DoubleBinding ofD(ObservableValue<T> t, FXFunction<T, Double> accessor) {
        return Bindings.createDoubleBinding(() -> (Double)accessor.apply(t.getValue()), (Observable[])new Observable[]{t});
    }

    @OnThread(value=Tag.FXPlatform)
    public static void runAfterCurrent(FXPlatformRunnable r) {
        ((FXPlatformConsumer<Runnable>)Platform::runLater).accept(r::run);
    }

    @OnThread(value=Tag.FX)
    public static void runPlatformLater(FXPlatformRunnable r) {
        Platform.runLater(r::run);
    }

    public static void stripeRect(GraphicsContext g, int x, int y, int width, int height, int separation, int thickness, boolean backslash, Color color) {
        Paint prev = g.getStroke();
        g.setStroke((Paint)color);
        g.setLineWidth((double)thickness);
        for (int offset = separation / 2; offset < width + height; offset += separation + thickness) {
            int y2;
            int x2;
            int y1;
            int x1;
            if (offset < height) {
                x1 = x;
                y1 = y + offset;
            } else {
                x1 = x + offset - height;
                y1 = y + height;
            }
            if (offset < width) {
                x2 = x + offset;
                y2 = y;
            } else {
                x2 = x + width;
                y2 = y + offset - width;
            }
            if (backslash) {
                x1 = width - x1;
                x2 = width - x2;
            }
            g.strokeLine((double)x1, (double)y1, (double)x2, (double)y2);
        }
        g.setStroke(prev);
    }

    public static Image createImage(int width, int height, FXConsumer<GraphicsContext> draw) {
        Canvas c = new Canvas((double)width, (double)height);
        Scene s = new Scene((Parent)new StackPane(new Node[]{c}));
        draw.accept(c.getGraphicsContext2D());
        WritableImage image = new WritableImage(width, height);
        SnapshotParameters p = new SnapshotParameters();
        p.setFill((Paint)Color.TRANSPARENT);
        c.snapshot(p, image);
        return image;
    }

    private static /* synthetic */ void lambda$runRegular$30(BooleanProperty okToRun, Timeline timeline) {
        okToRun.set(false);
        timeline.stop();
    }

    private static /* synthetic */ void lambda$runRegular$29(BooleanProperty okToRun, FXRunnable task, javafx.event.ActionEvent e) {
        if (okToRun.get()) {
            task.run();
        }
    }

    private static /* synthetic */ void lambda$runAfter$28(BooleanProperty okToRun, Timeline timeline) {
        okToRun.set(false);
        timeline.stop();
    }

    private static /* synthetic */ void lambda$runAfter$27(BooleanProperty okToRun, FXPlatformRunnable task, javafx.event.ActionEvent e) {
        if (okToRun.get()) {
            task.run();
        }
    }

    private static /* synthetic */ void lambda$addSelfRemovingListener$18(ObservableValue prop, ChangeListener l) {
        prop.removeListener(l);
    }

    private static /* synthetic */ void lambda$apply$4(ObjectProperty r, Object def, FXFunction property, Object value) {
        r.unbind();
        if (value == null) {
            r.setValue(def);
        } else {
            r.bind((ObservableValue)property.apply(value));
        }
    }

    private static class MenuItemAndShow {
        private final MenuItem menuItem;
        private final FXRunnable onShow;

        public MenuItemAndShow(MenuItem menuItem, FXRunnable onShow) {
            this.menuItem = menuItem;
            this.onShow = onShow;
        }

        public MenuItemAndShow(MenuItem menuItem) {
            this(menuItem, null);
        }
    }

    public static class FXPlusSwingMenu
    implements SwingOrFXMenu {
        private final FXPlatformSupplier<Menu> createFXMenu;
        private final List<JMenuItem> swingItems = new ArrayList<JMenuItem>();
        private final List<FXPlatformSupplier<MenuItem>> fxItems = new ArrayList<FXPlatformSupplier<MenuItem>>();
        private final List<Integer> fxItemIndexes = new ArrayList<Integer>();
        private @OnThread(value=Tag.Swing) int nextIndex = 0;
        private Runnable atEnd;

        @OnThread(value=Tag.Swing)
        public FXPlusSwingMenu(FXPlatformSupplier<Menu> createMenu) {
            this.createFXMenu = createMenu;
        }

        @Override
        @OnThread(value=Tag.Swing)
        public FXPlatformSupplier<Menu> getFXMenu(Object eventSource) {
            FXPlatformSupplier<Menu> swingAdd = JavaFXUtil.swingMenuToFX(this.swingItems, eventSource, this.createFXMenu, (a, b) -> {});
            return () -> {
                Menu fxMenu = (Menu)swingAdd.get();
                for (int i = 0; i < this.fxItems.size(); ++i) {
                    MenuItem item = this.fxItems.get(i).get();
                    fxMenu.getItems().add(this.fxItemIndexes.get(i).intValue(), (Object)item);
                }
                if (this.atEnd != null) {
                    SwingUtilities.invokeLater(this.atEnd);
                }
                return fxMenu;
            };
        }

        @OnThread(value=Tag.Swing)
        public void addFX(FXPlatformSupplier<MenuItem> fxItem) {
            this.fxItems.add(fxItem);
            this.fxItemIndexes.add(this.nextIndex++);
        }

        @OnThread(value=Tag.Swing)
        public void addSwing(List<JMenuItem> swingItems) {
            this.swingItems.addAll(swingItems);
            this.nextIndex += swingItems.size();
        }

        @OnThread(value=Tag.Swing)
        public void runAtEnd(Runnable runnable) {
            this.atEnd = runnable;
        }
    }

    public static class FXOnlyMenu
    implements SwingOrFXMenu {
        private final Menu fxMenu;

        @OnThread(value=Tag.Any)
        public FXOnlyMenu(Menu fxMenu) {
            this.fxMenu = fxMenu;
        }

        @Override
        @OnThread(value=Tag.Swing)
        public FXPlatformSupplier<Menu> getFXMenu(Object eventSource) {
            return () -> this.fxMenu;
        }
    }

    public static class SwingMenu
    implements SwingOrFXMenu {
        private final JMenu swingMenu;

        @OnThread(value=Tag.Any)
        public SwingMenu(JMenu swingMenu) {
            this.swingMenu = swingMenu;
        }

        @Override
        @OnThread(value=Tag.Swing)
        public FXPlatformSupplier<Menu> getFXMenu(Object eventSource) {
            return JavaFXUtil.swingMenuToFX(this.swingMenu, eventSource, (a, b) -> {});
        }
    }

    public static interface SwingOrFXMenu {
        @OnThread(value=Tag.Swing)
        public FXPlatformSupplier<Menu> getFXMenu(Object var1);
    }

    public static enum DragType {
        FORCE_COPYING,
        FORCE_MOVING,
        DEFAULT;

    }

    @OnThread(value=Tag.FXPlatform)
    private static class TooltipListener
    implements EventHandler<InputEvent>,
    FXPlatformConsumer<Boolean> {
        private Label l;
        private final InteractionManager editor;
        private final Node parent;
        private final FXConsumer<FXConsumer<String>> requestTooltip;
        private FXPlatformRunnable cancelHoverShow = null;
        private boolean showing = false;
        private boolean mouseShown = false;

        @OnThread(value=Tag.FX)
        private TooltipListener(InteractionManager editor, Node parent, FXConsumer<FXConsumer<String>> requestTooltip) {
            this.editor = editor;
            this.parent = parent;
            this.requestTooltip = requestTooltip;
        }

        @OnThread(value=Tag.FXPlatform)
        public void handle(InputEvent original) {
            if (original instanceof KeyEvent) {
                KeyEvent event = (KeyEvent)original;
                if (event.getCode() == KeyCode.F1 && !this.showing) {
                    this.mouseShown = false;
                    if (this.cancelHoverShow != null) {
                        this.cancelHoverShow.run();
                        this.cancelHoverShow = null;
                    }
                    this.show();
                    event.consume();
                }
                if (event.getCode() == KeyCode.ESCAPE && this.showing && !this.mouseShown) {
                    this.hide();
                }
            } else if (original instanceof MouseEvent) {
                MouseEvent event = (MouseEvent)original;
                if (event.getEventType() == MouseEvent.MOUSE_ENTERED) {
                    if (this.cancelHoverShow != null) {
                        this.cancelHoverShow.run();
                        this.cancelHoverShow = null;
                    }
                    if (!this.showing) {
                        this.cancelHoverShow = JavaFXUtil.runAfter(Duration.millis((double)1000.0), () -> {
                            this.mouseShown = true;
                            this.show();
                        });
                    }
                } else if (event.getEventType() == MouseEvent.MOUSE_EXITED) {
                    if (this.cancelHoverShow != null) {
                        this.cancelHoverShow.run();
                        this.cancelHoverShow = null;
                    }
                    if (this.showing && this.mouseShown) {
                        this.hide();
                    }
                }
            }
        }

        @OnThread(value=Tag.FXPlatform)
        private void show() {
            if (this.showing) {
                this.hide();
            }
            this.l = new Label();
            this.l.visibleProperty().bind((ObservableValue)this.l.textProperty().isNotEmpty());
            this.l.setMouseTransparent(true);
            this.l.setWrapText(true);
            JavaFXUtil.addStyleClass((Styleable)this.l, "frame-tooltip");
            this.requestTooltip.accept(arg_0 -> ((Label)this.l).setText(arg_0));
            this.editor.getCodeOverlayPane().addOverlay((Node)this.l, this.parent, null, (DoubleExpression)this.l.heightProperty().negate().subtract(5.0), CodeOverlayPane.WidthLimit.LIMIT_WIDTH_AND_SLIDE_LEFT);
            this.showing = true;
        }

        @Override
        @OnThread(value=Tag.FXPlatform)
        public void accept(Boolean newVal) {
            if (!newVal.booleanValue() && this.showing && !this.mouseShown) {
                this.hide();
            }
        }

        @OnThread(value=Tag.FXPlatform)
        private void hide() {
            if (this.showing) {
                this.editor.getCodeOverlayPane().removeOverlay((Node)this.l);
                this.l = null;
                this.showing = false;
            }
        }
    }

    public static class ListBuilder<T> {
        private ArrayList<T> list;

        private ListBuilder(List<T> list) {
            this.list = new ArrayList<T>(list);
        }

        public ListBuilder<T> add(T t) {
            this.list.add(t);
            return this;
        }

        public List<T> build() {
            return Collections.unmodifiableList(this.list);
        }
    }
}

